/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelpacket.server;

import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.ServerPluginChannels;
import com.thevoxelbox.voxelpacket.common.VoxelMessage;
import com.thevoxelbox.voxelpacket.common.VoxelPacket;
import com.thevoxelbox.voxelpacket.common.VoxelPacketHandlerBase;
import com.thevoxelbox.voxelpacket.common.interfaces.IPacketSenderDelegate;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessagePublisher;
import com.thevoxelbox.voxelpacket.common.interfaces.IVoxelMessageSubscriber;
import com.thevoxelbox.voxelpacket.common.struct.QueryResponse;
import com.thevoxelbox.voxelpacket.exceptions.InvalidPacketDataException;
import com.thevoxelbox.voxelpacket.exceptions.InvalidShortcodeException;
import com.thevoxelbox.voxelpacket.exceptions.MissingEncoderException;
import com.thevoxelbox.voxelpacket.exceptions.VoxelPacketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelPacketServer
extends VoxelPacketHandlerBase
implements IVoxelMessageSubscriber {
    private static final String VERSION = "2.2.0";
    private static final String QUERY_SHORTCODE = "@INFO";
    public static Class<? extends VoxelPacketServer> instanceClass = VoxelPacketServer.class;
    protected static VoxelPacketServer instance;
    protected Logger log = LogManager.getLogger((String)"VoxelPacket");
    protected HashMap<String, IPacketSenderDelegate> playerDelegates = new HashMap();
    private HashMap<String, ArrayList<String>> clientSubscriberMap = new HashMap();

    protected VoxelPacketServer() {
        VoxelPacket.registerServerPacketHandler(this);
        this.clientSubscriberMap.clear();
        this.subscribe(this, QUERY_SHORTCODE);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static VoxelPacketServer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("VoxelPacketServer.getInstance() called before initInstance()");
        }
        return instance;
    }

    public static VoxelPacketServer initInstance() {
        if (instance == null) {
            try {
                instance = instanceClass.newInstance();
            }
            catch (IllegalAccessException ex) {
                instance = new VoxelPacketServer();
            }
            catch (InstantiationException ex) {
                instance = new VoxelPacketServer();
            }
        }
        return instance;
    }

    protected ArrayList<String> getKnownSubsForPlayer(String playerName) {
        if (!this.clientSubscriberMap.containsKey(playerName)) {
            this.clientSubscriberMap.put(playerName, new ArrayList());
        }
        return this.clientSubscriberMap.get(playerName);
    }

    protected void addKnownSubForPlayer(String playerName, String sub) {
        ArrayList<String> subs = this.getKnownSubsForPlayer(playerName);
        if (!subs.contains(sub)) {
            subs.add(sub);
        }
    }

    @Override
    public void receiveMessage(IVoxelMessagePublisher publisher, VoxelMessage message) {
        if (message.hasShortCode(QUERY_SHORTCODE)) {
            QueryResponse response = (QueryResponse)message.data();
            if (response != null) {
                if (response.responseCode.equals("SUBS")) {
                    ArrayList subs = (ArrayList)response.data();
                    this.clientSubscriberMap.put(message.getSenderName(), subs);
                } else if (response.responseCode.equals("SUB")) {
                    String sub = (String)response.data();
                    this.addKnownSubForPlayer(message.getSenderName(), sub);
                }
            } else {
                this.log.warn("[VoxelPacket] Invalid query response from \"" + message.getSenderName() + "\", null payload");
            }
        }
    }

    @Override
    public void receiveMessageClassCastFailure(IVoxelMessagePublisher publisher, VoxelMessage message, ClassCastException ex) {
        this.log.warn("[VoxelPacket] Error processing query response from client " + message.getSenderName());
    }

    public void queryPlayer(mw player, String queryType) {
        try {
            this.log.info("[VoxelPacket] Sending subscription query to client " + player.b_());
            this.sendMessageTo(player, "@QUERY", queryType, null);
        }
        catch (VoxelPacketException voxelPacketException) {
            // empty catch block
        }
    }

    public void onPlayerQuit(mw player) {
        if (player != null) {
            this.clientSubscriberMap.remove(player.b_());
            this.playerDelegates.remove(player.b_());
        }
    }

    public void sendMessage(String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        IPacketSenderDelegate packetSender = this.getDelegateForAllPlayers();
        this.sendMessage(packetSender, shortCode, messageData, relevantEntity);
    }

    public void sendMessageTo(mw player, String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        IPacketSenderDelegate packetSender = this.getDelegateForPlayer(player);
        this.sendMessage(packetSender, shortCode, messageData, relevantEntity);
    }

    public void sendMessageToKnownSubscribers(String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        List<mw> players = this.getKnownSubscribers(shortCode);
        this.sendMessageToPlayers(players, shortCode, messageData, relevantEntity);
    }

    public void sendMessageToPlayers(List<mw> players, String shortCode, Object messageData, sa relevantEntity) throws MissingEncoderException, InvalidPacketDataException, InvalidShortcodeException {
        if (players != null && players.size() > 0) {
            IPacketSenderDelegate packetSender = this.getDelegateForPlayers(players);
            this.sendMessage(packetSender, shortCode, messageData, relevantEntity);
        }
    }

    protected void onSendPayloadToPlayer(mw player, String channel, byte[] payload) {
        try {
            if (player != null && payload != null) {
                ServerPluginChannels.sendMessage((mw)player, (String)channel, (byte[])payload, (PluginChannels.ChannelPolicy)PluginChannels.ChannelPolicy.DISPATCH_ALWAYS);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void dispatchMessage(ArrayList<IVoxelMessageSubscriber> subscribers, VoxelMessage message) {
        for (IVoxelMessageSubscriber subscriber : subscribers) {
            try {
                subscriber.receiveMessage(this, message);
            }
            catch (ClassCastException ex) {
                subscriber.receiveMessageClassCastFailure(this, message, ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected List<mw> getKnownSubscribers(String shortCode) {
        ArrayList<mw> subscribingPlayers = new ArrayList<mw>();
        for (Map.Entry<String, ArrayList<String>> subscriptionInfo : this.clientSubscriberMap.entrySet()) {
            bsx integratedServer;
            if (!subscriptionInfo.getValue().contains(shortCode) || (integratedServer = bao.B().H()) == null) continue;
            oi configurationManager = integratedServer.ah();
            mw player = configurationManager.a(subscriptionInfo.getKey());
            subscribingPlayers.add(player);
        }
        return subscribingPlayers;
    }

    protected IPacketSenderDelegate getDelegateForPlayer(mw player) {
        if (!this.playerDelegates.containsKey(player.b_())) {
            this.playerDelegates.put(player.b_(), new PlayerDelegate(player));
        }
        return this.playerDelegates.get(player.b_());
    }

    protected IPacketSenderDelegate getDelegateForPlayers(List<mw> players) {
        return new MultiplePlayerDelegate(players);
    }

    protected IPacketSenderDelegate getDelegateForAllPlayers() {
        return new BroadcastDelegate();
    }

    class BroadcastDelegate
    implements IPacketSenderDelegate {
        private final List<mw> players = new ArrayList<mw>();

        public BroadcastDelegate() {
            bsx integratedServer = bao.B().H();
            if (integratedServer != null) {
                oi configurationManager = integratedServer.ah();
                this.players.addAll(configurationManager.e);
            }
        }

        @Override
        public void sendPayload(String channel, byte[] payload) {
            for (mw player : this.players) {
                VoxelPacketServer.this.onSendPayloadToPlayer(player, channel, payload);
            }
        }
    }

    class MultiplePlayerDelegate
    implements IPacketSenderDelegate {
        private final List<mw> players;

        MultiplePlayerDelegate(List<mw> players) {
            this.players = players;
        }

        @Override
        public void sendPayload(String channel, byte[] payload) {
            for (mw player : this.players) {
                VoxelPacketServer.this.onSendPayloadToPlayer(player, channel, payload);
            }
        }
    }

    class PlayerDelegate
    implements IPacketSenderDelegate {
        private final mw player;

        PlayerDelegate(mw player) {
            this.player = player;
        }

        @Override
        public void sendPayload(String channel, byte[] payload) {
            VoxelPacketServer.this.onSendPayloadToPlayer(this.player, channel, payload);
        }
    }
}

