/*
 * Decompiled with CFR 0.152.
 */
package com.voxelmodpack.common;

import com.google.common.collect.ImmutableList;
import com.mumfrey.liteloader.PacketHandler;
import com.mumfrey.liteloader.Priority;
import com.voxelmodpack.common.interfaces.ITimeHandler;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

@Priority(value=0)
public class LiteModVoxelCommon
implements PacketHandler {
    public static final String VERSION = "2.4.0";
    public static final oa GUIPARTS = new oa("voxelcommon", "textures/gui/guiparts.png");
    private static List<ITimeHandler> timeHandlers = new LinkedList<ITimeHandler>();

    public String getName() {
        return "VoxelLib";
    }

    public String getVersion() {
        return VERSION;
    }

    public void init(File configPath) {
    }

    public void upgradeSettings(String version, File configPath, File oldConfigPath) {
    }

    public List<Class<? extends id>> getHandledPackets() {
        return ImmutableList.of(li.class);
    }

    public boolean handlePacket(hg netHandler, id packet) {
        li timeUpdatePacket = (li)packet;
        LiteModVoxelCommon.updateTime(netHandler, timeUpdatePacket.a(), timeUpdatePacket.b());
        return false;
    }

    public static void registerTimeHandler(ITimeHandler timeHandler) {
        if (!timeHandlers.contains(timeHandler)) {
            timeHandlers.add(timeHandler);
        }
    }

    public static void updateTime(long totalTime, long worldTime) {
        bsu mc = bsu.z();
        if (mc.h != null && mc.h.a != null) {
            LiteModVoxelCommon.updateTime((hg)mc.h.a, totalTime, worldTime);
        }
    }

    private static void updateTime(hg netHandler, long totalTime, long worldTime) {
        boolean frozen = worldTime < 0L;
        worldTime = Math.abs(worldTime);
        long inTotalTime = totalTime;
        long inWorldTime = worldTime;
        for (ITimeHandler timeHandler : timeHandlers) {
            timeHandler.onTimeUpdate(totalTime, worldTime);
        }
        for (ITimeHandler timeHandler : timeHandlers) {
            if (timeHandler.isFreezingTime()) {
                frozen = true;
                totalTime = timeHandler.getFrozenTotalTime(inTotalTime);
                worldTime = timeHandler.getFrozenWorldTime(inWorldTime);
                break;
            }
            worldTime += timeHandler.getTimeOffset();
        }
        ((ik)netHandler).a(new li(totalTime, worldTime, !frozen));
    }
}

