/*
 * Decompiled with CFR 0.152.
 */
package com.voxelmodpack.common.properties;

import com.voxelmodpack.common.gui.interfaces.IExtendedGui;
import com.voxelmodpack.common.properties.VoxelProperty;
import com.voxelmodpack.common.properties.interfaces.IVoxelPropertyProvider;

public abstract class VoxelPropertyAbstractTextField<PropertyType extends IVoxelPropertyProvider>
extends VoxelProperty<PropertyType> {
    protected String allowedCharacters = "0123456789";
    protected String fieldValue = "0";
    protected String defaultFieldValue = "0";
    protected int fieldOffset = 74;
    protected int fieldWidth = 52;
    protected int fieldHeight = 16;

    public VoxelPropertyAbstractTextField(IVoxelPropertyProvider propertyProvider, String binding, String displayText, int xPos, int yPos, int fieldOffset) {
        super(propertyProvider, binding, displayText, xPos, yPos);
        this.fieldValue = this.propertyProvider.getStringProperty(binding);
        this.defaultFieldValue = this.propertyProvider.getDefaultPropertyValue(this.propertyBinding);
        this.fieldOffset = fieldOffset;
    }

    @Override
    public void draw(IExtendedGui host, int mouseX, int mouseY) {
        VoxelPropertyAbstractTextField.a((int)(this.xPosition + this.fieldOffset + this.fieldWidth), (int)(this.yPosition + this.fieldHeight), (int)(this.xPosition + this.fieldOffset), (int)(this.yPosition - 1), (int)(this.focused ? -1 : -6710887));
        VoxelPropertyAbstractTextField.a((int)(this.xPosition + this.fieldOffset + this.fieldWidth - 1), (int)(this.yPosition + this.fieldHeight - 1), (int)(this.xPosition + this.fieldOffset + 1), (int)this.yPosition, (int)-16777216);
        boolean optionCursor = this.focused && this.cursorCounter / 6 % 2 == 0;
        this.c(this.fontRenderer, this.displayText, this.xPosition, this.yPosition + 4, 0xFFFFFF);
        this.c(this.fontRenderer, this.fieldValue + (optionCursor ? "_" : ""), this.fieldValue.length() > 0 ? this.xPosition + this.fieldOffset + this.fieldWidth / 2 - this.fontRenderer.a(this.fieldValue) / 2 : this.xPosition + this.fieldOffset + this.fieldWidth / 2 - 3, this.yPosition + 4, 0xFFFFFF);
    }

    @Override
    public void keyTyped(char keyChar, int keyCode) {
        if (this.focused) {
            if (keyCode == 28 || keyCode == 156 || keyCode == 1) {
                this.onLostFocus();
            }
            if (keyCode == 14 && this.fieldValue.length() > 0) {
                this.fieldValue = this.fieldValue.substring(0, this.fieldValue.length() - 1);
            }
            if (keyCode == 52 && this.allowedCharacters.indexOf(46) >= 0) {
                if (this.fieldValue.indexOf(keyChar) >= 0) {
                    return;
                }
                if (this.fieldValue.length() == 0) {
                    this.fieldValue = this.fieldValue + "0";
                }
            }
            if (this.allowedCharacters.indexOf(keyChar) >= 0 && this.fieldValue.length() < 4) {
                this.fieldValue = this.fieldValue + keyChar;
            }
            if (this.checkInvalidValue()) {
                this.fieldValue = this.defaultFieldValue;
            }
        }
    }

    protected abstract boolean checkInvalidValue();

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        boolean mouseOver = this.mouseOver(mouseX, mouseY);
        if (!this.focused && mouseOver) {
            this.playClickSound(this.mc.U());
            this.fieldValue = this.propertyProvider.getStringProperty(this.propertyBinding);
        } else if (this.focused && !mouseOver) {
            this.onLostFocus();
        }
        this.focused = mouseOver;
    }

    @Override
    public void onClosed() {
        this.onLostFocus();
    }

    protected abstract void onLostFocus();

    public boolean mouseOver(int mouseX, int mouseY) {
        return mouseX > this.xPosition + this.fieldOffset && mouseX < this.xPosition + this.fieldOffset + this.fieldWidth && mouseY > this.yPosition && mouseY < this.yPosition + 15;
    }

    public void update() {
        this.fieldValue = this.propertyProvider.getStringProperty(this.propertyBinding);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setFocused(boolean focus) {
        if (this.focused && !focus) {
            this.onLostFocus();
        }
        this.focused = focus;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }
}

