/*
 * Decompiled with CFR 0.152.
 */
package com.voxelmodpack.common.properties.gui;

import com.mumfrey.liteloader.gl.GL;
import com.mumfrey.liteloader.modconfig.ConfigPanel;
import com.mumfrey.liteloader.modconfig.ConfigPanelHost;
import com.voxelmodpack.common.LiteModVoxelCommon;
import com.voxelmodpack.common.gui.GuiScreenEx;
import com.voxelmodpack.common.properties.ModConfig;
import com.voxelmodpack.common.properties.VoxelProperty;
import com.voxelmodpack.common.properties.gui.SettingsPanelManager;
import java.io.IOException;
import java.util.ArrayList;

public abstract class GuiVoxelBoxSettingsPanel
extends GuiScreenEx
implements ConfigPanel {
    protected ModConfig config;
    protected ArrayList<VoxelProperty<?>> properties = new ArrayList();
    protected static int PANEL_WIDTH = 330;
    protected static int PANEL_LEFT = 97;
    protected static int PANEL_TOP = 0;
    protected static int PANEL_HEIGHT = 220;
    protected static int TAB_SPACING = 2;
    protected boolean overCloseButton = false;
    protected SettingsPanelManager panelManager = SettingsPanelManager.getInstance();
    protected boolean isPanel = false;
    protected int contentHeight = 240;

    public ModConfig getConfig() {
        return this.config;
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        this.setTexMapSize(256);
        GL.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL.glEnableBlend();
        GL.glBlendFunc((int)770, (int)771);
        int right = PANEL_LEFT + PANEL_WIDTH;
        int bottom = PANEL_TOP + PANEL_HEIGHT;
        this.e = -50.0f;
        this.drawTabs(mouseX, mouseY, partialTicks, true);
        this.drawPanel(right, bottom);
        this.drawTabs(mouseX, mouseY, partialTicks, false);
        this.e = 0.0f;
        this.drawCloseButton(mouseX, mouseY, right - 4, PANEL_TOP + 20);
        for (VoxelProperty<?> property : this.properties) {
            if (!property.isVisible()) continue;
            property.draw(this, mouseX, mouseY);
        }
    }

    protected void drawPanel(int right, int bottom) {
        PANEL_HEIGHT = Math.max(220, this.m - PANEL_TOP - 2);
        this.e = -100.0f;
        GL.glEnableDepthTest();
        this.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, PANEL_LEFT, PANEL_TOP, right, bottom, 0, 16, 16, 32, 4);
        this.zDrop();
        this.drawDepthRect(PANEL_LEFT + 1, PANEL_TOP + 1, right - 1, bottom - 1, Integer.MIN_VALUE);
        GL.glDisableDepthTest();
    }

    protected void drawTabs(int mouseX, int mouseY, float partialTicks, boolean mask) {
        this.zDrop();
        this.panelManager.renderTabs(this, mouseX, mouseY, partialTicks, PANEL_LEFT, PANEL_TOP, TAB_SPACING, mask);
    }

    protected void a(int mouseX, int mouseY, int button) throws IOException {
        if (this.overCloseButton) {
            this.onClosed();
            this.j.a(null);
            return;
        }
        if (!this.panelManager.mouseClicked(this, mouseX, mouseY, button, PANEL_LEFT, PANEL_TOP, TAB_SPACING)) {
            super.a(mouseX, mouseY, button);
            for (VoxelProperty<?> property : this.properties) {
                if (!property.isVisible()) continue;
                property.mouseClicked(mouseX, mouseY);
            }
        }
    }

    protected void onClosed() {
        for (VoxelProperty<?> property : this.properties) {
            property.onClosed();
        }
    }

    protected void a(char keyChar, int keyCode) throws IOException {
        super.a(keyChar, keyCode);
        this.keyPressed(null, keyChar, keyCode);
    }

    public void e() {
        super.e();
        for (VoxelProperty<?> property : this.properties) {
            property.updateCursorCounter();
        }
    }

    public void zDrop() {
        this.e -= 1.0f;
    }

    protected boolean mouseIn(int mouseX, int mouseY, int x, int y, int x2, int y2) {
        return mouseX > x && mouseX < x2 && mouseY > y && mouseY < y2;
    }

    protected void drawCloseButton(int mouseX, int mouseY, int right, int top) {
        this.overCloseButton = this.mouseIn(mouseX, mouseY, right - 15, top - 16, right, top - 1);
        int v = this.overCloseButton ? 32 : 0;
        this.drawDepthRect(right - 1, top - 2, right - 14, top - 15, Integer.MIN_VALUE);
        this.drawTessellatedModalBorderRect(LiteModVoxelCommon.GUIPARTS, 256, this.overCloseButton ? right - 16 : right - 15, this.overCloseButton ? top - 17 : top - 16, this.overCloseButton ? right + 1 : right, this.overCloseButton ? top : top - 1, 0, v, 16, 16 + v, 4);
        this.c(this.j.k, "x", right - 10, top - 13, this.overCloseButton ? 0x55FFFF : 0xAAAAAA);
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void onPanelShown(ConfigPanelHost host) {
        this.j = bsu.z();
        this.isPanel = true;
        this.b();
    }

    public void onPanelResize(ConfigPanelHost host) {
        this.b();
    }

    public void onPanelHidden() {
    }

    public void onTick(ConfigPanelHost host) {
        this.e();
    }

    public void drawPanel(ConfigPanelHost host, int mouseX, int mouseY, float partialTicks) {
        GL.glTranslatef((float)(-PANEL_LEFT), (float)0.0f, (float)0.0f);
        for (VoxelProperty<?> property : this.properties) {
            if (!property.isVisible()) continue;
            property.draw(this, mouseX + PANEL_LEFT, mouseY);
        }
    }

    public void mousePressed(ConfigPanelHost host, int mouseX, int mouseY, int mouseButton) {
        try {
            super.a(mouseX + PANEL_LEFT, mouseY, mouseButton);
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (VoxelProperty<?> property : this.properties) {
            if (!property.isVisible()) continue;
            property.mouseClicked(mouseX + PANEL_LEFT, mouseY);
        }
    }

    public void mouseReleased(ConfigPanelHost host, int mouseX, int mouseY, int mouseButton) {
        super.a(mouseX + PANEL_LEFT, mouseY, mouseButton, 0L);
    }

    public void mouseMoved(ConfigPanelHost host, int mouseX, int mouseY) {
        super.a(mouseX + PANEL_LEFT, mouseY, -1, 0L);
    }

    public void keyPressed(ConfigPanelHost host, char keyChar, int keyCode) {
        if (keyCode == 1 && host != null) {
            host.close();
            return;
        }
        if (keyCode == 15) {
            VoxelProperty<?> focused = null;
            VoxelProperty<?> next = null;
            VoxelProperty<?> before = null;
            for (VoxelProperty<?> property : this.properties) {
                if (property.isFocusable() && next == null) {
                    next = property;
                }
                if (!property.isFocused() || focused != null) continue;
                focused = property;
                before = next;
                next = null;
            }
            if (next == null) {
                next = before;
            }
            if (focused != null && next != null && next != focused) {
                focused.setFocused(false);
                next.setFocused(true);
                return;
            }
        }
        for (VoxelProperty<?> property : this.properties) {
            if (!property.isVisible()) continue;
            property.keyTyped(keyChar, keyCode);
        }
    }
}

