/*
 * Decompiled with CFR 0.152.
 */
package com.voxelmodpack.common.util;

import com.mumfrey.liteloader.util.render.Icon;
import com.voxelmodpack.common.gui.interfaces.IListObject;

public class ItemStackInfo
implements IListObject {
    private int index;
    private Icon icon;
    private String name;
    private String nameWithID;
    private alq item;
    private String itemId;
    private int damageValue;
    private amj stack;

    public ItemStackInfo(int index, Icon icon, int damage, amj stack) {
        this.index = index;
        this.name = stack.q();
        this.icon = icon;
        this.damageValue = damage;
        this.stack = stack;
    }

    public void updateName() {
        this.name = this.stack.q();
        this.item = this.stack.b();
        this.itemId = ItemStackInfo.getItemIdentifier(this.item);
        this.nameWithID = this.name + " " + a.n + this.itemId;
        if (this.damageValue > 0) {
            this.nameWithID = this.nameWithID + ":" + this.damageValue;
        }
    }

    @Override
    public boolean hasIcon() {
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public String getName(boolean withID) {
        return withID ? this.nameWithID : this.name;
    }

    public int getDamage() {
        return this.damageValue;
    }

    public alq getItem() {
        return this.item;
    }

    public String getItemId() {
        return this.itemId;
    }

    public amj getItemStack() {
        return this.stack;
    }

    public boolean compareTo(ItemStackInfo other) {
        return other.name.equalsIgnoreCase(this.name) && other.icon == this.icon;
    }

    @Override
    public String getText() {
        return this.name;
    }

    public String getSortText() {
        String sortText = this.name;
        if (this.stack.b() instanceof all) {
            sortText = sortText + " food";
        }
        if (this.name.toLowerCase().contains("wood")) {
            sortText = sortText + " wood";
        }
        return sortText;
    }

    @Override
    public int getID() {
        return this.index;
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public IListObject.CustomDrawBehaviour getCustomDrawBehaviour() {
        return IListObject.CustomDrawBehaviour.NoCustomDraw;
    }

    @Override
    public void drawCustom(boolean iconEnabled, bsu minecraft, int mouseX, int mouseY, int xPosition, int yPosition, int width, int height, int updateCounter) {
    }

    @Override
    public boolean mousePressed(boolean iconEnabled, bsu minecraft, int mouseX, int mouseY, int xPosition, int yPosition, int width, int height) {
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
    }

    @Override
    public String getCustomAction(boolean bClear) {
        return "";
    }

    @Override
    public boolean getDraggable() {
        return false;
    }

    @Override
    public void setIconTexture(String newTexture) {
    }

    @Override
    public void setIconID(int newIconId) {
    }

    @Override
    public void setText(String newText) {
        this.name = newText;
    }

    @Override
    public void setID(int newId) {
    }

    @Override
    public void setData(Object newData) {
    }

    @Override
    public boolean getCanEditInPlace() {
        return false;
    }

    @Override
    public boolean getEditingInPlace() {
        return false;
    }

    @Override
    public void beginEditInPlace() {
    }

    @Override
    public void endEditInPlace() {
    }

    @Override
    public boolean editInPlaceKeyTyped(char keyChar, int keyCode) {
        return false;
    }

    @Override
    public void editInPlaceDraw(boolean iconEnabled, bsu minecraft, int mouseX, int mouseY, int xPosition, int yPosition, int width, int height, int updateCounter) {
    }

    @Override
    public boolean editInPlaceMousePressed(boolean iconEnabled, bsu minecraft, int mouseX, int mouseY, int xPosition, int yPosition, int width, int height) {
        return false;
    }

    @Override
    public String serialise() {
        return null;
    }

    @Override
    public void bindIconTexture() {
    }

    @Override
    public int getIconSize() {
        return 16;
    }

    @Override
    public int getIconTexmapSize() {
        return 256;
    }

    @Override
    public String getDisplayName() {
        return this.name.toLowerCase();
    }

    @Override
    public void setDisplayName(String newDisplayName) {
    }

    public static String getItemIdentifier(alq item) {
        String itemName = (String)alq.e.c((Object)item);
        return itemName == null ? "air" : ItemStackInfo.stripNamespace(itemName);
    }

    public static String getBlockIdentifier(atr block) {
        String blockName = (String)atr.c.c((Object)block);
        return blockName == null ? "air" : ItemStackInfo.stripNamespace(blockName);
    }

    private static String stripNamespace(String itemName) {
        return itemName.startsWith("minecraft:") ? itemName.substring(10) : itemName;
    }
}

