/*
 * Decompiled with CFR 0.152.
 */
package com.voxelmodpack.common.xml;

import com.voxelmodpack.common.xml.XmlNamespaceContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static XPath xpath;
    private static XmlNamespaceContext staticNamespaceContext;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static DocumentBuilder documentBuilder;
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;

    protected static boolean createDocumentBuilder(DocumentBuilderFactory factory) {
        if (documentBuilder == null) {
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                return false;
            }
        }
        return true;
    }

    protected static boolean createTransformer(TransformerFactory factory) {
        if (transformer == null) {
            try {
                transformer = transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                return false;
            }
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        return true;
    }

    public static Document newDocument() {
        return XmlHelper.createDocumentBuilder(documentBuilderFactory) ? documentBuilder.newDocument() : null;
    }

    public static Document getDocument(String uri) throws SAXException, IOException {
        return XmlHelper.createDocumentBuilder(documentBuilderFactory) ? documentBuilder.parse(uri) : null;
    }

    public static Document getDocument(InputStream is) throws SAXException, IOException {
        return XmlHelper.createDocumentBuilder(documentBuilderFactory) ? documentBuilder.parse(is) : null;
    }

    public static Document getDocument(File file) throws SAXException, IOException {
        return XmlHelper.createDocumentBuilder(documentBuilderFactory) ? documentBuilder.parse(file) : null;
    }

    public static boolean saveDocument(File file, Document document) {
        if (XmlHelper.createTransformer(transformerFactory)) {
            try {
                transformer.transform(new DOMSource(document), new StreamResult(file));
                return true;
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getDocumentContent(Document document) {
        if (XmlHelper.createTransformer(transformerFactory)) {
            try {
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(document), new StreamResult(writer));
                writer.flush();
                return writer.getBuffer().toString();
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addNamespacePrefix(String prefix, String namespaceURI) {
        staticNamespaceContext.addPrefix(prefix, namespaceURI);
    }

    public static void clearNamespacePrefixList() {
        staticNamespaceContext.clear();
    }

    public static void setNamespaceContext(XmlNamespaceContext namespaceContext) {
        if (namespaceContext != null) {
            staticNamespaceContext = namespaceContext;
        }
    }

    public static NodeList query(Node xml, String xPath) {
        return XmlHelper.query(xml, xPath, staticNamespaceContext);
    }

    public static NodeList query(Node xml, String xPath, NamespaceContext namespaceContext) {
        try {
            xpath.setNamespaceContext(namespaceContext);
            return (NodeList)xpath.evaluate(xPath, xml, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<Node> queryAsArray(Node xml, String xPath) {
        return XmlHelper.queryAsArray(xml, xPath, staticNamespaceContext);
    }

    public static ArrayList<Node> queryAsArray(Node xml, String xPath, NamespaceContext namespaceContext) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList result = XmlHelper.query(xml, xPath, namespaceContext);
        if (result != null) {
            for (int nodeIndex = 0; nodeIndex < result.getLength(); ++nodeIndex) {
                nodes.add(result.item(nodeIndex));
            }
        }
        return nodes;
    }

    public static Node getNode(Node node, String nodeName) {
        return XmlHelper.getNode(node, nodeName, staticNamespaceContext);
    }

    public static Node getNode(Node node, String nodeName, NamespaceContext namespaceContext) {
        try {
            xpath.setNamespaceContext(namespaceContext);
            return (Node)xpath.evaluate(nodeName, node, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String getNodeValue(Node node, String nodeName, String defaultValue) {
        return XmlHelper.getNodeValue(node, nodeName, defaultValue, (NamespaceContext)staticNamespaceContext);
    }

    public static String getNodeValue(Node node, String nodeName, String defaultValue, NamespaceContext namespaceContext) {
        try {
            xpath.setNamespaceContext(namespaceContext);
            NodeList nodes = (NodeList)xpath.evaluate(nodeName, node, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                return nodes.item(0).getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static int getNodeValue(Node node, String nodeName, int defaultValue) {
        return XmlHelper.getNodeValue(node, nodeName, defaultValue, (NamespaceContext)staticNamespaceContext);
    }

    public static int getNodeValue(Node node, String nodeName, int defaultValue, NamespaceContext namespaceContext) {
        String nodeValue = XmlHelper.getNodeValue(node, nodeName, "" + defaultValue, namespaceContext);
        try {
            return Integer.parseInt(nodeValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static String getAttributeValue(Node node, String attributeName, String defaultValue) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getTextContent();
        }
        return defaultValue;
    }

    public static int getAttributeValue(Node node, String attributeName, int defaultValue) {
        String attributeValue = XmlHelper.getAttributeValue(node, attributeName, "" + defaultValue);
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static {
        staticNamespaceContext = new XmlNamespaceContext();
        xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(staticNamespaceContext);
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        XmlHelper.createDocumentBuilder(documentBuilderFactory);
        transformerFactory = TransformerFactory.newInstance();
        XmlHelper.createTransformer(transformerFactory);
    }
}

