package com.minelittlepony.minelp.asm;

import java.util.Arrays;
import java.util.List;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class FixUploadClassVisitor extends ClassVisitor {

    private List<String> methods = Arrays.asList("clearUploadedSkin", "disableCape", "enableCape", "uploadSkin");

    public FixUploadClassVisitor(ClassVisitor cv) {
        super(Opcodes.ASM4, cv);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (methods.contains(name)) {
            mv = new FixUploadMethodVisitor(mv);
        }
        return mv;
    }

    private class FixUploadMethodVisitor extends MethodVisitor {

        public FixUploadMethodVisitor(MethodVisitor mv) {
            super(Opcodes.ASM4, mv);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst.equals("http://www.minelittlepony.com/hd/upload.php"))
                cst = "http://skinmanager.voxelmodpack.com/";
            super.visitLdcInsn(cst);
        }
    }
}
