package com.minelittlepony.minelp.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

import net.minecraft.launchwrapper.IClassTransformer;

public class MineLPFixTransformer implements IClassTransformer {

    @Override
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null)
            return null;

        if (name.equals("com.thevoxelbox.hdskins.gui.GuiSkins")) {
            ClassReader reader = new ClassReader(basicClass);
            ClassWriter writer = new ClassWriter(reader, 0);
            ClassVisitor visitor = new FixUploadClassVisitor(writer);

            reader.accept(visitor, 0);
            basicClass = writer.toByteArray();
        }
        return basicClass;
    }
}
