/*
 * Decompiled with CFR 0.152.
 */
package com.example.censorsigns;

import com.example.censorsigns.CensorSignsCommand;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class CensorSigns
extends JavaPlugin
implements Listener {
    private List<String> bannedWords;
    private String replacementChar;
    private boolean preserveLength;
    private boolean notifyStaff;
    private String notificationMessage;
    private boolean enableLogging;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("censorsigns").setExecutor(new CensorSignsCommand(this));
        this.getLogger().info("CensorSigns has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("CensorSigns has been disabled!");
    }

    public void loadConfiguration() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.bannedWords = config.getStringList("banned-words");
        this.replacementChar = config.getString("replacement-character", "*");
        this.preserveLength = config.getBoolean("preserve-word-length", true);
        this.notifyStaff = config.getBoolean("notify-staff", true);
        this.notificationMessage = config.getString("notification-message", "\u00a7c[CensorSigns] \u00a7f%player% tried to place a sign with banned word(s).");
        this.enableLogging = config.getBoolean("enable-logging", true);
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        boolean containsBannedWord = false;
        String playerName = event.getPlayer().getName();
        for (int i = 0; i < 4; ++i) {
            String censoredLine;
            String originalLine = event.getLine(i);
            if (originalLine == null || originalLine.isEmpty() || originalLine.equals(censoredLine = this.censorLine(originalLine))) continue;
            containsBannedWord = true;
            event.setLine(i, censoredLine);
        }
        if (containsBannedWord) {
            if (this.enableLogging) {
                this.getLogger().info(playerName + " attempted to place a sign with banned words.");
            }
            if (this.notifyStaff) {
                String notification = this.notificationMessage.replace("%player%", playerName);
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (player.hasPermission("censorsigns.notify")) {
                        player.sendMessage(notification);
                    }
                });
            }
        }
    }

    private String censorLine(String line) {
        String result = line;
        for (String word : this.bannedWords) {
            Pattern pattern = Pattern.compile("\\b" + Pattern.quote(word) + "\\b", 2);
            Matcher matcher = pattern.matcher(result);
            if (this.preserveLength) {
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String replacement = this.replacementChar.repeat(matcher.group().length());
                    matcher.appendReplacement(sb, replacement);
                }
                matcher.appendTail(sb);
                result = sb.toString();
                continue;
            }
            result = matcher.replaceAll(this.replacementChar);
        }
        return result;
    }
}

