/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.droplet.api.auth;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/simplecloud/droplet/api/auth/JwtHandler;", "", "secret", "", "issuer", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "generateJwt", "Lcom/nimbusds/jwt/SignedJWT;", "subject", "expiresIn", "", "scope", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lcom/nimbusds/jwt/SignedJWT;", "generateJwtSigned", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "verifyJwt", "", "token", "decodeJwt", "droplet-api"})
public final class JwtHandler {
    @NotNull
    private final String secret;
    @NotNull
    private final String issuer;

    public JwtHandler(@NotNull String secret, @NotNull String issuer) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        this.secret = secret;
        this.issuer = issuer;
    }

    @NotNull
    public final SignedJWT generateJwt(@NotNull String subject, @Nullable Integer expiresIn, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        JWTClaimsSet.Builder claimsSet = new JWTClaimsSet.Builder().subject(subject).claim("scope", scope).issuer(this.issuer);
        if (expiresIn != null) {
            claimsSet.expirationTime(new Date(System.currentTimeMillis() + (long)expiresIn.intValue() * 1000L));
        }
        return new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet.build());
    }

    public static /* synthetic */ SignedJWT generateJwt$default(JwtHandler jwtHandler, String string, Integer n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return jwtHandler.generateJwt(string, n, string2);
    }

    @NotNull
    public final String generateJwtSigned(@NotNull String subject, @Nullable Integer expiresIn, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string = this.secret;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        MACSigner signer = new MACSigner(byArray);
        SignedJWT signedJWT = this.generateJwt(subject, expiresIn, scope);
        signedJWT.sign(signer);
        String string2 = signedJWT.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serialize(...)");
        return string2;
    }

    public static /* synthetic */ String generateJwtSigned$default(JwtHandler jwtHandler, String string, Integer n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return jwtHandler.generateJwtSigned(string, n, string2);
    }

    public final boolean verifyJwt(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        SignedJWT signedJWT = SignedJWT.parse(token);
        String string = this.secret;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        MACVerifier verifier2 = new MACVerifier(byArray);
        return signedJWT.verify(verifier2);
    }

    @NotNull
    public final SignedJWT decodeJwt(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        SignedJWT signedJWT = SignedJWT.parse(token);
        Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"parse(...)");
        return signedJWT;
    }
}

