/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.droplet.player.api.impl;

import app.simplecloud.droplet.player.api.CloudPlayer;
import app.simplecloud.droplet.player.api.impl.OfflineCloudPlayerImpl;
import build.buf.gen.simplecloud.droplet.player.v1.AdventureBook;
import build.buf.gen.simplecloud.droplet.player.v1.AdventureBossBar;
import build.buf.gen.simplecloud.droplet.player.v1.AdventureComponent;
import build.buf.gen.simplecloud.droplet.player.v1.AdventureSound;
import build.buf.gen.simplecloud.droplet.player.v1.CloudPlayerConfiguration;
import build.buf.gen.simplecloud.droplet.player.v1.CloudPlayerKickRequest;
import build.buf.gen.simplecloud.droplet.player.v1.OfflineCloudPlayerConfiguration;
import build.buf.gen.simplecloud.droplet.player.v1.PlayerAdventureServiceGrpc;
import build.buf.gen.simplecloud.droplet.player.v1.PlayerServiceGrpc;
import build.buf.gen.simplecloud.droplet.player.v1.SendActionbarRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendBossBarHideRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendBossBarRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendClearTitleRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendMessageRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendOpenBookRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendPlaySoundRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendPlaySoundToCoordinatesRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendPlayerListHeaderAndFooterRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendResetTitleRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendStopSoundRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendTitlePartSubTitleRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendTitlePartTimesRequest;
import build.buf.gen.simplecloud.droplet.player.v1.SendTitlePartTitleRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J-\u0010\"\u001a\u00020\u0011\"\b\b\u0000\u0010#*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\u0006\u0010'\u001a\u0002H#H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0011H\u0016J\b\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u000201H\u0016J(\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J\u0018\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u0002012\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lapp/simplecloud/droplet/player/api/impl/CloudPlayerImpl;", "Lapp/simplecloud/droplet/player/api/impl/OfflineCloudPlayerImpl;", "Lapp/simplecloud/droplet/player/api/CloudPlayer;", "playerServiceStub", "Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerServiceGrpc$PlayerServiceFutureStub;", "playerAdventureServiceStub", "Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerAdventureServiceGrpc$PlayerAdventureServiceFutureStub;", "configuration", "Lbuild/buf/gen/simplecloud/droplet/player/v1/CloudPlayerConfiguration;", "componentSerializer", "Lnet/kyori/adventure/text/serializer/gson/GsonComponentSerializer;", "<init>", "(Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerServiceGrpc$PlayerServiceFutureStub;Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerAdventureServiceGrpc$PlayerAdventureServiceFutureStub;Lbuild/buf/gen/simplecloud/droplet/player/v1/CloudPlayerConfiguration;Lnet/kyori/adventure/text/serializer/gson/GsonComponentSerializer;)V", "getConnectedServerName", "", "getConnectedProxyName", "kick", "", "reason", "Lnet/kyori/adventure/text/Component;", "isOnline", "", "getOnlineTime", "", "sendMessage", "source", "Lnet/kyori/adventure/identity/Identity;", "message", "type", "Lnet/kyori/adventure/audience/MessageType;", "sendActionBar", "sendPlayerListHeaderAndFooter", "header", "footer", "sendTitlePart", "T", "", "part", "Lnet/kyori/adventure/title/TitlePart;", "value", "(Lnet/kyori/adventure/title/TitlePart;Ljava/lang/Object;)V", "clearTitle", "resetTitle", "showBossBar", "bar", "Lnet/kyori/adventure/bossbar/BossBar;", "hideBossBar", "playSound", "sound", "Lnet/kyori/adventure/sound/Sound;", "x", "", "y", "z", "emitter", "Lnet/kyori/adventure/sound/Sound$Emitter;", "stopSound", "stop", "Lnet/kyori/adventure/sound/SoundStop;", "openBook", "book", "Lnet/kyori/adventure/inventory/Book;", "player-api"})
@SourceDebugExtension(value={"SMAP\nCloudPlayerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudPlayerImpl.kt\napp/simplecloud/droplet/player/api/impl/CloudPlayerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1557#2:244\n1628#2,3:245\n1557#2:248\n1628#2,3:249\n1#3:252\n*S KotlinDebug\n*F\n+ 1 CloudPlayerImpl.kt\napp/simplecloud/droplet/player/api/impl/CloudPlayerImpl\n*L\n146#1:244\n146#1:245,3\n165#1:248\n165#1:249,3\n*E\n"})
public final class CloudPlayerImpl
extends OfflineCloudPlayerImpl
implements CloudPlayer {
    @NotNull
    private final PlayerServiceGrpc.PlayerServiceFutureStub playerServiceStub;
    @NotNull
    private final PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceStub;
    @NotNull
    private final CloudPlayerConfiguration configuration;
    @NotNull
    private final GsonComponentSerializer componentSerializer;

    public CloudPlayerImpl(@NotNull PlayerServiceGrpc.PlayerServiceFutureStub playerServiceStub, @NotNull PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceStub, @NotNull CloudPlayerConfiguration configuration, @NotNull GsonComponentSerializer componentSerializer) {
        Intrinsics.checkNotNullParameter((Object)playerServiceStub, (String)"playerServiceStub");
        Intrinsics.checkNotNullParameter((Object)playerAdventureServiceStub, (String)"playerAdventureServiceStub");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)componentSerializer, (String)"componentSerializer");
        OfflineCloudPlayerConfiguration offlineCloudPlayerConfiguration = OfflineCloudPlayerConfiguration.parseFrom(configuration.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)offlineCloudPlayerConfiguration, (String)"parseFrom(...)");
        super(offlineCloudPlayerConfiguration);
        this.playerServiceStub = playerServiceStub;
        this.playerAdventureServiceStub = playerAdventureServiceStub;
        this.configuration = configuration;
        this.componentSerializer = componentSerializer;
    }

    public /* synthetic */ CloudPlayerImpl(PlayerServiceGrpc.PlayerServiceFutureStub playerServiceFutureStub, PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub, CloudPlayerConfiguration cloudPlayerConfiguration, GsonComponentSerializer gsonComponentSerializer, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            gsonComponentSerializer = GsonComponentSerializer.gson();
        }
        this(playerServiceFutureStub, playerAdventureServiceFutureStub, cloudPlayerConfiguration, gsonComponentSerializer);
    }

    @Override
    @Nullable
    public String getConnectedServerName() {
        return this.configuration.getConnectedServerName();
    }

    @Override
    @NotNull
    public String getConnectedProxyName() {
        String string = this.configuration.getConnectedProxyName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConnectedProxyName(...)");
        return string;
    }

    @Override
    public void kick(@NotNull Component reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.playerServiceStub.kickCloudPlayer(CloudPlayerKickRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setReason(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(reason)).build()).build()).get();
    }

    @Override
    public boolean isOnline() {
        return this.configuration.getPlayerConnection().getOnline();
    }

    @Override
    public long getOnlineTime() {
        return this.configuration.getOnlineTime() + this.getSessionTime();
    }

    public void sendMessage(@NotNull Identity source, @NotNull Component message, @NotNull MessageType type) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.playerAdventureServiceStub.sendMessage(SendMessageRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setMessage(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(message.asComponent())).build()).build()).get();
    }

    public void sendActionBar(@NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.playerAdventureServiceStub.sendActionbar(SendActionbarRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setMessage(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(message)).build()).build()).get();
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)footer, (String)"footer");
        this.playerAdventureServiceStub.sendPlayerListHeaderAndFooter(SendPlayerListHeaderAndFooterRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setFooter(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(footer)).build()).setHeader(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(header)).build()).build()).get();
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        Intrinsics.checkNotNullParameter(part, (String)"part");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (value instanceof Title.Times) {
            this.playerAdventureServiceStub.sendTitlePartTimes(SendTitlePartTimesRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setFadeIn(((Title.Times)value).fadeIn().toMillis()).setStay(((Title.Times)value).stay().toMillis()).setFadeOut(((Title.Times)value).fadeOut().toMillis()).build()).get();
        }
        if (Intrinsics.areEqual((Object)part.toString(), (Object)"TitlePart.TITLE")) {
            this.playerAdventureServiceStub.sendTitlePartTitle(SendTitlePartTitleRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setComponent(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize((Component)value)).build()).build()).get();
        }
        if (Intrinsics.areEqual((Object)part.toString(), (Object)"TitlePart.SUBTITLE")) {
            this.playerAdventureServiceStub.sendTitlePartSubTitle(SendTitlePartSubTitleRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setComponent(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize((Component)value)).build()).build()).get();
        }
    }

    public void clearTitle() {
        this.playerAdventureServiceStub.sendClearTitle(SendClearTitleRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).build()).get();
    }

    public void resetTitle() {
        this.playerAdventureServiceStub.sendResetTitle(SendResetTitleRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).build()).get();
    }

    /*
     * WARNING - void declaration
     */
    public void showBossBar(@NotNull BossBar bar) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        SendBossBarRequest.Builder builder2 = SendBossBarRequest.newBuilder().setUniqueId(this.getUniqueId().toString());
        AdventureBossBar.Builder builder3 = AdventureBossBar.newBuilder().setColor(bar.color().name()).setOverlay(bar.overlay().name()).setProgress(bar.progress()).setTitle(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(bar.name())).build());
        Set set = bar.flags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"flags(...)");
        Iterable iterable = set;
        AdventureBossBar.Builder builder4 = builder3;
        SendBossBarRequest.Builder builder5 = builder2;
        PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub = this.playerAdventureServiceStub;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BossBar.Flag flag = (BossBar.Flag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        collection = (List)destination$iv$iv;
        playerAdventureServiceFutureStub.sendBossBar(builder5.setBossBar(builder4.addAllFlags((Iterable<String>)collection).build()).build()).get();
    }

    /*
     * WARNING - void declaration
     */
    public void hideBossBar(@NotNull BossBar bar) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        SendBossBarHideRequest.Builder builder2 = SendBossBarHideRequest.newBuilder().setUniqueId(this.getUniqueId().toString());
        AdventureBossBar.Builder builder3 = AdventureBossBar.newBuilder().setColor(bar.color().name()).setOverlay(bar.overlay().name()).setProgress(bar.progress()).setTitle(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(bar.name())).build());
        Set set = bar.flags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"flags(...)");
        Iterable iterable = set;
        AdventureBossBar.Builder builder4 = builder3;
        SendBossBarHideRequest.Builder builder5 = builder2;
        PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub = this.playerAdventureServiceStub;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BossBar.Flag flag = (BossBar.Flag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        collection = (List)destination$iv$iv;
        playerAdventureServiceFutureStub.sendBossBarRemove(builder5.setBossBar(builder4.addAllFlags((Iterable<String>)collection).build()).build()).get();
    }

    public void playSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.playerAdventureServiceStub.sendPlaySound(SendPlaySoundRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setSound(AdventureSound.newBuilder().setSound(sound.name().asString()).setVolume(sound.volume()).setPitch(sound.pitch()).setSource(sound.source().name()).build()).build()).get();
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.playerAdventureServiceStub.sendPlaySoundToCoordinates(SendPlaySoundToCoordinatesRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setSound(AdventureSound.newBuilder().setSound(sound.name().asString()).setVolume(sound.volume()).setPitch(sound.pitch()).setSource(sound.source().name()).build()).setX(x).setY(y).setZ(z).build()).get();
    }

    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        this.playSound(sound);
    }

    public void stopSound(@NotNull SoundStop stop) {
        AdventureSound adventureSound;
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        Key key2 = stop.sound();
        if (key2 != null) {
            Key it = key2;
            boolean bl = false;
            adventureSound = AdventureSound.newBuilder().setSound(it.asString()).build();
        } else {
            adventureSound = null;
        }
        AdventureSound sound = adventureSound;
        Sound.Source source = stop.source();
        String source2 = source != null ? source.toString() : null;
        this.playerAdventureServiceStub.sendStopSound(SendStopSoundRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setSound(sound).setSource(source2).build()).get();
    }

    public void openBook(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        AdventureBook.Builder bookBuilder = AdventureBook.newBuilder();
        bookBuilder.setTitle(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(book.title())).build());
        bookBuilder.setAuthor(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(book.author())).build());
        for (Component page : book.pages()) {
            bookBuilder.addPages(AdventureComponent.newBuilder().setJson((String)this.componentSerializer.serialize(page)).build());
        }
        this.playerAdventureServiceStub.sendOpenBook(SendOpenBookRequest.newBuilder().setUniqueId(this.getUniqueId().toString()).setBook(bookBuilder.build()).build()).get();
    }

    @Override
    public long getSessionTime() {
        return CloudPlayer.DefaultImpls.getSessionTime(this);
    }
}

