/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGBColorSpace;
import kotlin.Metadata;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/ajalt/colormath/model/ACESccTransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "<init>", "()V", "twoN15", "", "twoN16", "eotfC1", "eotfC2", "eotf", "", "x", "oetf", "colormath"})
final class ACESccTransferFunctions
implements RGBColorSpace.TransferFunctions {
    @NotNull
    public static final ACESccTransferFunctions INSTANCE = new ACESccTransferFunctions();
    private static final double twoN15 = 3.0517578125E-5;
    private static final double twoN16 = 1.52587890625E-5;
    private static final double eotfC1 = -0.3013698630136986;
    private static final double eotfC2 = (MathKt.log2((double)65504.0) + 9.72) / 17.52;

    private ACESccTransferFunctions() {
    }

    @Override
    public float eotf(float x) {
        return (float)((double)x <= -0.3013698630136986 ? (InternalMathKt.spow(2.0, (double)x * 17.52 - 9.72) - 1.52587890625E-5) * 2.0 : ((double)x < eotfC2 ? Math.pow(2.0, (double)x * 17.52 - 9.72) : 65504.0));
    }

    @Override
    public float oetf(float x) {
        return (float)((double)x < 3.0517578125E-5 ? (MathKt.log2((double)(1.52587890625E-5 + (double)RangesKt.coerceAtLeast((float)x, (float)0.0f) / 2.0)) + 9.72) / 17.52 : ((double)MathKt.log2((float)x) + 9.72) / 17.52);
    }
}

