/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/github/ajalt/colormath/model/Ansi256;", "Lcom/github/ajalt/colormath/Color;", "code", "", "<init>", "(I)V", "getCode", "()I", "alpha", "", "getAlpha", "()F", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toAnsi16", "Lcom/github/ajalt/colormath/model/Ansi16;", "toAnsi256", "toArray", "", "clamp", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "colormath"})
public final class Ansi256
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int code;
    @NotNull
    private static final List<ColorComponentInfo> components;

    public Ansi256(int code) {
        this.code = code;
    }

    public final int getCode() {
        return this.code;
    }

    @Override
    public float getAlpha() {
        return 1.0f;
    }

    @NotNull
    public ColorSpace<Ansi256> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        if (this.code < 16) {
            return this.toAnsi16().toSRGB();
        }
        if (this.code >= 232) {
            int c = (this.code - 232) * 10 + 8;
            return RGBColorSpace.DefaultImpls.from255$default(RGB.Companion, c, c, c, 0, 8, null);
        }
        int c = this.code - 16;
        int rem = c % 36;
        double r = Math.floor((double)c / 36.0) / 5.0;
        double g2 = Math.floor((double)rem / 6.0) / 5.0;
        double b = (double)(rem % 6) / 5.0;
        return RGBColorSpace.DefaultImpls.invoke$default((RGBColorSpace)RGB.Companion, r, g2, b, null, 8, null);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return this.code < 8 ? new Ansi16(this.code + 30) : (this.code < 16 ? new Ansi16(this.code - 8 + 90) : this.toSRGB().toAnsi16());
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.code, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public Color clamp() {
        return this.code < 0 ? (Color)new Ansi256(0) : (this.code > 255 ? (Color)new Ansi256(255) : (Color)this);
    }

    public final int component1() {
        return this.code;
    }

    @NotNull
    public final Ansi256 copy(int code) {
        return new Ansi256(code);
    }

    public static /* synthetic */ Ansi256 copy$default(Ansi256 ansi256, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ansi256.code;
        }
        return ansi256.copy(n);
    }

    @NotNull
    public String toString() {
        return "Ansi256(code=" + this.code + ')';
    }

    public int hashCode() {
        return Integer.hashCode(this.code);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ansi256)) {
            return false;
        }
        Ansi256 ansi256 = (Ansi256)other;
        return this.code == ansi256.code;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    static {
        ColorComponentInfo[] colorComponentInfoArray = new ColorComponentInfo[]{new ColorComponentInfo("code", false, 0.0f, 255.0f)};
        components = ColorSpaceUtilsKt.componentInfoList(colorComponentInfoArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/colormath/model/Ansi256$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/Ansi256;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nAnsi256.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ansi256.kt\ncom/github/ajalt/colormath/model/Ansi256$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,77:1\n15#2,5:78\n*S KotlinDebug\n*F\n+ 1 Ansi256.kt\ncom/github/ajalt/colormath/model/Ansi256$Companion\n*L\n31#1:78,5\n*E\n"})
    public static final class Companion
    implements ColorSpace<Ansi256> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "Ansi256";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public Ansi256 convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return color.toAnsi256();
        }

        @Override
        @NotNull
        public Ansi256 create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            ColorSpace $this$withValidComps$iv = this;
            boolean $i$f$withValidComps = false;
            int size$iv = $this$withValidComps$iv.getComponents().size();
            int n = size$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it = components;
            boolean bl = false;
            return (Ansi256)((Color)new Ansi256((int)it[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

