/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABKt;
import com.github.ajalt.colormath.model.LCHabColorSpace;
import com.github.ajalt.colormath.model.LCHabColorSpaces;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/github/ajalt/colormath/model/LCHab;", "Lcom/github/ajalt/colormath/HueColor;", "l", "", "c", "h", "alpha", "space", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "<init>", "(FFFFLcom/github/ajalt/colormath/model/LCHabColorSpace;)V", "getL", "()F", "getC", "getH", "getAlpha", "getSpace", "()Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toLAB", "Lcom/github/ajalt/colormath/model/LAB;", "toLCHab", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nLCHab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LCHab.kt\ncom/github/ajalt/colormath/model/LCHab\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,83:1\n37#2,4:84\n135#3,12:88\n*S KotlinDebug\n*F\n+ 1 LCHab.kt\ncom/github/ajalt/colormath/model/LCHab\n*L\n77#1:84,4\n81#1:88,12\n*E\n"})
public final class LCHab
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float c;
    private final float h;
    private final float alpha;
    @NotNull
    private final LCHabColorSpace space;

    public LCHab(float l, float c, float h2, float alpha, @NotNull LCHabColorSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        this.l = l;
        this.c = c;
        this.h = h2;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getC() {
        return this.c;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LCHabColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toLAB().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toLAB().toXYZ();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LAB toLAB() {
        void b;
        void b$iv;
        void c$iv;
        float f = this.c;
        float h$iv = this.getH();
        boolean $i$f$fromPolarModel = false;
        float hDegrees$iv = Float.isNaN(h$iv) ? 0.0f : InternalMathKt.degToRad(h$iv);
        void a$iv = c$iv * (float)Math.cos(hDegrees$iv);
        void var7_7 = b$iv = c$iv * (float)Math.sin(hDegrees$iv);
        void a = a$iv;
        boolean bl = false;
        return LABKt.LABColorSpace(this.getSpace().getWhitePoint()).invoke(this.l, (float)a, (float)b, this.getAlpha());
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.c, this.getH(), this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LCHab clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clampTrailingHue$iv;
        Color color2 = this;
        float f = this.l;
        float f2 = this.c;
        float f3 = this.getH();
        float alpha$iv = this.getAlpha();
        boolean $i$f$clampTrailingHue = false;
        List<ColorComponentInfo> list = $this$clampTrailingHue$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clampTrailingHue$iv;
                        return (LCHab)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn((float)alpha$iv, (float)0.0f, (float)1.0f);
        void var13_13 = v3$iv % (float)360;
        float f6 = RangesKt.coerceIn((float)v2$iv, (float)c2$iv.getMin(), (float)c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, (float)c1$iv.getMin(), (float)c1$iv.getMax());
        boolean bl5 = false;
        color = LCHab.copy$default(this, p0, (float)p1, (float)p2, (float)p3, null, 16, null);
        return (LCHab)color;
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.c;
    }

    public final float component3() {
        return this.h;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final LCHabColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final LCHab copy(float l, float c, float h2, float alpha, @NotNull LCHabColorSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        return new LCHab(l, c, h2, alpha, space);
    }

    public static /* synthetic */ LCHab copy$default(LCHab lCHab, float f, float f2, float f3, float f4, LCHabColorSpace lCHabColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lCHab.l;
        }
        if ((n & 2) != 0) {
            f2 = lCHab.c;
        }
        if ((n & 4) != 0) {
            f3 = lCHab.h;
        }
        if ((n & 8) != 0) {
            f4 = lCHab.alpha;
        }
        if ((n & 0x10) != 0) {
            lCHabColorSpace = lCHab.space;
        }
        return lCHab.copy(f, f2, f3, f4, lCHabColorSpace);
    }

    @NotNull
    public String toString() {
        return "LCHab(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.c);
        result2 = result2 * 31 + Float.hashCode(this.h);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.space.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LCHab)) {
            return false;
        }
        LCHab lCHab = (LCHab)other;
        if (Float.compare(this.l, lCHab.l) != 0) {
            return false;
        }
        if (Float.compare(this.c, lCHab.c) != 0) {
            return false;
        }
        if (Float.compare(this.h, lCHab.h) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, lCHab.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.space, (Object)lCHab.space);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return HueColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return HueColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return HueColor.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return HueColor.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return HueColor.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return HueColor.DefaultImpls.toHPLuv(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0096\u0003J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0003R\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0005R\t\u0010\u001a\u001a\u00020\u001bX\u0096\u0005R\t\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/colormath/model/LCHab$Companion;", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "convert", "Lcom/github/ajalt/colormath/model/LCHab;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "components", "", "invoke", "l", "", "c", "h", "alpha", "", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "name", "", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "colormath"})
    public static final class Companion
    implements LCHabColorSpace {
        private final /* synthetic */ LCHabColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LCHabColorSpaces.INSTANCE.getLCHab65();
        }

        @Override
        @NotNull
        public LCHab invoke(float l, float c, float h2, float alpha) {
            return this.$$delegate_0.invoke(l, c, h2, alpha);
        }

        @Override
        @NotNull
        public LCHab invoke(@NotNull Number l, @NotNull Number c, @NotNull Number h2, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)h2, (String)"h");
            Intrinsics.checkNotNullParameter((Object)alpha, (String)"alpha");
            return this.$$delegate_0.invoke(l, c, h2, alpha);
        }

        @Override
        @NotNull
        public LCHab convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return (LCHab)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LCHab create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            return (LCHab)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual((Object)LCHabColorSpaces.INSTANCE.getLCHab65(), (Object)other);
        }

        public int hashCode() {
            return LCHabColorSpaces.INSTANCE.getLCHab65().hashCode();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

