/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.transform.CubicBezierEasing;
import com.github.ajalt.colormath.transform.EasingFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/transform/EasingFunctions;", "", "<init>", "()V", "cubicBezier", "Lcom/github/ajalt/colormath/transform/EasingFunction;", "x1", "", "y1", "x2", "y2", "linear", "midpoint", "position", "ease", "easeIn", "easeOut", "easeInOut", "colormath"})
public final class EasingFunctions {
    @NotNull
    public static final EasingFunctions INSTANCE = new EasingFunctions();

    private EasingFunctions() {
    }

    @NotNull
    public final EasingFunction cubicBezier(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2) {
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x2");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y2");
        return new CubicBezierEasing(x1.doubleValue(), y1.doubleValue(), x2.doubleValue(), y2.doubleValue());
    }

    @NotNull
    public final EasingFunction linear() {
        return EasingFunctions::linear$lambda$0;
    }

    @NotNull
    public final EasingFunction midpoint(@NotNull Number position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        float p = position.floatValue();
        if (p <= 0.0f) {
            return EasingFunctions::midpoint$lambda$1;
        }
        if (p >= 1.0f) {
            return EasingFunctions::midpoint$lambda$2;
        }
        return arg_0 -> EasingFunctions.midpoint$lambda$3(p, arg_0);
    }

    @NotNull
    public final EasingFunction ease() {
        return this.cubicBezier(0.25, 0.1, 0.25, 1.0);
    }

    @NotNull
    public final EasingFunction easeIn() {
        return this.cubicBezier(0.42, 0, 1, 1);
    }

    @NotNull
    public final EasingFunction easeOut() {
        return this.cubicBezier(0, 0, 0.58, 1);
    }

    @NotNull
    public final EasingFunction easeInOut() {
        return this.cubicBezier(0.42, 0, 0.58, 1);
    }

    private static final float linear$lambda$0(float it) {
        return it;
    }

    private static final float midpoint$lambda$1(float it) {
        return 1.0f;
    }

    private static final float midpoint$lambda$2(float it) {
        return 0.0f;
    }

    private static final float midpoint$lambda$3(float $p, float t2) {
        return t2 <= $p ? InternalMathKt.scaleRange(0.0f, $p, 0.0f, 0.5f, t2) : InternalMathKt.scaleRange($p, 1.0f, 0.5f, 1.0f, t2);
    }
}

