/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.transform.TransformKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\u001a\u0019\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u0001\u00a2\u0006\u0002\u0010\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0019\u0010\n\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u0001\u00a2\u0006\u0002\u0010\u0003\u001a\u001c\u0010\u000b\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\f"}, d2={"multiplyAlpha", "T", "Lcom/github/ajalt/colormath/Color;", "(Lcom/github/ajalt/colormath/Color;)Lcom/github/ajalt/colormath/Color;", "multiplyAlphaInPlace", "", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "components", "", "divideAlpha", "divideAlphaInPlace", "colormath"})
@SourceDebugExtension(value={"SMAP\nPremultiply.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Premultiply.kt\ncom/github/ajalt/colormath/transform/PremultiplyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class PremultiplyKt {
    @NotNull
    public static final <T extends Color> T multiplyAlpha(@NotNull T $this$multiplyAlpha) {
        Intrinsics.checkNotNullParameter($this$multiplyAlpha, (String)"<this>");
        return TransformKt.map($this$multiplyAlpha, PremultiplyKt::multiplyAlpha$lambda$1);
    }

    public static final void multiplyAlphaInPlace(@NotNull ColorSpace<?> space, @NotNull float[] components) {
        Intrinsics.checkNotNullParameter(space, (String)"space");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        float a = ArraysKt.last((float[])components);
        if (Float.isNaN(a) || a == 1.0f) {
            return;
        }
        int n = ArraysKt.getLastIndex((float[])components);
        for (int i2 = 0; i2 < n; ++i2) {
            if (space.getComponents().get(i2).isPolar()) continue;
            components[i2] = components[i2] * a;
        }
    }

    @NotNull
    public static final <T extends Color> T divideAlpha(@NotNull T $this$divideAlpha) {
        Intrinsics.checkNotNullParameter($this$divideAlpha, (String)"<this>");
        return TransformKt.map($this$divideAlpha, PremultiplyKt::divideAlpha$lambda$3);
    }

    public static final void divideAlphaInPlace(@NotNull ColorSpace<?> space, @NotNull float[] components) {
        Intrinsics.checkNotNullParameter(space, (String)"space");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        float a = ArraysKt.last((float[])components);
        if (Float.isNaN(a) || a == 0.0f || a == 1.0f) {
            return;
        }
        int n = ArraysKt.getLastIndex((float[])components);
        for (int i2 = 0; i2 < n; ++i2) {
            if (space.getComponents().get(i2).isPolar()) continue;
            components[i2] = components[i2] / a;
        }
    }

    private static final float[] multiplyAlpha$lambda$1(ColorSpace $this$map, float[] components) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        float[] it = fArray = components;
        boolean bl = false;
        PremultiplyKt.multiplyAlphaInPlace($this$map, it);
        return fArray;
    }

    private static final float[] divideAlpha$lambda$3(ColorSpace $this$map, float[] components) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        float[] it = fArray = components;
        boolean bl = false;
        PremultiplyKt.divideAlphaInPlace($this$map, it);
        return fArray;
    }
}

