/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.terminal.ConversionResult;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalExtensionsKt;
import com.github.ajalt.mordant.widgets.Text;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Be\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020\u0004H$J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0014J\u0015\u0010)\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J\b\u0010*\u001a\u00020\u0004H\u0014J\b\u0010+\u001a\u00020(H\u0014J\b\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0004H\u0014J\u000f\u00100\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\n\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000e\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0014\u0010\u000f\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u00061"}, d2={"Lcom/github/ajalt/mordant/terminal/Prompt;", "T", "", "prompt", "", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "default", "showDefault", "", "showChoices", "hideInput", "choices", "", "promptSuffix", "invalidChoiceMessage", "<init>", "(Ljava/lang/String;Lcom/github/ajalt/mordant/terminal/Terminal;Ljava/lang/Object;ZZZLjava/util/Collection;Ljava/lang/String;Ljava/lang/String;)V", "getPrompt", "()Ljava/lang/String;", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "getDefault", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getShowDefault", "()Z", "getShowChoices", "getHideInput", "getChoices", "()Ljava/util/Collection;", "getPromptSuffix", "getInvalidChoiceMessage", "convert", "Lcom/github/ajalt/mordant/terminal/ConversionResult;", "input", "renderValue", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "makePrompt", "Lcom/github/ajalt/mordant/rendering/Widget;", "makePromptDefault", "makePromptChoices", "makeInvalidChoiceMessage", "beforePrompt", "", "handleInvalidInput", "message", "ask", "mordant"})
public abstract class Prompt<T> {
    @NotNull
    private final String prompt;
    @NotNull
    private final Terminal terminal;
    @Nullable
    private final T default;
    private final boolean showDefault;
    private final boolean showChoices;
    private final boolean hideInput;
    @NotNull
    private final Collection<T> choices;
    @NotNull
    private final String promptSuffix;
    @NotNull
    private final String invalidChoiceMessage;

    public Prompt(@NotNull String prompt2, @NotNull Terminal terminal, @Nullable T t2, boolean showDefault, boolean showChoices, boolean hideInput, @NotNull Collection<? extends T> choices, @NotNull String promptSuffix, @NotNull String invalidChoiceMessage) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        Intrinsics.checkNotNullParameter((Object)promptSuffix, (String)"promptSuffix");
        Intrinsics.checkNotNullParameter((Object)invalidChoiceMessage, (String)"invalidChoiceMessage");
        this.prompt = prompt2;
        this.terminal = terminal;
        this.default = t2;
        this.showDefault = showDefault;
        this.showChoices = showChoices;
        this.hideInput = hideInput;
        this.choices = choices;
        this.promptSuffix = promptSuffix;
        this.invalidChoiceMessage = invalidChoiceMessage;
    }

    public /* synthetic */ Prompt(String string, Terminal terminal, Object object, boolean bl, boolean bl2, boolean bl3, Collection collection, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string2 = ": ";
        }
        if ((n & 0x100) != 0) {
            string3 = "Invalid value, choose from ";
        }
        this(string, terminal, object, bl, bl2, bl3, collection, string2, string3);
    }

    @NotNull
    protected final String getPrompt() {
        return this.prompt;
    }

    @NotNull
    public final Terminal getTerminal() {
        return this.terminal;
    }

    @Nullable
    protected final T getDefault() {
        return this.default;
    }

    protected final boolean getShowDefault() {
        return this.showDefault;
    }

    protected final boolean getShowChoices() {
        return this.showChoices;
    }

    protected final boolean getHideInput() {
        return this.hideInput;
    }

    @NotNull
    protected final Collection<T> getChoices() {
        return this.choices;
    }

    @NotNull
    protected final String getPromptSuffix() {
        return this.promptSuffix;
    }

    @NotNull
    protected final String getInvalidChoiceMessage() {
        return this.invalidChoiceMessage;
    }

    @NotNull
    protected abstract ConversionResult<T> convert(@NotNull String var1);

    @NotNull
    protected String renderValue(T value) {
        return String.valueOf(value);
    }

    @NotNull
    protected Widget makePrompt() {
        StringBuilder stringBuilder;
        StringBuilder $this$makePrompt_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$makePrompt_u24lambda_u240.append(Theme.style$default(this.terminal.getTheme(), "prompt.prompt", null, 2, null).invoke(this.prompt));
        if (this.showChoices && !this.choices.isEmpty()) {
            $this$makePrompt_u24lambda_u240.append(" ");
            $this$makePrompt_u24lambda_u240.append(Theme.style$default(this.terminal.getTheme(), "prompt.choices", null, 2, null).invoke(this.makePromptChoices()));
        }
        if (this.showDefault && this.default != null) {
            $this$makePrompt_u24lambda_u240.append(" ");
            $this$makePrompt_u24lambda_u240.append(Theme.style$default(this.terminal.getTheme(), "prompt.default", null, 2, null).invoke(this.makePromptDefault(this.default)));
        }
        $this$makePrompt_u24lambda_u240.append(this.promptSuffix);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n = 62;
        Integer n2 = null;
        Integer n3 = null;
        OverflowWrap overflowWrap = null;
        TextAlign textAlign = null;
        Whitespace whitespace = null;
        String string2 = string;
        return new Text(string2, whitespace, textAlign, overflowWrap, n3, n2, n, defaultConstructorMarker2);
    }

    @NotNull
    protected String makePromptDefault(T t2) {
        return '(' + this.renderValue(t2) + ')';
    }

    @NotNull
    protected String makePromptChoices() {
        return CollectionsKt.joinToString$default((Iterable)this.choices, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, arg_0 -> Prompt.makePromptChoices$lambda$1(this, arg_0), (int)25, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Widget makeInvalidChoiceMessage() {
        void $this$makeInvalidChoiceMessage_u24lambda_u242;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        TextStyle textStyle = Theme.style$default(this.terminal.getTheme(), "prompt.choices.invalid", null, 2, null);
        boolean bl = false;
        $this$makeInvalidChoiceMessage_u24lambda_u242.append(this.invalidChoiceMessage);
        $this$makeInvalidChoiceMessage_u24lambda_u242.append(this.makePromptChoices());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        int n = 62;
        Integer n2 = null;
        Integer n3 = null;
        OverflowWrap overflowWrap = null;
        TextAlign textAlign = null;
        Whitespace whitespace = null;
        String string2 = textStyle.invoke(string);
        return new Text(string2, whitespace, textAlign, overflowWrap, n3, n2, n, defaultConstructorMarker2);
    }

    protected void beforePrompt() {
    }

    protected void handleInvalidInput(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!StringsKt.isBlank((CharSequence)message)) {
            TerminalExtensionsKt.danger$default(this.terminal, message, null, null, null, null, false, 62, null);
        }
    }

    @Nullable
    public T ask() {
        Object value;
        while (true) {
            String line;
            this.beforePrompt();
            Terminal.print$default(this.terminal, this.makePrompt(), false, 2, null);
            if (this.terminal.readLineOrNull(this.hideInput) == null) {
                return null;
            }
            if (((CharSequence)line).length() == 0 && this.default != null) {
                return this.default;
            }
            ConversionResult<T> result2 = this.convert(line);
            if (!(result2 instanceof ConversionResult.Valid)) {
                if (result2 instanceof ConversionResult.Invalid) {
                    this.handleInvalidInput(((ConversionResult.Invalid)result2).getMessage());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            value = ((ConversionResult.Valid)result2).getValue();
            if (!(!this.choices.isEmpty()) || this.choices.contains(value)) break;
            Terminal.println$default(this.terminal, this.makeInvalidChoiceMessage(), false, 2, null);
        }
        return value;
    }

    private static final CharSequence makePromptChoices$lambda$1(Prompt this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.renderValue(it);
    }
}

