/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0012\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u000e\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010\u00a2\u0006\u0004\b\u000e\u0010\u0013J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ$\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010!\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010 H\u00d6\u0003\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b&\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010\u001dR\u0014\u0010+\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010'\u00a8\u0006-"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "", "etag", "", "weak", "<init>", "(Ljava/lang/String;Z)V", "Lio/ktor/http/Headers;", "requestHeaders", "Lio/ktor/http/content/VersionCheckResult;", "check", "(Lio/ktor/http/Headers;)Lio/ktor/http/content/VersionCheckResult;", "other", "match", "(Lio/ktor/http/content/EntityTagVersion;)Z", "", "givenNoneMatchEtags", "noneMatch", "(Ljava/util/List;)Lio/ktor/http/content/VersionCheckResult;", "givenMatchEtags", "Lio/ktor/http/HeadersBuilder;", "builder", "", "appendHeadersTo", "(Lio/ktor/http/HeadersBuilder;)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "copy", "(Ljava/lang/String;Z)Lio/ktor/http/content/EntityTagVersion;", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getEtag", "Z", "getWeak", "normalized", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1#2:262\n1755#3,3:263\n*S KotlinDebug\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion\n*L\n189#1:263,3\n*E\n"})
public final class EntityTagVersion
implements Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String etag;
    private final boolean weak;
    @NotNull
    private final String normalized;
    @NotNull
    private static final EntityTagVersion STAR = new EntityTagVersion("*", false);

    public EntityTagVersion(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        this.etag = etag;
        this.weak = weak;
        this.normalized = Intrinsics.areEqual((Object)this.etag, (Object)"*") ? this.etag : (StringsKt.startsWith$default((String)this.etag, (String)"\"", (boolean)false, (int)2, null) ? this.etag : HeaderValueWithParametersKt.quote(this.etag));
        int n = ((CharSequence)this.etag).length();
        for (int index = 0; index < n; ++index) {
            char ch = this.etag.charAt(index);
            if (Intrinsics.compare((int)ch, (int)32) > 0 && ch != '\"' || index == 0 || index == StringsKt.getLastIndex((CharSequence)this.etag)) continue;
            boolean bl = false;
            String string = "Character '" + ch + "' is not allowed in entity-tag.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getEtag() {
        return this.etag;
    }

    public final boolean getWeak() {
        return this.weak;
    }

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders2) {
        Object object;
        VersionCheckResult result2;
        String it;
        Intrinsics.checkNotNullParameter((Object)requestHeaders2, (String)"requestHeaders");
        Object object2 = requestHeaders2.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (object2 != null) {
            it = object2;
            boolean bl = false;
            List<EntityTagVersion> list = Companion.parse(it);
            object2 = list;
            if (list != null) {
                Object givenNoneMatchEtags = object2;
                boolean bl2 = false;
                result2 = this.noneMatch((List<EntityTagVersion>)givenNoneMatchEtags);
                boolean bl3 = false;
                if (result2 != VersionCheckResult.OK) {
                    return result2;
                }
            }
        }
        if ((object = requestHeaders2.get(HttpHeaders.INSTANCE.getIfMatch())) != null) {
            it = object;
            boolean bl = false;
            List<EntityTagVersion> list = Companion.parse(it);
            object = list;
            if (list != null) {
                Object givenMatchEtags = object;
                boolean bl4 = false;
                result2 = this.match((List<EntityTagVersion>)givenMatchEtags);
                boolean bl5 = false;
                if (result2 != VersionCheckResult.OK) {
                    return result2;
                }
            }
        }
        return VersionCheckResult.OK;
    }

    public final boolean match(@NotNull EntityTagVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)STAR) || Intrinsics.areEqual((Object)other, (Object)STAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.normalized, (Object)other.normalized);
    }

    @NotNull
    public final VersionCheckResult noneMatch(@NotNull List<EntityTagVersion> givenNoneMatchEtags) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(givenNoneMatchEtags, (String)"givenNoneMatchEtags");
            if (givenNoneMatchEtags.contains(STAR)) {
                return VersionCheckResult.OK;
            }
            Iterable $this$any$iv = givenNoneMatchEtags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EntityTagVersion it = (EntityTagVersion)element$iv;
                    boolean bl2 = false;
                    if (!this.match(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        return VersionCheckResult.OK;
    }

    @NotNull
    public final VersionCheckResult match(@NotNull List<EntityTagVersion> givenMatchEtags) {
        Intrinsics.checkNotNullParameter(givenMatchEtags, (String)"givenMatchEtags");
        if (givenMatchEtags.isEmpty()) {
            return VersionCheckResult.OK;
        }
        if (givenMatchEtags.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        for (EntityTagVersion given : givenMatchEtags) {
            if (!this.match(given)) continue;
            return VersionCheckResult.OK;
        }
        return VersionCheckResult.PRECONDITION_FAILED;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        ApplicationResponsePropertiesKt.etag(builder2, this.normalized);
    }

    @NotNull
    public final String component1() {
        return this.etag;
    }

    public final boolean component2() {
        return this.weak;
    }

    @NotNull
    public final EntityTagVersion copy(@NotNull String etag, boolean weak) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        return new EntityTagVersion(etag, weak);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        if ((n & 2) != 0) {
            bl = entityTagVersion.weak;
        }
        return entityTagVersion.copy(string, bl);
    }

    @NotNull
    public String toString() {
        return "EntityTagVersion(etag=" + this.etag + ", weak=" + this.weak + ')';
    }

    public int hashCode() {
        int result2 = this.etag.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.weak);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityTagVersion)) {
            return false;
        }
        EntityTagVersion entityTagVersion = (EntityTagVersion)other;
        if (!Intrinsics.areEqual((Object)this.etag, (Object)entityTagVersion.etag)) {
            return false;
        }
        return this.weak == entityTagVersion.weak;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/content/EntityTagVersion$Companion;", "", "<init>", "()V", "", "headerValue", "", "Lio/ktor/http/content/EntityTagVersion;", "parse", "(Ljava/lang/String;)Ljava/util/List;", "value", "parseSingle", "(Ljava/lang/String;)Lio/ktor/http/content/EntityTagVersion;", "STAR", "Lio/ktor/http/content/EntityTagVersion;", "getSTAR", "()Lio/ktor/http/content/EntityTagVersion;", "ktor-http"})
    @SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1557#2:262\n1628#2,2:263\n1630#2:266\n1#3:265\n*S KotlinDebug\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion$Companion\n*L\n227#1:262\n227#1:263,2\n227#1:266\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityTagVersion getSTAR() {
            return STAR;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<EntityTagVersion> parse(@NotNull String headerValue) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
            List<HeaderValue> rawEntries = HttpHeaderValueParserKt.parseHeaderValue(headerValue);
            Iterable $this$map$iv = rawEntries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                HeaderValue headerValue2 = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(entry.getQuality() == 1.0)) {
                    boolean $i$a$-check-EntityTagVersion$Companion$parse$1$32 = false;
                    String $i$a$-check-EntityTagVersion$Companion$parse$1$32 = "entity-tag quality parameter is not allowed: " + entry.getQuality() + '.';
                    throw new IllegalStateException($i$a$-check-EntityTagVersion$Companion$parse$1$32.toString());
                }
                if (!entry.getParams().isEmpty()) {
                    boolean bl2 = false;
                    String string = "entity-tag parameters are not allowed: " + entry.getParams() + '.';
                    throw new IllegalStateException(string.toString());
                }
                collection.add(Companion.parseSingle(entry.getValue()));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final EntityTagVersion parseSingle(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)value, (Object)"*")) {
                return this.getSTAR();
            }
            boolean weak = false;
            String rawEtag = null;
            if (StringsKt.startsWith$default((String)value, (String)"W/", (boolean)false, (int)2, null)) {
                weak = true;
                rawEtag = StringsKt.drop((String)value, (int)2);
            } else {
                weak = false;
                rawEtag = value;
            }
            String etag = StringsKt.startsWith$default((String)rawEtag, (String)"\"", (boolean)false, (int)2, null) ? rawEtag : HeaderValueWithParametersKt.quote(rawEtag);
            return new EntityTagVersion(etag, weak);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

