/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import com.auth0.jwt.interfaces.Payload;
import com.auth0.jwt.interfaces.Verification;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationContext;
import io.ktor.server.auth.AuthenticationFailedCause;
import io.ktor.server.auth.AuthenticationProcedureChallenge;
import io.ktor.server.auth.HeadersKt;
import io.ktor.server.auth.jwt.JWTAuthKt;
import io.ktor.server.auth.jwt.JWTAuthSchemes;
import io.ktor.server.auth.jwt.JWTChallengeContext;
import io.ktor.server.auth.jwt.JWTCredential;
import io.ktor.server.auth.jwt.JWTUtilsKt;
import io.ktor.server.request.ApplicationRequest;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0082\u0001\u0010\u0016\u001a\u00020\u0011*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2U\u0010\u0015\u001aQ\b\u0001\u0012\u0004\u0012\u00020\f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000bj\u0002`\u0013\u00a2\u0006\u0002\b\u0014H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001aL\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\t2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00110\u001d\u00a2\u0006\u0002\b\u0014H\u0000\u00a2\u0006\u0004\b!\u0010\"\u001aF\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\t2\u001b\u0010$\u001a\u0017\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00110\u001dj\u0002`#\u00a2\u0006\u0002\b\u0014H\u0000\u00a2\u0006\u0004\b!\u0010%\u001ae\u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\t2/\u0010+\u001a+\b\u0001\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020*\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120)\u00a2\u0006\u0002\b\u0014H\u0080@\u00a2\u0006\u0004\b,\u0010-\u001a\u001d\u0010.\u001a\u0004\u0018\u00010\u0007*\u00020\u001b2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b.\u0010/\u001a\u0015\u00101\u001a\u0004\u0018\u00010\u001b*\u000200H\u0000\u00a2\u0006\u0004\b1\u00102\u001a\u0013\u00105\u001a\u000204*\u000203H\u0000\u00a2\u0006\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/auth0/jwk/Jwk;", "Lcom/auth0/jwt/algorithms/Algorithm;", "makeAlgorithm", "(Lcom/auth0/jwk/Jwk;)Lcom/auth0/jwt/algorithms/Algorithm;", "Lio/ktor/server/auth/AuthenticationContext;", "Lio/ktor/server/auth/AuthenticationFailedCause;", "cause", "", "realm", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "schemes", "Lkotlin/Function4;", "Lio/ktor/server/auth/jwt/JWTChallengeContext;", "Lkotlin/ParameterName;", "name", "defaultScheme", "Lkotlin/coroutines/Continuation;", "", "", "Lio/ktor/server/auth/jwt/JWTAuthChallengeFunction;", "Lkotlin/ExtensionFunctionType;", "challengeFunction", "bearerChallenge", "(Lio/ktor/server/auth/AuthenticationContext;Lio/ktor/server/auth/AuthenticationFailedCause;Ljava/lang/String;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function4;)V", "Lcom/auth0/jwk/JwkProvider;", "jwkProvider", "issuer", "Lio/ktor/http/auth/HttpAuthHeader;", "token", "Lkotlin/Function1;", "Lcom/auth0/jwt/interfaces/Verification;", "jwtConfigure", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "getVerifier", "(Lcom/auth0/jwk/JwkProvider;Ljava/lang/String;Lio/ktor/http/auth/HttpAuthHeader;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function1;)Lcom/auth0/jwt/interfaces/JWTVerifier;", "Lio/ktor/server/auth/jwt/JWTConfigureFunction;", "configure", "(Lcom/auth0/jwk/JwkProvider;Lio/ktor/http/auth/HttpAuthHeader;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function1;)Lcom/auth0/jwt/interfaces/JWTVerifier;", "Lio/ktor/server/application/ApplicationCall;", "call", "jwtVerifier", "Lkotlin/Function3;", "Lio/ktor/server/auth/jwt/JWTCredential;", "validate", "verifyAndValidate", "(Lio/ktor/server/application/ApplicationCall;Lcom/auth0/jwt/interfaces/JWTVerifier;Lio/ktor/http/auth/HttpAuthHeader;Lio/ktor/server/auth/jwt/JWTAuthSchemes;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBlob", "(Lio/ktor/http/auth/HttpAuthHeader;Lio/ktor/server/auth/jwt/JWTAuthSchemes;)Ljava/lang/String;", "Lio/ktor/server/request/ApplicationRequest;", "parseAuthorizationHeaderOrNull", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/auth/HttpAuthHeader;", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "Lcom/auth0/jwt/interfaces/Payload;", "parsePayload", "(Lcom/auth0/jwt/interfaces/DecodedJWT;)Lcom/auth0/jwt/interfaces/Payload;", "ktor-server-auth-jwt"})
@SourceDebugExtension(value={"SMAP\nJWTUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWTUtils.kt\nio/ktor/server/auth/jwt/JWTUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class JWTUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Algorithm makeAlgorithm(@NotNull Jwk $this$makeAlgorithm) {
        Algorithm algorithm;
        block13: {
            block17: {
                block14: {
                    block16: {
                        block18: {
                            block15: {
                                String string;
                                Intrinsics.checkNotNullParameter((Object)$this$makeAlgorithm, (String)"<this>");
                                String string2 = string = $this$makeAlgorithm.getAlgorithm();
                                if (string2 == null) break block13;
                                switch (string2.hashCode()) {
                                    case 66246401: {
                                        if (!string.equals("ES384")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block14;
                                    }
                                    case 78252174: {
                                        if (!string.equals("RS384")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block15;
                                    }
                                    case 66245349: {
                                        if (!string.equals("ES256")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block16;
                                    }
                                    case 78251122: {
                                        if (string.equals("RS256")) break;
                                        throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                    }
                                    case 66248104: {
                                        if (!string.equals("ES512")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block17;
                                    }
                                    case 78253877: {
                                        if (!string.equals("RS512")) {
                                            throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
                                        }
                                        break block18;
                                    }
                                }
                                PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                                Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                                Algorithm algorithm2 = Algorithm.RSA256((RSAPublicKey)publicKey, null);
                                algorithm = algorithm2;
                                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"RSA256(...)");
                                return algorithm;
                            }
                            PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                            Algorithm algorithm3 = Algorithm.RSA384((RSAPublicKey)publicKey, null);
                            algorithm = algorithm3;
                            Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"RSA384(...)");
                            return algorithm;
                        }
                        PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                        Algorithm algorithm4 = Algorithm.RSA512((RSAPublicKey)publicKey, null);
                        algorithm = algorithm4;
                        Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"RSA512(...)");
                        return algorithm;
                    }
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    Algorithm algorithm5 = Algorithm.ECDSA256((ECPublicKey)publicKey, null);
                    algorithm = algorithm5;
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm5, (String)"ECDSA256(...)");
                    return algorithm;
                }
                PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                Algorithm algorithm6 = Algorithm.ECDSA384((ECPublicKey)publicKey, null);
                algorithm = algorithm6;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm6, (String)"ECDSA384(...)");
                return algorithm;
            }
            PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            Algorithm algorithm7 = Algorithm.ECDSA512((ECPublicKey)publicKey, null);
            algorithm = algorithm7;
            Intrinsics.checkNotNullExpressionValue((Object)algorithm7, (String)"ECDSA512(...)");
            return algorithm;
        }
        PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        Algorithm algorithm8 = Algorithm.RSA256((RSAPublicKey)publicKey, null);
        algorithm = algorithm8;
        Intrinsics.checkNotNullExpressionValue((Object)algorithm8, (String)"RSA256(...)");
        return algorithm;
        throw new IllegalArgumentException("Unsupported algorithm " + $this$makeAlgorithm.getAlgorithm());
    }

    public static final void bearerChallenge(@NotNull AuthenticationContext $this$bearerChallenge, @NotNull AuthenticationFailedCause cause, @NotNull String realm, @NotNull JWTAuthSchemes schemes, @NotNull Function4<? super JWTChallengeContext, ? super String, ? super String, ? super Continuation<? super Unit>, ? extends Object> challengeFunction2) {
        Intrinsics.checkNotNullParameter((Object)$this$bearerChallenge, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)realm, (String)"realm");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(challengeFunction2, (String)"challengeFunction");
        $this$bearerChallenge.challenge(JWTAuthKt.getJWTAuthKey(), cause, (Function3<? super AuthenticationProcedureChallenge, ? super ApplicationCall, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object>(challengeFunction2, schemes, realm, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object> $challengeFunction;
            final /* synthetic */ JWTAuthSchemes $schemes;
            final /* synthetic */ String $realm;
            {
                this.$challengeFunction = $challengeFunction;
                this.$schemes = $schemes;
                this.$realm = $realm;
                super(3, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        challenge = (AuthenticationProcedureChallenge)this.L$0;
                        call = (ApplicationCall)this.L$1;
                        this.L$0 = challenge;
                        this.L$1 = call;
                        this.label = 1;
                        v0 = this.$challengeFunction.invoke((Object)new JWTChallengeContext(call), (Object)this.$schemes.getDefaultScheme(), (Object)this.$realm, (Object)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        call = (ApplicationCall)this.L$1;
                        challenge = (AuthenticationProcedureChallenge)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (!challenge.getCompleted() && call.getResponse().status() != null) {
                            challenge.complete();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(AuthenticationProcedureChallenge p1, ApplicationCall p2, Continuation<? super Unit> p3) {
                Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public static final JWTVerifier getVerifier(@NotNull JwkProvider jwkProvider, @Nullable String issuer, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function1<? super Verification, Unit> jwtConfigure) {
        Object object;
        Object object2;
        block10: {
            block9: {
                Jwk jwk;
                Intrinsics.checkNotNullParameter((Object)jwkProvider, (String)"jwkProvider");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
                Intrinsics.checkNotNullParameter(jwtConfigure, (String)"jwtConfigure");
                object2 = JWTUtilsKt.getBlob(token, schemes);
                if (object2 == null) break block9;
                String blob = object2;
                boolean bl = false;
                try {
                    jwk = jwkProvider.get(JWT.decode(blob).getKeyId());
                }
                catch (JwkException cause) {
                    JWTAuthKt.getJWTLogger().trace("Failed to get JWK", cause);
                    jwk = null;
                }
                catch (JWTDecodeException cause) {
                    JWTAuthKt.getJWTLogger().trace("Illegal JWT", cause);
                    jwk = null;
                }
                Jwk jwk2 = jwk;
                object2 = jwk2;
                if (jwk2 != null) break block10;
            }
            return null;
        }
        Object jwk = object2;
        try {
            object = JWTUtilsKt.makeAlgorithm((Jwk)jwk);
        }
        catch (Throwable cause) {
            Logger logger = JWTAuthKt.getJWTLogger();
            String string = ((Jwk)jwk).getAlgorithm();
            String string2 = cause.getMessage();
            if (string2 == null) {
                string2 = cause.getClass().getSimpleName();
            }
            logger.trace("Failed to create algorithm {}: {}", (Object)string, (Object)string2);
            return null;
        }
        Algorithm algorithm = object;
        object = issuer == null ? JWT.require(algorithm) : JWT.require(algorithm).withIssuer(issuer);
        jwtConfigure.invoke(object);
        return object.build();
    }

    @Nullable
    public static final JWTVerifier getVerifier(@NotNull JwkProvider jwkProvider, @NotNull HttpAuthHeader token, @NotNull JWTAuthSchemes schemes, @NotNull Function1<? super Verification, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)jwkProvider, (String)"jwkProvider");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        return JWTUtilsKt.getVerifier(jwkProvider, null, token, schemes, configure);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object verifyAndValidate(@NotNull ApplicationCall var0, @Nullable JWTVerifier var1_1, @NotNull HttpAuthHeader var2_2, @NotNull JWTAuthSchemes var3_3, @NotNull Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<Object>, ? extends Object> var4_4, @NotNull Continuation<Object> $completion) {
        if (!($completion instanceof verifyAndValidate.1)) ** GOTO lbl-1000
        var13_6 = $completion;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JWTUtilsKt.verifyAndValidate(null, null, null, null, null, (Continuation<Object>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    v0 = JWTUtilsKt.getBlob((HttpAuthHeader)token, (JWTAuthSchemes)schemes);
                    if (v0 != null) {
                        it = v0;
                        $i$a$-let-JWTUtilsKt$verifyAndValidate$jwt$1 = false;
                        v1 = jwtVerifier;
                        v2 = v1 != null ? v1.verify(it) : null;
                    } else {
                        v2 = null;
                    }
                    var8_11 = v2;
                }
                catch (JWTVerificationException cause) {
                    JWTAuthKt.getJWTLogger().debug("JWT verification failed: " + cause.getMessage(), cause);
                    var8_11 = null;
                }
                v3 = var8_11;
                if (v3 == null) {
                    return null;
                }
                jwt = v3;
                payload = JWTUtilsKt.parsePayload(jwt);
                credentials = new JWTCredential(payload);
                $continuation.label = 1;
                v4 = validate.invoke((Object)call, (Object)credentials, (Object)$continuation);
                if (v4 == var14_8) {
                    return var14_8;
                }
                ** GOTO lbl41
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl41:
                // 2 sources

                if ((principal = v4) == null) {
                    JWTAuthKt.getJWTLogger().debug("JWT validation failed: Custom validation returned null");
                }
                return principal;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final String getBlob(@NotNull HttpAuthHeader $this$getBlob, @NotNull JWTAuthSchemes schemes) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlob, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        return $this$getBlob instanceof HttpAuthHeader.Single && schemes.contains($this$getBlob.getAuthScheme()) ? ((HttpAuthHeader.Single)$this$getBlob).getBlob() : null;
    }

    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeaderOrNull(@NotNull ApplicationRequest $this$parseAuthorizationHeaderOrNull) {
        HttpAuthHeader httpAuthHeader;
        Intrinsics.checkNotNullParameter((Object)$this$parseAuthorizationHeaderOrNull, (String)"<this>");
        try {
            httpAuthHeader = HeadersKt.parseAuthorizationHeader($this$parseAuthorizationHeaderOrNull);
        }
        catch (IllegalArgumentException cause) {
            JWTAuthKt.getJWTLogger().trace("Illegal HTTP auth header", cause);
            httpAuthHeader = null;
        }
        return httpAuthHeader;
    }

    @NotNull
    public static final Payload parsePayload(@NotNull DecodedJWT $this$parsePayload) {
        Intrinsics.checkNotNullParameter((Object)$this$parsePayload, (String)"<this>");
        byte[] byArray = Base64.getUrlDecoder().decode($this$parsePayload.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        String payloadString = new String(byArray2, Charsets.UTF_8);
        Payload payload = new JWTParser().parsePayload(payloadString);
        Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"parsePayload(...)");
        return payload;
    }
}

