/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.Cache;
import io.ktor.server.sessions.KeyState;
import io.ktor.server.sessions.ListElement;
import io.ktor.server.sessions.PullableLinkedList;
import io.ktor.server.sessions.TimeoutWorker;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0002 \u0000*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B+\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\r\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J!\u0010\u0019\u001a\u00020\u00142\u0006\u0010\f\u001a\u00028\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00142\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001dR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001eR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R \u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R&\u0010,\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000(0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001b\u00103\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lio/ktor/server/sessions/BaseTimeoutCache;", "", "K", "V", "Lio/ktor/server/sessions/Cache;", "", "timeoutValue", "", "touchOnGet", "delegate", "<init>", "(JZLio/ktor/server/sessions/Cache;)V", "key", "getOrCompute", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "peek", "(Ljava/lang/Object;)Ljava/lang/Object;", "invalidate", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "", "invalidateAll", "()V", "forkIfNeeded", "create", "pull", "(Ljava/lang/Object;Z)V", "remove", "(Ljava/lang/Object;)V", "J", "Z", "Lio/ktor/server/sessions/Cache;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "cond", "Ljava/util/concurrent/locks/Condition;", "Lio/ktor/server/sessions/PullableLinkedList;", "Lio/ktor/server/sessions/KeyState;", "items", "Lio/ktor/server/sessions/PullableLinkedList;", "Ljava/util/WeakHashMap;", "map", "Ljava/util/WeakHashMap;", "Ljava/lang/Thread;", "workerThread$delegate", "Lkotlin/Lazy;", "getWorkerThread", "()Ljava/lang/Thread;", "workerThread", "ktor-server-sessions"})
@SourceDebugExtension(value={"SMAP\nCacheJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheJvm.kt\nio/ktor/server/sessions/BaseTimeoutCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n381#2,7:273\n1#3:280\n*S KotlinDebug\n*F\n+ 1 CacheJvm.kt\nio/ktor/server/sessions/BaseTimeoutCache\n*L\n149#1:273,7\n*E\n"})
public final class BaseTimeoutCache<K, V>
implements Cache<K, V> {
    private final long timeoutValue;
    private final boolean touchOnGet;
    @NotNull
    private final Cache<K, V> delegate;
    @NotNull
    private final ReentrantLock lock;
    private final Condition cond;
    @NotNull
    private final PullableLinkedList<KeyState<K>> items;
    @NotNull
    private final WeakHashMap<K, KeyState<K>> map;
    @NotNull
    private final Lazy workerThread$delegate;

    public BaseTimeoutCache(long timeoutValue, boolean touchOnGet, @NotNull Cache<? super K, V> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.timeoutValue = timeoutValue;
        this.touchOnGet = touchOnGet;
        this.delegate = delegate;
        this.lock = new ReentrantLock();
        this.cond = this.lock.newCondition();
        this.items = new PullableLinkedList();
        this.map = new WeakHashMap();
        this.workerThread$delegate = LazyKt.lazy(() -> BaseTimeoutCache.workerThread_delegate$lambda$1(this));
    }

    private final Thread getWorkerThread() {
        Lazy lazy = this.workerThread$delegate;
        return (Thread)lazy.getValue();
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull K key2, @NotNull Continuation<? super V> $completion) {
        if (this.touchOnGet) {
            BaseTimeoutCache.pull$default(this, key2, false, 2, null);
        }
        return this.delegate.getOrCompute(key2, $completion);
    }

    @Override
    @Nullable
    public V peek(@NotNull K key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        if (this.touchOnGet) {
            this.pull(key2, false);
        }
        return this.delegate.peek(key2);
    }

    @Override
    @Nullable
    public V invalidate(@NotNull K key2) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        this.remove(key2);
        return this.delegate.invalidate(key2);
    }

    @Override
    public boolean invalidate(@NotNull K key2, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (this.delegate.invalidate(key2, value)) {
            this.remove(key2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.items.clear();
            this.cond.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void forkIfNeeded() {
        if (!this.items.isEmpty() && !this.getWorkerThread().isAlive()) {
            throw new IllegalStateException("Daemon thread is already dead");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void pull(K key2, boolean create) {
        Lock lock = this.lock;
        lock.lock();
        try {
            KeyState state;
            KeyState keyState;
            boolean bl = false;
            if (create) {
                Object object;
                Map $this$getOrPut$iv = this.map;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key2);
                if (value$iv == null) {
                    boolean bl2 = false;
                    KeyState<K> answer$iv = new KeyState<K>(key2, this.timeoutValue);
                    $this$getOrPut$iv.put(key2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                keyState = (KeyState)object;
            } else {
                keyState = state = this.map.get(key2);
            }
            if (state != null) {
                state.touch();
                this.items.pull((KeyState<K>)((ListElement)state));
                this.cond.signalAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.forkIfNeeded();
    }

    static /* synthetic */ void pull$default(BaseTimeoutCache baseTimeoutCache, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        baseTimeoutCache.pull(object, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void remove(K key2) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            KeyState<K> keyState = this.map.remove(key2);
            if (keyState != null) {
                KeyState<K> it = keyState;
                boolean bl2 = false;
                this.items.remove((KeyState<K>)((ListElement)it));
                this.cond.signalAll();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    private static final Thread workerThread_delegate$lambda$1(BaseTimeoutCache this$0) {
        Thread thread;
        ReentrantLock reentrantLock = this$0.lock;
        Condition condition = this$0.cond;
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"cond");
        Thread $this$workerThread_delegate_u24lambda_u241_u24lambda_u240 = thread = new Thread(new TimeoutWorker(this$0, reentrantLock, condition, this$0.items));
        boolean bl = false;
        $this$workerThread_delegate_u24lambda_u241_u24lambda_u240.setDaemon(true);
        $this$workerThread_delegate_u24lambda_u241_u24lambda_u240.start();
        return thread;
    }
}

