/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LABColorSpace;
import com.github.ajalt.colormath.model.LABColorSpaces;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabKt;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/github/ajalt/colormath/model/LAB;", "Lcom/github/ajalt/colormath/Color;", "l", "", "a", "b", "alpha", "space", "Lcom/github/ajalt/colormath/model/LABColorSpace;", "<init>", "(FFFFLcom/github/ajalt/colormath/model/LABColorSpace;)V", "getL", "()F", "getA", "getB", "getAlpha", "getSpace", "()Lcom/github/ajalt/colormath/model/LABColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toLCHab", "Lcom/github/ajalt/colormath/model/LCHab;", "toLAB", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nLAB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LAB.kt\ncom/github/ajalt/colormath/model/LAB\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n+ 4 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,109:1\n1#2:110\n31#3,3:111\n89#4,12:114\n*S KotlinDebug\n*F\n+ 1 LAB.kt\ncom/github/ajalt/colormath/model/LAB\n*L\n102#1:111,3\n107#1:114,12\n*E\n"})
public final class LAB
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float a;
    private final float b;
    private final float alpha;
    @NotNull
    private final LABColorSpace space;

    public LAB(float l, float a, float b, float alpha, @NotNull LABColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.l = l;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getA() {
        return this.a;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LABColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.l == 0.0f ? RGB.Companion.invoke(0.0f, 0.0f, 0.0f, this.getAlpha()) : this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        XYZColorSpace xyzSpace = XYZKt.XYZColorSpace(this.getSpace().getWhitePoint());
        if (this.l == 0.0f) {
            return XYZColorSpace.DefaultImpls.invoke$default(xyzSpace, 0.0, 0.0, 0.0, null, 8, null);
        }
        double fy = (double)(this.l + (float)16) / 116.0;
        double fz = fy - (double)this.b / 200.0;
        double fx = (double)this.a / 500.0 + fy;
        double yr = (double)this.l > 8.0 ? Math.pow(fy, 3) : (double)this.l / 903.2962962962963;
        double it = Math.pow(fz, 3);
        boolean bl = false;
        double zr = it > 0.008856451679035631 ? it : ((double)116 * fz - (double)16) / 903.2962962962963;
        double it2 = Math.pow(fx, 3);
        boolean bl2 = false;
        double xr = it2 > 0.008856451679035631 ? it2 : ((double)116 * fx - (double)16) / 903.2962962962963;
        xyY wp = this.getSpace().getWhitePoint().getChromaticity();
        return xyzSpace.invoke(xr * (double)wp.getAbsoluteX(), yr * (double)wp.getAbsoluteY(), zr * (double)wp.getAbsoluteZ(), Float.valueOf(this.getAlpha()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LCHab toLCHab() {
        void h2;
        void a$iv;
        float f = this.a;
        float b$iv = this.b;
        boolean $i$f$toPolarModel = false;
        float c$iv = (float)Math.sqrt((double)(a$iv * a$iv + b$iv * b$iv));
        float h$iv = (double)c$iv > -1.0E-7 && (double)c$iv < 1.0E-7 ? Float.NaN : InternalMathKt.radToDeg((float)Math.atan2(b$iv, (double)a$iv));
        float f2 = InternalMathKt.normalizeDeg(h$iv);
        float c = c$iv;
        boolean bl = false;
        return LCHabKt.LCHabColorSpace(this.getSpace().getWhitePoint()).invoke(this.l, c, (float)h2, this.getAlpha());
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.a, this.b, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LAB clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clamp3$iv;
        Color color2 = this;
        float f = this.l;
        float f2 = this.a;
        float f3 = this.b;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clamp3 = false;
        List<ColorComponentInfo> list = $this$clamp3$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clamp3$iv;
                        return (LAB)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn(alpha$iv, 0.0f, 1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, c3$iv.getMin(), c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, c2$iv.getMin(), c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, c1$iv.getMin(), c1$iv.getMax());
        boolean bl5 = false;
        color = LAB.copy$default(this, p0, (float)p1, (float)p2, (float)p3, null, 16, null);
        return (LAB)color;
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.a;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final LABColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final LAB copy(float l, float a, float b, float alpha, @NotNull LABColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new LAB(l, a, b, alpha, space);
    }

    public static /* synthetic */ LAB copy$default(LAB lAB, float f, float f2, float f3, float f4, LABColorSpace lABColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lAB.l;
        }
        if ((n & 2) != 0) {
            f2 = lAB.a;
        }
        if ((n & 4) != 0) {
            f3 = lAB.b;
        }
        if ((n & 8) != 0) {
            f4 = lAB.alpha;
        }
        if ((n & 0x10) != 0) {
            lABColorSpace = lAB.space;
        }
        return lAB.copy(f, f2, f3, f4, lABColorSpace);
    }

    @NotNull
    public String toString() {
        return "LAB(l=" + this.l + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.a);
        result2 = result2 * 31 + Float.hashCode(this.b);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.space.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LAB)) {
            return false;
        }
        LAB lAB = (LAB)other;
        if (Float.compare(this.l, lAB.l) != 0) {
            return false;
        }
        if (Float.compare(this.a, lAB.a) != 0) {
            return false;
        }
        if (Float.compare(this.b, lAB.b) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, lAB.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.space, lAB.space);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0096\u0003J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0003R\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0005R\t\u0010\u001a\u001a\u00020\u001bX\u0096\u0005R\t\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/colormath/model/LAB$Companion;", "Lcom/github/ajalt/colormath/model/LABColorSpace;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "convert", "Lcom/github/ajalt/colormath/model/LAB;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "components", "", "invoke", "l", "", "a", "b", "alpha", "", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "name", "", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "colormath"})
    public static final class Companion
    implements LABColorSpace {
        private final /* synthetic */ LABColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LABColorSpaces.INSTANCE.getLAB65();
        }

        @Override
        @NotNull
        public LAB invoke(float l, float a, float b, float alpha) {
            return this.$$delegate_0.invoke(l, a, b, alpha);
        }

        @Override
        @NotNull
        public LAB invoke(@NotNull Number l, @NotNull Number a, @NotNull Number b, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(l, "l");
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(l, a, b, alpha);
        }

        @Override
        @NotNull
        public LAB convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (LAB)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LAB create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (LAB)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual(LABColorSpaces.INSTANCE.getLAB65(), other);
        }

        public int hashCode() {
            return LABColorSpaces.INSTANCE.getLAB65().hashCode();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

