/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.Digest;
import io.ktor.util.DigestImpl;
import io.ktor.util.NonceKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=5, xi=48, d1={"\u0000\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001aD\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u00022\u0006\u0010\u0001\u001a\u00020\u00002!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00000\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0015\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u000f\u0010\u0017\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0018"}, d2={"", "algorithm", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "salt", "", "getDigestFunction", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function1;", "text", "getDigest$CryptoKt__CryptoJvmKt", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)[B", "getDigest", "bytes", "sha1", "([B)[B", "Lio/ktor/util/Digest;", "Digest", "(Ljava/lang/String;)Lio/ktor/util/Digest;", "generateNonce", "()Ljava/lang/String;", "generateNonceBlocking$CryptoKt__CryptoJvmKt", "generateNonceBlocking", "ktor-utils"}, xs="io/ktor/util/CryptoKt")
final class CryptoKt__CryptoJvmKt {
    @NotNull
    public static final Function1<String, byte[]> getDigestFunction(@NotNull String algorithm, @NotNull Function1<? super String, String> salt) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(salt, "salt");
        return arg_0 -> CryptoKt__CryptoJvmKt.getDigestFunction$lambda$0$CryptoKt__CryptoJvmKt(algorithm, salt, arg_0);
    }

    private static final byte[] getDigest$CryptoKt__CryptoJvmKt(String text2, String algorithm, Function1<? super String, String> salt) {
        MessageDigest $this$getDigest_u24lambda_u241 = MessageDigest.getInstance(algorithm);
        boolean bl = false;
        byte[] byArray = salt.invoke(text2).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        $this$getDigest_u24lambda_u241.update(byArray);
        byte[] byArray2 = text2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        byte[] byArray3 = $this$getDigest_u24lambda_u241.digest(byArray2);
        Intrinsics.checkNotNullExpressionValue(byArray3, "with(...)");
        return byArray3;
    }

    @NotNull
    public static final byte[] sha1(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        byte[] byArray = MessageDigest.getInstance("SHA1").digest(bytes);
        Intrinsics.checkNotNullExpressionValue(byArray, "digest(...)");
        return byArray;
    }

    @NotNull
    public static final Digest Digest(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        MessageDigest messageDigest = MessageDigest.getInstance(name);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(...)");
        return DigestImpl.box-impl(DigestImpl.constructor-impl(messageDigest));
    }

    @NotNull
    public static final String generateNonce() {
        String nonce = (String)ChannelResult.getOrNull-impl(NonceKt.getSeedChannel().tryReceive-PtdJZtk());
        if (nonce != null) {
            return nonce;
        }
        return CryptoKt__CryptoJvmKt.generateNonceBlocking$CryptoKt__CryptoJvmKt();
    }

    private static final String generateNonceBlocking$CryptoKt__CryptoJvmKt() {
        NonceKt.ensureNonceGeneratorRunning();
        return (String)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super String>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = NonceKt.getSeedChannel().receive(this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private static final byte[] getDigestFunction$lambda$0$CryptoKt__CryptoJvmKt(String $algorithm, Function1 $salt, String e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return CryptoKt__CryptoJvmKt.getDigest$CryptoKt__CryptoJvmKt(e, $algorithm, $salt);
    }
}

