/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.InlineOnly;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import kotlin.time.Instant;
import kotlin.time.InstantFormatException;
import kotlin.time.UnboundLocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0003\u001a'\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0082\b\u001a'\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0082\b\u001a\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0014H\u0000\u001a\u0014\u0010&\u001a\u00020\u0014*\u00020\u00142\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u0014\u0010,\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010-\u001a\u00020\u0014H\u0002\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\"\u001f\u0010\u0006\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\u0006\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0014X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"isDistantPast", "", "Lkotlin/time/Instant;", "isDistantPast$annotations", "(Lkotlin/time/Instant;)V", "(Lkotlin/time/Instant;)Z", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "parseIso", "isoString", "", "formatIso", "", "instant", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "safeAddOrElse", "a", "b", "action", "Lkotlin/Function0;", "", "safeMultiplyOrElse", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "isLeapYear", "year", "monthLength", "POWERS_OF_TEN", "", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString", "truncateForErrorMessage", "maxLength", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlin/time/InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,799:1\n1#2:800\n*E\n"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    @NotNull
    private static final int[] POWERS_OF_TEN;
    @NotNull
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    @NotNull
    private static final int[] colonsInIsoOffsetString;
    @NotNull
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant $this$isDistantPast) {
        Intrinsics.checkNotNullParameter($this$isDistantPast, "<this>");
        return $this$isDistantPast.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant $this$isDistantFuture) {
        Intrinsics.checkNotNullParameter($this$isDistantFuture, "<this>");
        return $this$isDistantFuture.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalTime
    @InlineOnly
    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExperimentalTime
    private static final Instant parseIso(CharSequence isoString) {
        int n;
        int nanosecond;
        int n2;
        int year2;
        int n3;
        CharSequence s2 = isoString;
        int i2 = 0;
        if (!(s2.length() > 0)) {
            boolean $i$a$-require-InstantKt$parseIso$22 = false;
            String $i$a$-require-InstantKt$parseIso$22 = "An empty string is not a valid Instant";
            throw new IllegalArgumentException($i$a$-require-InstantKt$parseIso$22.toString());
        }
        char c = s2.charAt(i2);
        switch (c) {
            case '+': 
            case '-': {
                ++i2;
                n3 = c;
                break;
            }
            default: {
                n3 = 32;
            }
        }
        int yearSign = n3;
        int yearStart = i2;
        int absYear = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            boolean bl = '0' <= c2 ? c2 < ':' : false;
            if (!bl) break;
            absYear = absYear * 10 + (s2.charAt(i2) - 48);
            ++i2;
        }
        int yearStrLength = i2 - yearStart;
        if (yearStrLength > 10) {
            InstantKt.parseIso$parseFailure(isoString, "Expected at most 10 digits for the year number, got " + yearStrLength + " digits");
            throw new KotlinNothingValueException();
        }
        if (yearStrLength == 10 && Intrinsics.compare(s2.charAt(yearStart), 50) >= 0) {
            InstantKt.parseIso$parseFailure(isoString, "Expected at most 9 digits for the year number or year 1000000000, got " + yearStrLength + " digits");
            throw new KotlinNothingValueException();
        }
        if (yearStrLength < 4) {
            InstantKt.parseIso$parseFailure(isoString, "The year number must be padded to 4 digits, got " + yearStrLength + " digits");
            throw new KotlinNothingValueException();
        }
        if (yearSign == 43 && yearStrLength == 4) {
            InstantKt.parseIso$parseFailure(isoString, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
            throw new KotlinNothingValueException();
        }
        if (yearSign == 32 && yearStrLength != 4) {
            InstantKt.parseIso$parseFailure(isoString, "A '+' or '-' sign is required for year numbers longer than 4 digits");
            throw new KotlinNothingValueException();
        }
        int n4 = year2 = yearSign == 45 ? -absYear : absYear;
        if (s2.length() < i2 + 16) {
            InstantKt.parseIso$parseFailure(isoString, "The input string is too short");
            throw new KotlinNothingValueException();
        }
        InstantKt.parseIso$expect(isoString, "'-'", i2, InstantKt::parseIso$lambda$1);
        InstantKt.parseIso$expect(isoString, "'-'", i2 + 3, InstantKt::parseIso$lambda$2);
        InstantKt.parseIso$expect(isoString, "'T' or 't'", i2 + 6, InstantKt::parseIso$lambda$3);
        InstantKt.parseIso$expect(isoString, "':'", i2 + 9, InstantKt::parseIso$lambda$4);
        InstantKt.parseIso$expect(isoString, "':'", i2 + 12, InstantKt::parseIso$lambda$5);
        for (int j : asciiDigitPositionsInIsoStringAfterYear) {
            InstantKt.parseIso$expect(isoString, "an ASCII digit", i2 + j, InstantKt::parseIso$lambda$6);
        }
        int month = InstantKt.parseIso$twoDigitNumber(s2, i2 + 1);
        int day2 = InstantKt.parseIso$twoDigitNumber(s2, i2 + 4);
        int hour2 = InstantKt.parseIso$twoDigitNumber(s2, i2 + 7);
        int minute2 = InstantKt.parseIso$twoDigitNumber(s2, i2 + 10);
        int second2 = InstantKt.parseIso$twoDigitNumber(s2, i2 + 13);
        if (s2.charAt(i2 + 15) != '.') {
            i2 += 15;
            n2 = 0;
        } else {
            int fractionStrLength;
            int fractionStart;
            int fraction = 0;
            for (i2 = fractionStart = i2 + 16; i2 < s2.length(); ++i2) {
                char c3 = s2.charAt(i2);
                boolean bl = '0' <= c3 ? c3 < ':' : false;
                if (!bl) break;
                fraction = fraction * 10 + (s2.charAt(i2) - 48);
            }
            if (!(1 <= (fractionStrLength = i2 - fractionStart) ? fractionStrLength < 10 : false)) {
                InstantKt.parseIso$parseFailure(isoString, "1..9 digits are supported for the fraction of the second, got " + fractionStrLength + " digits");
                throw new KotlinNothingValueException();
            }
            n2 = nanosecond = fraction * POWERS_OF_TEN[9 - fractionStrLength];
        }
        if (i2 >= s2.length()) {
            InstantKt.parseIso$parseFailure(isoString, "The UTC offset at the end of the string is missing");
            throw new KotlinNothingValueException();
        }
        char sign = s2.charAt(i2);
        switch (sign) {
            case 'Z': 
            case 'z': {
                if (s2.length() != i2 + 1) {
                    InstantKt.parseIso$parseFailure(isoString, "Extra text after the instant at position " + (i2 + 1));
                    throw new KotlinNothingValueException();
                }
                n = 0;
                break;
            }
            case '+': 
            case '-': {
                int offsetSecond;
                int n5;
                int offsetStrLength = s2.length() - i2;
                if (offsetStrLength > 9) {
                    CharSequence charSequence = s2;
                    int n6 = charSequence.length();
                    InstantKt.parseIso$parseFailure(isoString, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)charSequence.subSequence(i2, n6)).toString(), 16) + "\" is too long");
                    throw new KotlinNothingValueException();
                }
                if (offsetStrLength % 3 != 0) {
                    CharSequence charSequence = s2;
                    int n7 = charSequence.length();
                    InstantKt.parseIso$parseFailure(isoString, "Invalid UTC offset string \"" + ((Object)charSequence.subSequence(i2, n7)).toString() + '\"');
                    throw new KotlinNothingValueException();
                }
                for (int j : colonsInIsoOffsetString) {
                    if (i2 + j >= s2.length()) break;
                    if (s2.charAt(i2 + j) == ':') continue;
                    InstantKt.parseIso$parseFailure(isoString, "Expected ':' at index " + (i2 + j) + ", got '" + s2.charAt(i2 + j) + '\'');
                    throw new KotlinNothingValueException();
                }
                for (int j : asciiDigitsInIsoOffsetString) {
                    if (i2 + j >= s2.length()) break;
                    n5 = s2.charAt(i2 + j);
                    if (48 <= n5 ? n5 < 58 : false) continue;
                    InstantKt.parseIso$parseFailure(isoString, "Expected an ASCII digit at index " + (i2 + j) + ", got '" + s2.charAt(i2 + j) + '\'');
                    throw new KotlinNothingValueException();
                }
                int offsetHour = InstantKt.parseIso$twoDigitNumber(s2, i2 + 1);
                int offsetMinute = offsetStrLength > 3 ? InstantKt.parseIso$twoDigitNumber(s2, i2 + 4) : 0;
                int n8 = offsetSecond = offsetStrLength > 6 ? InstantKt.parseIso$twoDigitNumber(s2, i2 + 7) : 0;
                if (offsetMinute > 59) {
                    InstantKt.parseIso$parseFailure(isoString, "Expected offset-minute-of-hour in 0..59, got " + offsetMinute);
                    throw new KotlinNothingValueException();
                }
                if (offsetSecond > 59) {
                    InstantKt.parseIso$parseFailure(isoString, "Expected offset-second-of-minute in 0..59, got " + offsetSecond);
                    throw new KotlinNothingValueException();
                }
                if (offsetHour > 17 && (offsetHour != 18 || offsetMinute != 0 || offsetSecond != 0)) {
                    CharSequence charSequence = s2;
                    n5 = charSequence.length();
                    InstantKt.parseIso$parseFailure(isoString, "Expected an offset in -18:00..+18:00, got " + ((Object)charSequence.subSequence(i2, n5)).toString());
                    throw new KotlinNothingValueException();
                }
                n = (offsetHour * 3600 + offsetMinute * 60 + offsetSecond) * (sign == '-' ? -1 : 1);
                break;
            }
            default: {
                InstantKt.parseIso$parseFailure(isoString, "Expected the UTC offset at position " + i2 + ", got '" + sign + '\'');
                throw new KotlinNothingValueException();
            }
        }
        int offsetSeconds = n;
        if (!(1 <= month ? month < 13 : false)) {
            InstantKt.parseIso$parseFailure(isoString, "Expected a month number in 1..12, got " + month);
            throw new KotlinNothingValueException();
        }
        if (!(1 <= day2 ? day2 <= InstantKt.monthLength(month, InstantKt.isLeapYear(year2)) : false)) {
            InstantKt.parseIso$parseFailure(isoString, "Expected a valid day-of-month for month " + month + " of year " + year2 + ", got " + day2);
            throw new KotlinNothingValueException();
        }
        if (hour2 > 23) {
            InstantKt.parseIso$parseFailure(isoString, "Expected hour in 0..23, got " + hour2);
            throw new KotlinNothingValueException();
        }
        if (minute2 > 59) {
            InstantKt.parseIso$parseFailure(isoString, "Expected minute-of-hour in 0..59, got " + minute2);
            throw new KotlinNothingValueException();
        }
        if (second2 > 59) {
            InstantKt.parseIso$parseFailure(isoString, "Expected second-of-minute in 0..59, got " + second2);
            throw new KotlinNothingValueException();
        }
        return new UnboundLocalDateTime(year2, month, day2, hour2, minute2, second2, nanosecond).toInstant(offsetSeconds);
    }

    @ExperimentalTime
    private static final String formatIso(Instant instant) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$formatIso_u24lambda_u248 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        UnboundLocalDateTime ldt = UnboundLocalDateTime.Companion.fromInstant(instant);
        StringBuilder $this$formatIso_u24lambda_u248_u24lambda_u247 = $this$formatIso_u24lambda_u248;
        boolean bl2 = false;
        int number = ldt.getYear();
        if (Math.abs(number) < 1000) {
            StringBuilder stringBuilder3;
            StringBuilder innerBuilder = new StringBuilder();
            if (number >= 0) {
                StringBuilder stringBuilder4 = innerBuilder.append(number + 10000).deleteCharAt(0);
                stringBuilder3 = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "deleteCharAt(...)");
            } else {
                StringBuilder stringBuilder5 = innerBuilder.append(number - 10000).deleteCharAt(1);
                stringBuilder3 = stringBuilder5;
                Intrinsics.checkNotNullExpressionValue(stringBuilder5, "deleteCharAt(...)");
            }
            stringBuilder = $this$formatIso_u24lambda_u248_u24lambda_u247.append((CharSequence)innerBuilder);
        } else {
            if (number >= 10000) {
                $this$formatIso_u24lambda_u248_u24lambda_u247.append('+');
            }
            stringBuilder = $this$formatIso_u24lambda_u248_u24lambda_u247.append(number);
        }
        $this$formatIso_u24lambda_u248.append('-');
        InstantKt.formatIso$lambda$8$appendTwoDigits($this$formatIso_u24lambda_u248, $this$formatIso_u24lambda_u248, ldt.getMonth());
        $this$formatIso_u24lambda_u248.append('-');
        InstantKt.formatIso$lambda$8$appendTwoDigits($this$formatIso_u24lambda_u248, $this$formatIso_u24lambda_u248, ldt.getDay());
        $this$formatIso_u24lambda_u248.append('T');
        InstantKt.formatIso$lambda$8$appendTwoDigits($this$formatIso_u24lambda_u248, $this$formatIso_u24lambda_u248, ldt.getHour());
        $this$formatIso_u24lambda_u248.append(':');
        InstantKt.formatIso$lambda$8$appendTwoDigits($this$formatIso_u24lambda_u248, $this$formatIso_u24lambda_u248, ldt.getMinute());
        $this$formatIso_u24lambda_u248.append(':');
        InstantKt.formatIso$lambda$8$appendTwoDigits($this$formatIso_u24lambda_u248, $this$formatIso_u24lambda_u248, ldt.getSecond());
        if (ldt.getNanosecond() != 0) {
            $this$formatIso_u24lambda_u248.append('.');
            int zerosToStrip = 0;
            while (ldt.getNanosecond() % POWERS_OF_TEN[zerosToStrip + 1] == 0) {
                ++zerosToStrip;
            }
            zerosToStrip -= zerosToStrip % 3;
            int numberToOutput = ldt.getNanosecond() / POWERS_OF_TEN[zerosToStrip];
            String string = String.valueOf(numberToOutput + POWERS_OF_TEN[9 - zerosToStrip]);
            int n = 1;
            Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            $this$formatIso_u24lambda_u248.append(string2);
        }
        $this$formatIso_u24lambda_u248.append('Z');
        return stringBuilder2.toString();
    }

    private static final long safeAddOrElse(long a, long b, Function0 action) {
        boolean $i$f$safeAddOrElse = false;
        long sum = a + b;
        if ((a ^ sum) < 0L && (a ^ b) >= 0L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return sum;
    }

    private static final long safeMultiplyOrElse(long a, long b, Function0 action) {
        boolean $i$f$safeMultiplyOrElse = false;
        if (b == 1L) {
            return a;
        }
        if (a == 1L) {
            return b;
        }
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long total = a * b;
        if (total / b != a || a == Long.MIN_VALUE && b == -1L || b == Long.MIN_VALUE && a == -1L) {
            action.invoke();
            throw new KotlinNothingValueException();
        }
        return total;
    }

    public static final boolean isLeapYear(int year2) {
        return (year2 & 3) == 0 && (year2 % 100 != 0 || year2 % 400 == 0);
    }

    private static final int monthLength(int $this$monthLength, boolean isLeapYear) {
        int n;
        switch ($this$monthLength) {
            case 2: {
                if (isLeapYear) {
                    n = 29;
                    break;
                }
                n = 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n = 30;
                break;
            }
            default: {
                n = 31;
            }
        }
        return n;
    }

    private static final String truncateForErrorMessage(CharSequence $this$truncateForErrorMessage, int maxLength) {
        return $this$truncateForErrorMessage.length() <= maxLength ? ((Object)$this$truncateForErrorMessage).toString() : ((Object)$this$truncateForErrorMessage.subSequence(0, maxLength)).toString() + "...";
    }

    private static final Void parseIso$parseFailure(CharSequence $isoString, String error) {
        throw new InstantFormatException(error + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage($isoString, 64) + '\"');
    }

    private static final void parseIso$expect(CharSequence $isoString, String what, int where, Function1<? super Character, Boolean> predicate) {
        char c = $isoString.charAt(where);
        if (!predicate.invoke(Character.valueOf(c)).booleanValue()) {
            InstantKt.parseIso$parseFailure($isoString, "Expected " + what + ", but got '" + c + "' at position " + where);
            throw new KotlinNothingValueException();
        }
    }

    private static final boolean parseIso$lambda$1(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$2(char it) {
        return it == '-';
    }

    private static final boolean parseIso$lambda$3(char it) {
        return it == 'T' || it == 't';
    }

    private static final boolean parseIso$lambda$4(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$5(char it) {
        return it == ':';
    }

    private static final boolean parseIso$lambda$6(char it) {
        return '0' <= it ? it < ':' : false;
    }

    private static final int parseIso$twoDigitNumber(CharSequence s2, int index) {
        return (s2.charAt(index) - 48) * 10 + (s2.charAt(index + 1) - 48);
    }

    private static final void formatIso$lambda$8$appendTwoDigits(Appendable $this$formatIso_u24lambda_u248_u24appendTwoDigits, StringBuilder $this_buildString, int number) {
        if (number < 10) {
            $this$formatIso_u24lambda_u248_u24appendTwoDigits.append('0');
        }
        $this_buildString.append(number);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ Instant access$parseIso(CharSequence isoString) {
        return InstantKt.parseIso(isoString);
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POWERS_OF_TEN = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8, 10, 11, 13, 14};
        asciiDigitPositionsInIsoStringAfterYear = nArray;
        nArray = new int[]{3, 6};
        colonsInIsoOffsetString = nArray;
        nArray = new int[]{1, 2, 4, 5, 7, 8};
        asciiDigitsInIsoOffsetString = nArray;
    }
}

