/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.internal;

import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.CallOptions;
import app.simplecloud.relocate.io.grpc.InternalMetadata;
import app.simplecloud.relocate.io.grpc.InternalStatus;
import app.simplecloud.relocate.io.grpc.Metadata;
import app.simplecloud.relocate.io.grpc.Status;
import app.simplecloud.relocate.io.grpc.internal.AbstractClientStream;
import app.simplecloud.relocate.io.grpc.internal.GrpcUtil;
import app.simplecloud.relocate.io.grpc.internal.ReadableBuffer;
import app.simplecloud.relocate.io.grpc.internal.ReadableBuffers;
import app.simplecloud.relocate.io.grpc.internal.StatsTraceContext;
import app.simplecloud.relocate.io.grpc.internal.TransportTracer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public abstract class Http2ClientStreamTransportState
extends AbstractClientStream.TransportState {
    private static final InternalMetadata.TrustedAsciiMarshaller<Integer> HTTP_STATUS_MARSHALLER = new InternalMetadata.TrustedAsciiMarshaller<Integer>(){

        @Override
        public byte[] toAsciiString(Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer parseAsciiString(byte[] serialized) {
            if (serialized.length >= 3) {
                return (serialized[0] - 48) * 100 + (serialized[1] - 48) * 10 + (serialized[2] - 48);
            }
            throw new NumberFormatException("Malformed status code " + new String(serialized, InternalMetadata.US_ASCII));
        }
    };
    private static final Metadata.Key<Integer> HTTP2_STATUS = InternalMetadata.keyOf(":status", HTTP_STATUS_MARSHALLER);
    private Status transportError;
    private Metadata transportErrorMetadata;
    private Charset errorCharset = StandardCharsets.UTF_8;
    private boolean headersReceived;

    protected Http2ClientStreamTransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, CallOptions options2) {
        super(maxMessageSize, statsTraceCtx, transportTracer, options2);
    }

    protected abstract void http2ProcessingFailed(Status var1, boolean var2, Metadata var3);

    protected void transportHeadersReceived(Metadata headers2) {
        Preconditions.checkNotNull(headers2, "headers");
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("headers: " + headers2);
            return;
        }
        try {
            if (this.headersReceived) {
                this.transportError = Status.INTERNAL.withDescription("Received headers twice");
                return;
            }
            Integer httpStatus = headers2.get(HTTP2_STATUS);
            if (httpStatus != null && httpStatus >= 100 && httpStatus < 200) {
                return;
            }
            this.headersReceived = true;
            this.transportError = this.validateInitialMetadata(headers2);
            if (this.transportError != null) {
                return;
            }
            Http2ClientStreamTransportState.stripTransportDetails(headers2);
            this.inboundHeadersReceived(headers2);
        }
        finally {
            if (this.transportError != null) {
                this.transportError = this.transportError.augmentDescription("headers: " + headers2);
                this.transportErrorMetadata = headers2;
                this.errorCharset = Http2ClientStreamTransportState.extractCharset(headers2);
            }
        }
    }

    protected void transportDataReceived(ReadableBuffer frame, boolean endOfStream) {
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("DATA-----------------------------\n" + ReadableBuffers.readAsString(frame, this.errorCharset));
            frame.close();
            if (this.transportError.getDescription().length() > 1000 || endOfStream) {
                this.http2ProcessingFailed(this.transportError, false, this.transportErrorMetadata);
            }
        } else {
            if (!this.headersReceived) {
                frame.close();
                this.http2ProcessingFailed(Status.INTERNAL.withDescription("headers not received before payload"), false, new Metadata());
                return;
            }
            int frameSize = frame.readableBytes();
            this.inboundDataReceived(frame);
            if (endOfStream) {
                this.transportError = frameSize > 0 ? Status.INTERNAL.withDescription("Received unexpected EOS on non-empty DATA frame from server") : Status.INTERNAL.withDescription("Received unexpected EOS on empty DATA frame from server");
                this.transportErrorMetadata = new Metadata();
                this.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
            }
        }
    }

    protected void transportTrailersReceived(Metadata trailers) {
        Preconditions.checkNotNull(trailers, "trailers");
        if (this.transportError == null && !this.headersReceived) {
            this.transportError = this.validateInitialMetadata(trailers);
            if (this.transportError != null) {
                this.transportErrorMetadata = trailers;
            }
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("trailers: " + trailers);
            this.http2ProcessingFailed(this.transportError, false, this.transportErrorMetadata);
        } else {
            Status status = this.statusFromTrailers(trailers);
            Http2ClientStreamTransportState.stripTransportDetails(trailers);
            this.inboundTrailersReceived(trailers, status);
        }
    }

    private Status statusFromTrailers(Metadata trailers) {
        Status status = trailers.get(InternalStatus.CODE_KEY);
        if (status != null) {
            return status.withDescription(trailers.get(InternalStatus.MESSAGE_KEY));
        }
        if (this.headersReceived) {
            return Status.UNKNOWN.withDescription("missing GRPC status in response");
        }
        Integer httpStatus = trailers.get(HTTP2_STATUS);
        status = httpStatus != null ? GrpcUtil.httpStatusToGrpcStatus(httpStatus) : Status.INTERNAL.withDescription("missing HTTP status code");
        return status.augmentDescription("missing GRPC status, inferred error from HTTP status code");
    }

    @Nullable
    private Status validateInitialMetadata(Metadata headers2) {
        Integer httpStatus = headers2.get(HTTP2_STATUS);
        if (httpStatus == null) {
            return Status.INTERNAL.withDescription("Missing HTTP status code");
        }
        String contentType = headers2.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (!GrpcUtil.isGrpcContentType(contentType)) {
            return GrpcUtil.httpStatusToGrpcStatus(httpStatus).augmentDescription("invalid content-type: " + contentType);
        }
        return null;
    }

    private static Charset extractCharset(Metadata headers2) {
        String contentType = headers2.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (contentType != null) {
            String[] split2 = contentType.split("charset=", 2);
            try {
                return Charset.forName(split2[split2.length - 1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StandardCharsets.UTF_8;
    }

    private static void stripTransportDetails(Metadata metadata) {
        metadata.discardAll(HTTP2_STATUS);
        metadata.discardAll(InternalStatus.CODE_KEY);
        metadata.discardAll(InternalStatus.MESSAGE_KEY);
    }
}

