/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty;

import app.simplecloud.relocate.google.common.annotations.VisibleForTesting;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.Attributes;
import app.simplecloud.relocate.io.grpc.ChannelLogger;
import app.simplecloud.relocate.io.grpc.Internal;
import app.simplecloud.relocate.io.grpc.InternalChannelz;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty.NettyAdaptiveCumulator;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http2.Http2Settings;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.Version;
import javax.annotation.Nullable;

@Internal
public abstract class GrpcHttp2ConnectionHandler
extends Http2ConnectionHandler {
    static final int ADAPTIVE_CUMULATOR_COMPOSE_MIN_SIZE_DEFAULT = 1024;
    static final ByteToMessageDecoder.Cumulator ADAPTIVE_CUMULATOR = new NettyAdaptiveCumulator(1024);
    @Nullable
    protected final ChannelPromise channelUnused;
    private final ChannelLogger negotiationLogger;
    private static final boolean usingPre4_1_111_Netty;

    protected GrpcHttp2ConnectionHandler(ChannelPromise channelUnused, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ChannelLogger negotiationLogger) {
        super(decoder, encoder, initialSettings);
        this.channelUnused = channelUnused;
        this.negotiationLogger = negotiationLogger;
        if (GrpcHttp2ConnectionHandler.usingPre4_1_111_Netty()) {
            this.setCumulator(ADAPTIVE_CUMULATOR);
        }
    }

    @VisibleForTesting
    static boolean usingPre4_1_111_Netty() {
        return usingPre4_1_111_Netty;
    }

    @Deprecated
    public void handleProtocolNegotiationCompleted(Attributes attrs) {
        this.handleProtocolNegotiationCompleted(attrs, null);
    }

    public void handleProtocolNegotiationCompleted(Attributes attrs, InternalChannelz.Security securityInfo) {
    }

    public ChannelLogger getNegotiationLogger() {
        Preconditions.checkState(this.negotiationLogger != null, "NegotiationLogger must not be null");
        return this.negotiationLogger;
    }

    public void notifyUnused() {
        this.channelUnused.setSuccess(null);
    }

    public Attributes getEagAttributes() {
        return Attributes.EMPTY;
    }

    public String getAuthority() {
        throw new UnsupportedOperationException();
    }

    static {
        boolean identifiedOldVersion = false;
        try {
            String[] split2;
            Version version = Version.identify().get("netty-buffer");
            if (version != null && (split2 = version.artifactVersion().split("\\.")).length >= 3 && Integer.parseInt(split2[0]) == 4 && Integer.parseInt(split2[1]) <= 1 && Integer.parseInt(split2[2]) < 111) {
                identifiedOldVersion = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        usingPre4_1_111_Netty = identifiedOldVersion;
    }
}

