/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEnvironmentBuilder;
import io.ktor.server.engine.CommandLineKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.CharsetKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u001aI\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a!\u0010\u000e\u001a\u00020\b*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a!\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00110\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u001f\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0017\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/ktor/server/engine/ApplicationEngine$Configuration;", "", "host", "sslPort", "sslKeyStorePath", "sslKeyStorePassword", "sslPrivateKeyPassword", "sslKeyAlias", "", "configureSSLConnectors", "(Lio/ktor/server/engine/ApplicationEngine$Configuration;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lio/ktor/server/engine/ApplicationEnvironmentBuilder;", "", "args", "configurePlatformProperties", "(Lio/ktor/server/engine/ApplicationEnvironmentBuilder;[Ljava/lang/String;)V", "", "Lkotlin/Pair;", "getKtorEnvironmentProperties", "()Ljava/util/List;", "key", "getEnvironmentProperty", "(Ljava/lang/String;)Ljava/lang/String;", "value", "setEnvironmentProperty", "(Ljava/lang/String;Ljava/lang/String;)V", "clearEnvironmentProperty", "(Ljava/lang/String;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nEnvironmentUtilsJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentUtilsJvm.kt\nio/ktor/server/engine/EnvironmentUtilsJvmKt\n+ 2 EngineConnectorConfigJvm.kt\nio/ktor/server/engine/EngineConnectorConfigJvmKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n20#2,2:98\n11483#3,9:100\n13409#3:109\n13410#3:111\n11492#3:112\n1#4:110\n1#4:113\n216#5,2:114\n*S KotlinDebug\n*F\n+ 1 EnvironmentUtilsJvm.kt\nio/ktor/server/engine/EnvironmentUtilsJvmKt\n*L\n51#1:98,2\n64#1:100,9\n64#1:109\n64#1:111\n64#1:112\n64#1:110\n77#1:114,2\n*E\n"})
public final class EnvironmentUtilsJvmKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void configureSSLConnectors(@NotNull ApplicationEngine.Configuration $this$configureSSLConnectors, @NotNull String host, @NotNull String sslPort, @Nullable String sslKeyStorePath, @Nullable String sslKeyStorePassword, @Nullable String sslPrivateKeyPassword, @NotNull String sslKeyAlias) {
        void $this$configureSSLConnectors_u24lambda_u246;
        void $this$sslConnector$iv;
        void keyStorePassword$iv;
        void keyStore$iv;
        Object object;
        Intrinsics.checkNotNullParameter($this$configureSSLConnectors, "<this>");
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(sslPort, "sslPort");
        Intrinsics.checkNotNullParameter(sslKeyAlias, "sslKeyAlias");
        if (sslKeyStorePath == null) {
            throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or ktor.security.ssl.keyStore config");
        }
        if (sslKeyStorePassword == null) {
            throw new IllegalArgumentException("SSL requires keystore password: use ktor.security.ssl.keyStorePassword config");
        }
        if (sslPrivateKeyPassword == null) {
            throw new IllegalArgumentException("SSL requires certificate password: use ktor.security.ssl.privateKeyPassword config");
        }
        Object file2 = new File(sslKeyStorePath);
        boolean bl = false;
        File keyStoreFile = ((File)file2).exists() || ((File)file2).isAbsolute() ? file2 : new File(".", sslKeyStorePath).getAbsoluteFile();
        Object $this$configureSSLConnectors_u24lambda_u243 = file2 = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = false;
        Closeable closeable = new FileInputStream(keyStoreFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl2 = false;
            ((KeyStore)$this$configureSSLConnectors_u24lambda_u243).load(it, CharsetKt.toCharArray(sslKeyStorePassword));
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        if (((KeyStore)$this$configureSSLConnectors_u24lambda_u243).getKey(sslKeyAlias, CharsetKt.toCharArray(sslPrivateKeyPassword)) == null) {
            boolean $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = false;
            String $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
            throw new IllegalArgumentException($i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32.toString());
        }
        Object keyStore = file2;
        file2 = $this$configureSSLConnectors;
        Intrinsics.checkNotNull(keyStore);
        $this$configureSSLConnectors_u24lambda_u243 = keyStore;
        Function0<char[]> $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = () -> EnvironmentUtilsJvmKt.configureSSLConnectors$lambda$4(sslKeyStorePassword);
        Function0<char[]> privateKeyPassword$iv = () -> EnvironmentUtilsJvmKt.configureSSLConnectors$lambda$5(sslPrivateKeyPassword);
        boolean $i$f$sslConnector = false;
        Object bl2 = object = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, privateKeyPassword$iv);
        List<EngineConnectorConfig> list = $this$sslConnector$iv.getConnectors();
        boolean bl3 = false;
        $this$configureSSLConnectors_u24lambda_u246.setHost(host);
        $this$configureSSLConnectors_u24lambda_u246.setPort(Integer.parseInt(sslPort));
        $this$configureSSLConnectors_u24lambda_u246.setKeyStorePath(keyStoreFile);
        list.add((EngineConnectorConfig)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configurePlatformProperties(@NotNull ApplicationEnvironmentBuilder $this$configurePlatformProperties, @NotNull String[] args) {
        ClassLoader classLoader;
        URL uRL;
        String it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$configurePlatformProperties, "<this>");
        Intrinsics.checkNotNullParameter(args, "args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it2 = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it2, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argumentsPairs = MapsKt.toMap((List)destination$iv$iv);
        String string = (String)argumentsPairs.get("-jar");
        if (string != null) {
            it = string;
            boolean bl = false;
            uRL = StringsKt.startsWith$default(it, "file:", false, 2, null) || StringsKt.startsWith$default(it, "jrt:", false, 2, null) || StringsKt.startsWith$default(it, "jar:", false, 2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
        } else {
            uRL = null;
        }
        URL jar = uRL;
        ApplicationEnvironmentBuilder applicationEnvironmentBuilder = $this$configurePlatformProperties;
        URL uRL2 = jar;
        if (uRL2 != null) {
            it = uRL2;
            ApplicationEnvironmentBuilder applicationEnvironmentBuilder2 = applicationEnvironmentBuilder;
            boolean bl = false;
            URL[] uRLArray = new URL[]{jar};
            applicationEnvironmentBuilder = applicationEnvironmentBuilder2;
            classLoader = new URLClassLoader(uRLArray, ApplicationEnvironment.class.getClassLoader());
        } else {
            ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue(classLoader2, "getClassLoader(...)");
        }
        applicationEnvironmentBuilder.setClassLoader(classLoader);
    }

    @NotNull
    public static final List<Pair<String, String>> getKtorEnvironmentProperties() {
        List<Pair<String, String>> list;
        List<Pair<String, String>> $this$getKtorEnvironmentProperties_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue(properties, "getProperties(...)");
        Map $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String value;
            Object v;
            String key2;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl2 = false;
            Object k = it.getKey();
            String string = k instanceof String ? (String)k : null;
            if (string == null || !StringsKt.startsWith$default(key2 = string, "ktor.", false, 2, null) || ((v = it.getValue()) instanceof String ? (String)v : null) == null) continue;
            value = value;
            $this$getKtorEnvironmentProperties_u24lambda_u2411.add(TuplesKt.to(key2, value));
        }
        return CollectionsKt.build(list);
    }

    @Nullable
    public static final String getEnvironmentProperty(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return System.getProperty(key2);
    }

    public static final void setEnvironmentProperty(@NotNull String key2, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        System.setProperty(key2, value);
    }

    public static final void clearEnvironmentProperty(@NotNull String key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        System.clearProperty(key2);
    }

    private static final char[] configureSSLConnectors$lambda$4(String $sslKeyStorePassword) {
        return CharsetKt.toCharArray($sslKeyStorePassword);
    }

    private static final char[] configureSSLConnectors$lambda$5(String $sslPrivateKeyPassword) {
        return CharsetKt.toCharArray($sslPrivateKeyPassword);
    }
}

