/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EnumLookup {
    private static final Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> ENUM_FIELD_CACHE = new WeakHashMap();

    private EnumLookup() {
    }

    private static String processKey(String key2) {
        return "\ud83c\udf38" + key2.toLowerCase(Locale.ROOT).replace("_", "");
    }

    public static <T extends Enum<T>> @Nullable T lookupEnum(Class<T> clazz, String key2) {
        Map vals = ENUM_FIELD_CACHE.computeIfAbsent(Objects.requireNonNull(clazz), c2 -> {
            HashMap<String, Enum> ret2 = new HashMap<String, Enum>();
            for (Enum field : (Enum[])c2.getEnumConstants()) {
                ret2.put(field.name(), field);
                ret2.putIfAbsent(EnumLookup.processKey(field.name()), field);
            }
            return Collections.unmodifiableMap(ret2);
        });
        Enum possibleRet = (Enum)vals.get(Objects.requireNonNull(key2, "key"));
        if (possibleRet != null) {
            return (T)possibleRet;
        }
        return (T)((Enum)vals.get(EnumLookup.processKey(key2)));
    }
}

