/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.droplet.api.time;

import app.simplecloud.relocate.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lapp/simplecloud/droplet/api/time/ProtobufTimestamp;", "", "<init>", "()V", "toLocalDateTime", "Ljava/time/LocalDateTime;", "timestamp", "Lapp/simplecloud/relocate/google/protobuf/Timestamp;", "fromLocalDateTime", "localDateTime", "droplet-api"})
public final class ProtobufTimestamp {
    @NotNull
    public static final ProtobufTimestamp INSTANCE = new ProtobufTimestamp();

    private ProtobufTimestamp() {
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Timestamp timestamp) {
        Intrinsics.checkNotNullParameter(timestamp, "timestamp");
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue(localDateTime, "ofInstant(...)");
        return localDateTime;
    }

    @NotNull
    public final Timestamp fromLocalDateTime(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter(localDateTime, "localDateTime");
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        Intrinsics.checkNotNullExpressionValue(timestamp, "build(...)");
        return timestamp;
    }
}

