/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc;

import app.simplecloud.relocate.google.common.base.MoreObjects;
import app.simplecloud.relocate.google.common.base.Objects;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.ExperimentalApi;
import app.simplecloud.relocate.io.grpc.Status;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11563")
public class StatusOr<T> {
    private final Status status;
    private final T value;

    private StatusOr(Status status, T value) {
        this.status = status;
        this.value = value;
    }

    public static <T> StatusOr<T> fromValue(@Nullable T value) {
        StatusOr<T> result2 = new StatusOr<T>(null, value);
        return result2;
    }

    public static <T> StatusOr<T> fromStatus(Status status) {
        StatusOr<Object> result2 = new StatusOr<Object>(Preconditions.checkNotNull(status, "status"), null);
        Preconditions.checkArgument(!status.isOk(), "cannot use OK status: %s", (Object)status);
        return result2;
    }

    public boolean hasValue() {
        return this.status == null;
    }

    @Nullable
    public T getValue() {
        if (this.status != null) {
            throw new IllegalStateException("No value present.");
        }
        return this.value;
    }

    public Status getStatus() {
        return this.status == null ? Status.OK : this.status;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StatusOr)) {
            return false;
        }
        StatusOr otherStatus = (StatusOr)other;
        if (this.hasValue() != otherStatus.hasValue()) {
            return false;
        }
        if (this.hasValue()) {
            return Objects.equal(this.value, otherStatus.value);
        }
        return Objects.equal(this.status, otherStatus.status);
    }

    public int hashCode() {
        return Objects.hashCode(this.status, this.value);
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this);
        if (this.status == null) {
            stringHelper.add("value", this.value);
        } else {
            stringHelper.add("error", this.status);
        }
        return stringHelper.toString();
    }
}

