/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.KtorReadTimeoutHandler;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002;:B\u008c\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u0012\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00182\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010)\u001a\u00020\u001c*\u00020(H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u0004\u0018\u00010+*\u00020(H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010.R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010/R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00100R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00101R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00102R\u0014\u0010\u000e\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00102R\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u00103R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00104R\u0014\u0010\u0013\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00104R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00104R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010.R%\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\u0002\b\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u00105R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u00106R\u0018\u00108\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006<"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "Lkotlin/Function0;", "Lio/ktor/server/application/Application;", "applicationProvider", "Lio/ktor/server/engine/EnginePipeline;", "enginePipeline", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/netty/util/concurrent/EventExecutorGroup;", "callEventGroup", "Lkotlin/coroutines/CoroutineContext;", "engineContext", "userContext", "Lio/ktor/server/engine/EngineConnectorConfig;", "connector", "", "runningLimit", "responseWriteTimeout", "requestReadTimeout", "Lio/netty/handler/codec/http/HttpServerCodec;", "httpServerCodec", "Lkotlin/Function1;", "Lio/netty/channel/ChannelPipeline;", "", "Lkotlin/ExtensionFunctionType;", "channelPipelineConfig", "", "enableHttp2", "<init>", "(Lkotlin/jvm/functions/Function0;Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/application/ApplicationEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V", "ch", "initChannel", "(Lio/netty/channel/socket/SocketChannel;)V", "pipeline", "", "protocol", "configurePipeline", "(Lio/netty/channel/ChannelPipeline;Ljava/lang/String;)V", "Lio/ktor/server/engine/EngineSSLConnectorConfig;", "hasTrustStore", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Z", "Ljavax/net/ssl/TrustManagerFactory;", "trustManagerFactory", "(Lio/ktor/server/engine/EngineSSLConnectorConfig;)Ljavax/net/ssl/TrustManagerFactory;", "Lkotlin/jvm/functions/Function0;", "Lio/ktor/server/engine/EnginePipeline;", "Lio/ktor/server/application/ApplicationEnvironment;", "Lio/netty/util/concurrent/EventExecutorGroup;", "Lkotlin/coroutines/CoroutineContext;", "Lio/ktor/server/engine/EngineConnectorConfig;", "I", "Lkotlin/jvm/functions/Function1;", "Z", "Lio/netty/handler/ssl/SslContext;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyChannelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n37#2,2:220\n37#2,2:223\n1#3:222\n*S KotlinDebug\n*F\n+ 1 NettyChannelInitializer.kt\nio/ktor/server/netty/NettyChannelInitializer\n*L\n56#1:220,2\n91#1:223,2\n*E\n"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Application> applicationProvider;
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final EngineConnectorConfig connector;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final int requestReadTimeout;
    @NotNull
    private final Function0<HttpServerCodec> httpServerCodec;
    @NotNull
    private final Function1<ChannelPipeline, Unit> channelPipelineConfig;
    private final boolean enableHttp2;
    @Nullable
    private SslContext sslContext;
    @NotNull
    private static final Lazy<SslProvider> alpnProvider$delegate = LazyKt.lazy(NettyChannelInitializer::alpnProvider_delegate$lambda$12);

    /*
     * WARNING - void declaration
     */
    public NettyChannelInitializer(@NotNull Function0<Application> applicationProvider, @NotNull EnginePipeline enginePipeline, @NotNull ApplicationEnvironment environment, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull EngineConnectorConfig connector, int runningLimit, int responseWriteTimeout, int requestReadTimeout, @NotNull Function0<HttpServerCodec> httpServerCodec2, @NotNull Function1<? super ChannelPipeline, Unit> channelPipelineConfig, boolean enableHttp2) {
        Intrinsics.checkNotNullParameter(applicationProvider, "applicationProvider");
        Intrinsics.checkNotNullParameter(enginePipeline, "enginePipeline");
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(callEventGroup, "callEventGroup");
        Intrinsics.checkNotNullParameter(engineContext, "engineContext");
        Intrinsics.checkNotNullParameter(userContext, "userContext");
        Intrinsics.checkNotNullParameter(connector, "connector");
        Intrinsics.checkNotNullParameter(httpServerCodec2, "httpServerCodec");
        Intrinsics.checkNotNullParameter(channelPipelineConfig, "channelPipelineConfig");
        this.applicationProvider = applicationProvider;
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.connector = connector;
        this.runningLimit = runningLimit;
        this.responseWriteTimeout = responseWriteTimeout;
        this.requestReadTimeout = requestReadTimeout;
        this.httpServerCodec = httpServerCodec2;
        this.channelPipelineConfig = channelPipelineConfig;
        this.enableHttp2 = enableHttp2;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            void $this$_init__u24lambda_u241;
            SslContextBuilder sslContextBuilder;
            Certificate[] certificateArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkNotNullExpressionValue(certificateArray, "getCertificateChain(...)");
            List<Object> list = ArraysKt.toList((Object[])certificateArray);
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.List<java.security.cert.X509Certificate>");
            List<Object> chain1 = list;
            Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)chain1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            X509Certificate[] certs = thisCollection$iv.toArray(new X509Certificate[0]);
            char[] password = ((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key2 = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), password);
            Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type java.security.PrivateKey");
            PrivateKey pk = (PrivateKey)key2;
            ArraysKt.fill$default(password, '\u0000', 0, 0, 6, null);
            SslContextBuilder sslContextBuilder2 = sslContextBuilder = SslContextBuilder.forServer(pk, Arrays.copyOf(certs, certs.length));
            NettyChannelInitializer nettyChannelInitializer = this;
            boolean bl = false;
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                $this$_init__u24lambda_u241.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                $this$_init__u24lambda_u241.ciphers((Iterable<String>)Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE);
                String[] stringArray = new String[]{"h2", "http/1.1"};
                $this$_init__u24lambda_u241.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, stringArray));
            }
            TrustManagerFactory trustManagerFactory = this.trustManagerFactory((EngineSSLConnectorConfig)this.connector);
            if (trustManagerFactory != null) {
                TrustManagerFactory it = trustManagerFactory;
                boolean bl2 = false;
                $this$_init__u24lambda_u241.trustManager(it);
            }
            nettyChannelInitializer.sslContext = sslContextBuilder.build();
        }
    }

    @Override
    protected void initChannel(@NotNull SocketChannel ch) {
        Intrinsics.checkNotNullParameter(ch, "ch");
        ChannelPipeline $this$initChannel_u24lambda_u244 = ch.pipeline();
        boolean bl = false;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            ChannelHandler[] channelHandlerArray;
            SslContext sslContext = this.sslContext;
            Intrinsics.checkNotNull(sslContext);
            ChannelHandler[] $this$initChannel_u24lambda_u244_u24lambda_u243 = channelHandlerArray = sslContext.newEngine(ch.alloc());
            boolean bl2 = false;
            if (this.hasTrustStore((EngineSSLConnectorConfig)this.connector)) {
                $this$initChannel_u24lambda_u244_u24lambda_u243.setUseClientMode(false);
                $this$initChannel_u24lambda_u244_u24lambda_u243.setNeedClientAuth(true);
            }
            List<String> list = ((EngineSSLConnectorConfig)this.connector).getEnabledProtocols();
            if (list != null) {
                List<String> it = list;
                boolean bl3 = false;
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$initChannel_u24lambda_u244_u24lambda_u243.setEnabledProtocols(thisCollection$iv.toArray(new String[0]));
            }
            ChannelHandler[] sslEngine = channelHandlerArray;
            $this$initChannel_u24lambda_u244.addLast("ssl", (ChannelHandler)new SslHandler((SSLEngine)sslEngine));
            if (this.enableHttp2 && Companion.getAlpnProvider$ktor_server_netty() != null) {
                channelHandlerArray = new ChannelHandler[]{new NegotiatedPipelineInitializer()};
                $this$initChannel_u24lambda_u244.addLast(channelHandlerArray);
            } else {
                Intrinsics.checkNotNull($this$initChannel_u24lambda_u244);
                this.configurePipeline($this$initChannel_u24lambda_u244, "http/1.1");
            }
        } else {
            Intrinsics.checkNotNull($this$initChannel_u24lambda_u244);
            this.configurePipeline($this$initChannel_u24lambda_u244, "http/1.1");
        }
    }

    private final void configurePipeline(ChannelPipeline pipeline, String protocol) {
        Object object;
        String string = protocol;
        if (Intrinsics.areEqual(string, "h2")) {
            NettyHttp2Handler handler = new NettyHttp2Handler(this.enginePipeline, this.applicationProvider.invoke(), this.callEventGroup, this.userContext, this.runningLimit);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{Http2MultiplexCodecBuilder.forServer(handler).build()};
            pipeline.addLast(channelHandlerArray);
            pipeline.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)arg_0 -> NettyChannelInitializer.configurePipeline$lambda$5(handler, arg_0)));
            this.channelPipelineConfig.invoke(pipeline);
            object = Unit.INSTANCE;
        } else if (Intrinsics.areEqual(string, "http/1.1")) {
            NettyHttp1Handler handler = new NettyHttp1Handler(this.applicationProvider, this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, this.runningLimit);
            ChannelPipeline $this$configurePipeline_u24lambda_u246 = pipeline;
            boolean bl = false;
            if (this.requestReadTimeout > 0) {
                $this$configurePipeline_u24lambda_u246.addLast("readTimeout", (ChannelHandler)new KtorReadTimeoutHandler(this.requestReadTimeout));
            }
            $this$configurePipeline_u24lambda_u246.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            $this$configurePipeline_u24lambda_u246.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            $this$configurePipeline_u24lambda_u246.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            $this$configurePipeline_u24lambda_u246.addLast("http1", (ChannelHandler)handler);
            this.channelPipelineConfig.invoke($this$configurePipeline_u24lambda_u246);
            object = pipeline.context("codec").fireChannelActive();
        } else {
            this.environment.getLog().error("Unsupported protocol " + protocol);
            object = pipeline.close();
        }
    }

    private final boolean hasTrustStore(EngineSSLConnectorConfig $this$hasTrustStore) {
        return $this$hasTrustStore.getTrustStore() != null || $this$hasTrustStore.getTrustStorePath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrustManagerFactory trustManagerFactory(EngineSSLConnectorConfig $this$trustManagerFactory) {
        TrustManagerFactory trustManagerFactory;
        KeyStore trustStore;
        KeyStore keyStore = $this$trustManagerFactory.getTrustStore();
        if (keyStore == null) {
            File file2 = $this$trustManagerFactory.getTrustStorePath();
            if (file2 != null) {
                File file3 = file2;
                boolean bl = false;
                Closeable closeable = new FileInputStream(file3);
                Throwable throwable = null;
                try {
                    KeyStore keyStore2;
                    FileInputStream fis = (FileInputStream)closeable;
                    boolean bl2 = false;
                    KeyStore it = keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                    boolean bl3 = false;
                    it.load(fis, null);
                    KeyStore keyStore3 = keyStore2;
                    keyStore = keyStore3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            } else {
                keyStore = null;
            }
        }
        KeyStore keyStore4 = trustStore = keyStore;
        if (keyStore4 != null) {
            TrustManagerFactory trustManagerFactory2;
            KeyStore store2 = keyStore4;
            boolean bl = false;
            TrustManagerFactory it = trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            boolean bl4 = false;
            it.init(store2);
            trustManagerFactory = trustManagerFactory2;
        } else {
            trustManagerFactory = null;
        }
        return trustManagerFactory;
    }

    private static final void configurePipeline$lambda$5(NettyHttp2Handler $handler, Future it) {
        CoroutineScopeKt.cancel$default($handler, null, 1, null);
    }

    private static final SslProvider alpnProvider_delegate$lambda$12() {
        return NettyChannelInitializer.Companion.findAlpnProvider();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\n\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "<init>", "()V", "Lio/netty/handler/ssl/SslProvider;", "findAlpnProvider", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "getAlpnProvider$ktor_server_netty", "alpnProvider", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            return (SslProvider)((Object)lazy.getValue());
        }

        private final SslProvider findAlpnProvider() {
            try {
                if (SslProvider.isAlpnSupported(SslProvider.OPENSSL)) {
                    return SslProvider.OPENSSL;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (SslProvider.isAlpnSupported(SslProvider.JDK)) {
                    return SslProvider.JDK;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "<init>", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "Lio/netty/channel/ChannelHandlerContext;", "ctx", "", "protocol", "", "configurePipeline", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/String;)V", "", "cause", "handshakeFailure", "(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        public NegotiatedPipelineInitializer() {
            super("http/1.1");
        }

        @Override
        protected void configurePipeline(@NotNull ChannelHandlerContext ctx, @NotNull String protocol) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            Intrinsics.checkNotNullParameter(protocol, "protocol");
            ChannelPipeline channelPipeline = ctx.pipeline();
            Intrinsics.checkNotNullExpressionValue(channelPipeline, "pipeline(...)");
            NettyChannelInitializer.this.configurePipeline(channelPipeline, protocol);
        }

        @Override
        protected void handshakeFailure(@NotNull ChannelHandlerContext ctx, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            if (cause instanceof ClosedChannelException) {
                ctx.close();
            } else {
                super.handshakeFailure(ctx, cause);
            }
        }
    }
}

