/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.internal.tcnative;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.internal.tcnative.ResultCallback;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.internal.tcnative.SSLPrivateKeyMethod;

final class AsyncSSLPrivateKeyMethodAdapter
implements AsyncSSLPrivateKeyMethod {
    private final SSLPrivateKeyMethod method;

    AsyncSSLPrivateKeyMethodAdapter(SSLPrivateKeyMethod method) {
        if (method == null) {
            throw new NullPointerException("method");
        }
        this.method = method;
    }

    @Override
    public void sign(long ssl, int signatureAlgorithm, byte[] input2, ResultCallback<byte[]> resultCallback) {
        byte[] result2;
        try {
            result2 = this.method.sign(ssl, signatureAlgorithm, input2);
        }
        catch (Throwable cause) {
            resultCallback.onError(ssl, cause);
            return;
        }
        resultCallback.onSuccess(ssl, result2);
    }

    @Override
    public void decrypt(long ssl, byte[] input2, ResultCallback<byte[]> resultCallback) {
        byte[] result2;
        try {
            result2 = this.method.decrypt(ssl, input2);
        }
        catch (Throwable cause) {
            resultCallback.onError(ssl, cause);
            return;
        }
        resultCallback.onSuccess(ssl, result2);
    }
}

