/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.NetworkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.Util;
import com.auth0.jwk.VisibleForTesting;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UrlJwkProvider
implements JwkProvider {
    @VisibleForTesting
    static final String WELL_KNOWN_JWKS_PATH = "/.well-known/jwks.json";
    final URL url;
    final Proxy proxy;
    final Map<String, String> headers;
    final Integer connectTimeout;
    final Integer readTimeout;
    private final ObjectReader reader;

    public UrlJwkProvider(URL url2) {
        this(url2, null, null, null, null);
    }

    public UrlJwkProvider(URL url2, Integer connectTimeout, Integer readTimeout, Proxy proxy) {
        this(url2, connectTimeout, readTimeout, proxy, null);
    }

    public UrlJwkProvider(URL url2, Integer connectTimeout, Integer readTimeout, Proxy proxy, Map<String, String> headers2) {
        Util.checkArgument(url2 != null, "A non-null url is required");
        Util.checkArgument(connectTimeout == null || connectTimeout >= 0, "Invalid connect timeout value '" + connectTimeout + "'. Must be a non-negative integer.");
        Util.checkArgument(readTimeout == null || readTimeout >= 0, "Invalid read timeout value '" + readTimeout + "'. Must be a non-negative integer.");
        this.url = url2;
        this.proxy = proxy;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.reader = new ObjectMapper().readerFor(Map.class);
        this.headers = headers2 == null ? Collections.singletonMap("Accept", "application/json") : headers2;
    }

    public UrlJwkProvider(URL url2, Integer connectTimeout, Integer readTimeout) {
        this(url2, connectTimeout, readTimeout, null, null);
    }

    public UrlJwkProvider(String domain) {
        this(UrlJwkProvider.urlForDomain(domain));
    }

    static URL urlForDomain(String domain) {
        Util.checkArgument(!Util.isNullOrEmpty(domain), "A domain is required");
        if (!domain.startsWith("http")) {
            domain = "https://" + domain;
        }
        try {
            URI uri = new URI(domain + WELL_KNOWN_JWKS_PATH).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid jwks uri", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getJwks() throws SigningKeyNotFoundException {
        try {
            URLConnection c;
            URLConnection uRLConnection = c = this.proxy == null ? this.url.openConnection() : this.url.openConnection(this.proxy);
            if (this.connectTimeout != null) {
                c.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                c.setReadTimeout(this.readTimeout);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                c.setRequestProperty(entry.getKey(), entry.getValue());
            }
            try (InputStream inputStream2 = c.getInputStream();){
                Map map2 = (Map)this.reader.readValue(inputStream2);
                return map2;
            }
        }
        catch (IOException e) {
            throw new NetworkException("Cannot obtain jwks from url " + this.url.toString(), e);
        }
    }

    public List<Jwk> getAll() throws SigningKeyNotFoundException {
        ArrayList<Jwk> jwks = new ArrayList<Jwk>();
        List keys2 = (List)this.getJwks().get("keys");
        if (keys2 == null || keys2.isEmpty()) {
            throw new SigningKeyNotFoundException("No keys found in " + this.url.toString(), null);
        }
        try {
            for (Map values2 : keys2) {
                jwks.add(Jwk.fromValues(values2));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SigningKeyNotFoundException("Failed to parse jwk from json", e);
        }
        return jwks;
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        List<Jwk> jwks = this.getAll();
        if (keyId == null && jwks.size() == 1) {
            return jwks.get(0);
        }
        if (keyId != null) {
            for (Jwk jwk : jwks) {
                if (!keyId.equals(jwk.getId())) continue;
                return jwk;
            }
        }
        throw new SigningKeyNotFoundException("No key found in " + this.url.toString() + " with kid " + keyId, null);
    }
}

