/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.collect.CollectPreconditions;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.ImmutableBiMap;
import app.simplecloud.relocate.google.common.collect.ImmutableSet;
import app.simplecloud.relocate.google.common.collect.Maps;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    @CheckForNull
    private final transient ImmutableBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableBiMap<V, K> lazyInverse;

    SingletonImmutableBiMap(K singleKey, V singleValue) {
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = null;
    }

    private SingletonImmutableBiMap(K singleKey, V singleValue, ImmutableBiMap<V, K> inverse) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = inverse;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key2) {
        return this.singleKey.equals(key2) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(@CheckForNull Object key2) {
        return this.singleKey.equals(key2);
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> result2 = this.lazyInverse;
        if (result2 == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return result2;
    }
}

