/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.util.concurrent;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.annotations.J2ktIncompatible;
import app.simplecloud.relocate.google.common.base.Function;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.util.concurrent.AbstractFuture;
import app.simplecloud.relocate.google.common.util.concurrent.AsyncFunction;
import app.simplecloud.relocate.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.util.concurrent.ForwardingFluentFuture;
import app.simplecloud.relocate.google.common.util.concurrent.FutureCallback;
import app.simplecloud.relocate.google.common.util.concurrent.Futures;
import app.simplecloud.relocate.google.common.util.concurrent.GwtFluentFutureCatchingSpecialization;
import app.simplecloud.relocate.google.common.util.concurrent.Internal;
import app.simplecloud.relocate.google.common.util.concurrent.ListenableFuture;
import app.simplecloud.relocate.google.common.util.concurrent.ParametricNullness;
import app.simplecloud.relocate.google.common.util.concurrent.Partially;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotMock;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@DoNotMock(value="Use FluentFuture.from(Futures.immediate*Future) or SettableFuture")
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class FluentFuture<V>
extends GwtFluentFutureCatchingSpecialization<V> {
    FluentFuture() {
    }

    public static <V> FluentFuture<V> from(ListenableFuture<V> future) {
        return future instanceof FluentFuture ? (FluentFuture<V>)future : new ForwardingFluentFuture<V>(future);
    }

    @Deprecated
    public static <V> FluentFuture<V> from(FluentFuture<V> future) {
        return Preconditions.checkNotNull(future);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catching(Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor2) {
        return (FluentFuture)Futures.catching(this, exceptionType, fallback, executor2);
    }

    @J2ktIncompatible
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catchingAsync(Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor2) {
        return (FluentFuture)Futures.catchingAsync(this, exceptionType, fallback, executor2);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public final FluentFuture<V> withTimeout(Duration timeout2, ScheduledExecutorService scheduledExecutor) {
        return this.withTimeout(Internal.toNanosSaturated(timeout2), TimeUnit.NANOSECONDS, scheduledExecutor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public final FluentFuture<V> withTimeout(long timeout2, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        return (FluentFuture)Futures.withTimeout(this, timeout2, unit, scheduledExecutor);
    }

    public final <T> FluentFuture<T> transformAsync(AsyncFunction<? super V, T> function, Executor executor2) {
        return (FluentFuture)Futures.transformAsync(this, function, executor2);
    }

    public final <T> FluentFuture<T> transform(Function<? super V, T> function, Executor executor2) {
        return (FluentFuture)Futures.transform(this, function, executor2);
    }

    public final void addCallback(FutureCallback<? super V> callback, Executor executor2) {
        Futures.addCallback(this, callback, executor2);
    }

    static abstract class TrustedFuture<V>
    extends FluentFuture<V>
    implements AbstractFuture.Trusted<V> {
        TrustedFuture() {
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public final V get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(timeout2, unit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable listener, Executor executor2) {
            super.addListener(listener, executor2);
        }

        @Override
        @CanIgnoreReturnValue
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

