/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.protobuf;

import app.simplecloud.relocate.google.protobuf.ByteString;
import app.simplecloud.relocate.google.protobuf.CheckReturnValue;
import app.simplecloud.relocate.google.protobuf.CodedInputStream;
import app.simplecloud.relocate.google.protobuf.ExtensionRegistryLite;
import app.simplecloud.relocate.google.protobuf.ExtensionSchema;
import app.simplecloud.relocate.google.protobuf.FieldSet;
import app.simplecloud.relocate.google.protobuf.GeneratedMessageLite;
import app.simplecloud.relocate.google.protobuf.Internal;
import app.simplecloud.relocate.google.protobuf.MessageLite;
import app.simplecloud.relocate.google.protobuf.Protobuf;
import app.simplecloud.relocate.google.protobuf.Reader;
import app.simplecloud.relocate.google.protobuf.Schema;
import app.simplecloud.relocate.google.protobuf.SchemaUtil;
import app.simplecloud.relocate.google.protobuf.UnknownFieldSchema;
import app.simplecloud.relocate.google.protobuf.WireFormat;
import app.simplecloud.relocate.google.protobuf.Writer;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class ExtensionSchemaLite
extends ExtensionSchema<GeneratedMessageLite.ExtensionDescriptor> {
    ExtensionSchemaLite() {
    }

    @Override
    boolean hasExtensions(MessageLite prototype) {
        return prototype instanceof GeneratedMessageLite.ExtendableMessage;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getExtensions(Object message) {
        return ((GeneratedMessageLite.ExtendableMessage)message).extensions;
    }

    @Override
    void setExtensions(Object message, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) {
        ((GeneratedMessageLite.ExtendableMessage)message).extensions = extensions;
    }

    @Override
    FieldSet<GeneratedMessageLite.ExtensionDescriptor> getMutableExtensions(Object message) {
        return ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
    }

    @Override
    void makeImmutable(Object message) {
        this.getExtensions(message).makeImmutable();
    }

    @Override
    <UT, UB> UB parseExtension(Object containerMessage, Reader reader2, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        int fieldNumber = extension.getNumber();
        if (extension.descriptor.isRepeated() && extension.descriptor.isPacked()) {
            ArrayList<Constable> value = null;
            switch (extension.getLiteType()) {
                case DOUBLE: {
                    ArrayList<Double> list = new ArrayList<Double>();
                    reader2.readDoubleList(list);
                    value = list;
                    break;
                }
                case FLOAT: {
                    ArrayList<Float> list = new ArrayList<Float>();
                    reader2.readFloatList(list);
                    value = list;
                    break;
                }
                case INT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader2.readInt64List(list);
                    value = list;
                    break;
                }
                case UINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader2.readUInt64List(list);
                    value = list;
                    break;
                }
                case INT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readInt32List(list);
                    value = list;
                    break;
                }
                case FIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader2.readFixed64List(list);
                    value = list;
                    break;
                }
                case FIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readFixed32List(list);
                    value = list;
                    break;
                }
                case BOOL: {
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    reader2.readBoolList(list);
                    value = list;
                    break;
                }
                case UINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readUInt32List(list);
                    value = list;
                    break;
                }
                case SFIXED32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readSFixed32List(list);
                    value = list;
                    break;
                }
                case SFIXED64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader2.readSFixed64List(list);
                    value = list;
                    break;
                }
                case SINT32: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readSInt32List(list);
                    value = list;
                    break;
                }
                case SINT64: {
                    ArrayList<Long> list = new ArrayList<Long>();
                    reader2.readSInt64List(list);
                    value = list;
                    break;
                }
                case ENUM: {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    reader2.readEnumList(list);
                    unknownFields = SchemaUtil.filterUnknownEnumList(containerMessage, fieldNumber, list, extension.descriptor.getEnumType(), unknownFields, unknownFieldSchema);
                    value = list;
                    break;
                }
                default: {
                    throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                }
            }
            extensions.setField(extension.descriptor, value);
        } else {
            Object value = null;
            if (extension.getLiteType() == WireFormat.FieldType.ENUM) {
                int number = reader2.readInt32();
                Object enumValue = extension.descriptor.getEnumType().findValueByNumber(number);
                if (enumValue == null) {
                    return SchemaUtil.storeUnknownEnum(containerMessage, fieldNumber, number, unknownFields, unknownFieldSchema);
                }
                value = number;
            } else {
                switch (extension.getLiteType()) {
                    case DOUBLE: {
                        value = reader2.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(reader2.readFloat());
                        break;
                    }
                    case INT64: {
                        value = reader2.readInt64();
                        break;
                    }
                    case UINT64: {
                        value = reader2.readUInt64();
                        break;
                    }
                    case INT32: {
                        value = reader2.readInt32();
                        break;
                    }
                    case FIXED64: {
                        value = reader2.readFixed64();
                        break;
                    }
                    case FIXED32: {
                        value = reader2.readFixed32();
                        break;
                    }
                    case BOOL: {
                        value = reader2.readBool();
                        break;
                    }
                    case BYTES: {
                        value = reader2.readBytes();
                        break;
                    }
                    case UINT32: {
                        value = reader2.readUInt32();
                        break;
                    }
                    case SFIXED32: {
                        value = reader2.readSFixed32();
                        break;
                    }
                    case SFIXED64: {
                        value = reader2.readSFixed64();
                        break;
                    }
                    case SINT32: {
                        value = reader2.readSInt32();
                        break;
                    }
                    case SINT64: {
                        value = reader2.readSInt64();
                        break;
                    }
                    case STRING: {
                        value = reader2.readString();
                        break;
                    }
                    case GROUP: {
                        Object oldValue;
                        if (!extension.isRepeated() && (oldValue = extensions.getField(extension.descriptor)) instanceof GeneratedMessageLite) {
                            Schema<Object> extSchema = Protobuf.getInstance().schemaFor(oldValue);
                            if (!((GeneratedMessageLite)oldValue).isMutable()) {
                                Object newValue = extSchema.newInstance();
                                extSchema.mergeFrom(newValue, oldValue);
                                extensions.setField(extension.descriptor, newValue);
                                oldValue = newValue;
                            }
                            reader2.mergeGroupField(oldValue, extSchema, extensionRegistry);
                            return unknownFields;
                        }
                        value = reader2.readGroup(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case MESSAGE: {
                        Object oldValue;
                        if (!extension.isRepeated() && (oldValue = extensions.getField(extension.descriptor)) instanceof GeneratedMessageLite) {
                            Schema<Object> extSchema = Protobuf.getInstance().schemaFor(oldValue);
                            if (!((GeneratedMessageLite)oldValue).isMutable()) {
                                Object newValue = extSchema.newInstance();
                                extSchema.mergeFrom(newValue, oldValue);
                                extensions.setField(extension.descriptor, newValue);
                                oldValue = newValue;
                            }
                            reader2.mergeMessageField(oldValue, extSchema, extensionRegistry);
                            return unknownFields;
                        }
                        value = reader2.readMessage(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
                        break;
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension.isRepeated()) {
                extensions.addRepeatedField(extension.descriptor, value);
            } else {
                switch (extension.getLiteType()) {
                    case GROUP: 
                    case MESSAGE: {
                        Object oldValue = extensions.getField(extension.descriptor);
                        if (oldValue == null) break;
                        value = Internal.mergeMessage(oldValue, value);
                        break;
                    }
                }
                extensions.setField(extension.descriptor, value);
            }
        }
        return unknownFields;
    }

    @Override
    int extensionNumber(Map.Entry<?, ?> extension) {
        GeneratedMessageLite.ExtensionDescriptor descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
        return descriptor.getNumber();
    }

    @Override
    void serializeExtension(Writer writer2, Map.Entry<?, ?> extension) throws IOException {
        block42: {
            GeneratedMessageLite.ExtensionDescriptor descriptor;
            block41: {
                descriptor = (GeneratedMessageLite.ExtensionDescriptor)extension.getKey();
                if (!descriptor.isRepeated()) break block41;
                switch (descriptor.getLiteType()) {
                    case DOUBLE: {
                        SchemaUtil.writeDoubleList(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case FLOAT: {
                        SchemaUtil.writeFloatList(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case INT64: {
                        SchemaUtil.writeInt64List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case UINT64: {
                        SchemaUtil.writeUInt64List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case INT32: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case FIXED64: {
                        SchemaUtil.writeFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case FIXED32: {
                        SchemaUtil.writeFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case BOOL: {
                        SchemaUtil.writeBoolList(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case BYTES: {
                        SchemaUtil.writeBytesList(descriptor.getNumber(), (List)extension.getValue(), writer2);
                        break;
                    }
                    case UINT32: {
                        SchemaUtil.writeUInt32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case SFIXED32: {
                        SchemaUtil.writeSFixed32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case SFIXED64: {
                        SchemaUtil.writeSFixed64List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case SINT32: {
                        SchemaUtil.writeSInt32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case SINT64: {
                        SchemaUtil.writeSInt64List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case ENUM: {
                        SchemaUtil.writeInt32List(descriptor.getNumber(), (List)extension.getValue(), writer2, descriptor.isPacked());
                        break;
                    }
                    case STRING: {
                        SchemaUtil.writeStringList(descriptor.getNumber(), (List)extension.getValue(), writer2);
                        break;
                    }
                    case GROUP: {
                        List data = (List)extension.getValue();
                        if (data != null && !data.isEmpty()) {
                            SchemaUtil.writeGroupList(descriptor.getNumber(), (List)extension.getValue(), writer2, Protobuf.getInstance().schemaFor(data.get(0).getClass()));
                            break;
                        }
                        break block42;
                    }
                    case MESSAGE: {
                        List data = (List)extension.getValue();
                        if (data == null || data.isEmpty()) break;
                        SchemaUtil.writeMessageList(descriptor.getNumber(), (List)extension.getValue(), writer2, Protobuf.getInstance().schemaFor(data.get(0).getClass()));
                    }
                }
                break block42;
            }
            switch (descriptor.getLiteType()) {
                case DOUBLE: {
                    writer2.writeDouble(descriptor.getNumber(), (Double)extension.getValue());
                    break;
                }
                case FLOAT: {
                    writer2.writeFloat(descriptor.getNumber(), ((Float)extension.getValue()).floatValue());
                    break;
                }
                case INT64: {
                    writer2.writeInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case UINT64: {
                    writer2.writeUInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case INT32: {
                    writer2.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case FIXED64: {
                    writer2.writeFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case FIXED32: {
                    writer2.writeFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case BOOL: {
                    writer2.writeBool(descriptor.getNumber(), (Boolean)extension.getValue());
                    break;
                }
                case BYTES: {
                    writer2.writeBytes(descriptor.getNumber(), (ByteString)extension.getValue());
                    break;
                }
                case UINT32: {
                    writer2.writeUInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED32: {
                    writer2.writeSFixed32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SFIXED64: {
                    writer2.writeSFixed64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case SINT32: {
                    writer2.writeSInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case SINT64: {
                    writer2.writeSInt64(descriptor.getNumber(), (Long)extension.getValue());
                    break;
                }
                case ENUM: {
                    writer2.writeInt32(descriptor.getNumber(), (Integer)extension.getValue());
                    break;
                }
                case STRING: {
                    writer2.writeString(descriptor.getNumber(), (String)extension.getValue());
                    break;
                }
                case GROUP: {
                    writer2.writeGroup(descriptor.getNumber(), extension.getValue(), Protobuf.getInstance().schemaFor(extension.getValue().getClass()));
                    break;
                }
                case MESSAGE: {
                    writer2.writeMessage(descriptor.getNumber(), extension.getValue(), Protobuf.getInstance().schemaFor(extension.getValue().getClass()));
                }
            }
        }
    }

    @Override
    Object findExtensionByNumber(ExtensionRegistryLite extensionRegistry, MessageLite defaultInstance, int number) {
        return extensionRegistry.findLiteExtensionByNumber(defaultInstance, number);
    }

    @Override
    void parseLengthPrefixedMessageSetItem(Reader reader2, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        Object value = reader2.readMessage(extension.getMessageDefaultInstance().getClass(), extensionRegistry);
        extensions.setField(extension.descriptor, value);
    }

    @Override
    void parseMessageSetItem(ByteString data, Object extensionObject, ExtensionRegistryLite extensionRegistry, FieldSet<GeneratedMessageLite.ExtensionDescriptor> extensions) throws IOException {
        GeneratedMessageLite.GeneratedExtension extension = (GeneratedMessageLite.GeneratedExtension)extensionObject;
        MessageLite.Builder builder2 = extension.getMessageDefaultInstance().newBuilderForType();
        CodedInputStream input2 = data.newCodedInput();
        builder2.mergeFrom(input2, extensionRegistry);
        extensions.setField(extension.descriptor, builder2.buildPartial());
        input2.checkLastTagWas(0);
    }
}

