/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.internal;

import app.simplecloud.relocate.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

class SerializeReentrantCallsDirectExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SerializeReentrantCallsDirectExecutor.class.getName());
    private boolean executing;
    private ArrayDeque<Runnable> taskQueue;

    SerializeReentrantCallsDirectExecutor() {
    }

    @Override
    public void execute(Runnable task2) {
        Preconditions.checkNotNull(task2, "'task' must not be null.");
        if (!this.executing) {
            this.executing = true;
            try {
                task2.run();
            }
            catch (Throwable t2) {
                log.log(Level.SEVERE, "Exception while executing runnable " + task2, t2);
            }
            finally {
                if (this.taskQueue != null) {
                    this.completeQueuedTasks();
                }
                this.executing = false;
            }
        } else {
            this.enqueue(task2);
        }
    }

    private void completeQueuedTasks() {
        Runnable task2 = null;
        while ((task2 = this.taskQueue.poll()) != null) {
            try {
                task2.run();
            }
            catch (Throwable t2) {
                log.log(Level.SEVERE, "Exception while executing runnable " + task2, t2);
            }
        }
    }

    private void enqueue(Runnable r) {
        if (this.taskQueue == null) {
            this.taskQueue = new ArrayDeque(4);
        }
        this.taskQueue.add(r);
    }
}

