/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty;

import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.ChannelCredentials;
import app.simplecloud.relocate.io.grpc.Internal;
import app.simplecloud.relocate.io.grpc.ManagedChannelProvider;
import app.simplecloud.relocate.io.grpc.internal.SharedResourcePool;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty.NettyChannelProvider;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.grpc.netty.Utils;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;

@Internal
public final class UdsNettyChannelProvider
extends ManagedChannelProvider {
    @Override
    public boolean isAvailable() {
        return Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE != null;
    }

    @Override
    public int priority() {
        return 3;
    }

    public NettyChannelBuilder builderForAddress(String name, int port) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    public NettyChannelBuilder builderForTarget(String target) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    @Override
    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        Preconditions.checkState(this.isAvailable());
        ManagedChannelProvider.NewChannelBuilderResult result2 = new NettyChannelProvider().newChannelBuilder(target, creds);
        if (result2.getChannelBuilder() != null) {
            ((NettyChannelBuilder)result2.getChannelBuilder()).eventLoopGroupPool(SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP)).channelType(Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE, DomainSocketAddress.class);
        }
        return result2;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

