/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.bootstrap;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.bootstrap.AbstractBootstrapConfig;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.bootstrap.ChannelFactory;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.bootstrap.FailedChannel;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.Channel;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.DefaultChannelPromise;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ReflectiveChannelFactory;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.AttributeKey;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractBootstrap<B extends AbstractBootstrap<B, C>, C extends Channel>
implements Cloneable {
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    volatile EventLoopGroup group;
    private volatile ChannelFactory<? extends C> channelFactory;
    private volatile SocketAddress localAddress;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private volatile ChannelHandler handler;

    AbstractBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBootstrap(AbstractBootstrap<B, C> bootstrap) {
        this.group = bootstrap.group;
        this.channelFactory = bootstrap.channelFactory;
        this.handler = bootstrap.handler;
        this.localAddress = bootstrap.localAddress;
        Map<ChannelOption<?>, Object> map2 = bootstrap.options;
        synchronized (map2) {
            this.options.putAll(bootstrap.options);
        }
        this.attrs.putAll(bootstrap.attrs);
    }

    public B group(EventLoopGroup group) {
        ObjectUtil.checkNotNull(group, "group");
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = group;
        return this.self();
    }

    private B self() {
        return (B)this;
    }

    public B channel(Class<? extends C> channelClass) {
        return this.channelFactory((app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelFactory<? extends C>)new ReflectiveChannelFactory<C>(ObjectUtil.checkNotNull(channelClass, "channelClass")));
    }

    @Deprecated
    public B channelFactory(ChannelFactory<? extends C> channelFactory) {
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = channelFactory;
        return this.self();
    }

    public B channelFactory(app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelFactory<? extends C> channelFactory) {
        return this.channelFactory((ChannelFactory<? extends C>)channelFactory);
    }

    public B localAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
        return this.self();
    }

    public B localAddress(int inetPort) {
        return this.localAddress(new InetSocketAddress(inetPort));
    }

    public B localAddress(String inetHost, int inetPort) {
        return this.localAddress(SocketUtils.socketAddress(inetHost, inetPort));
    }

    public B localAddress(InetAddress inetHost, int inetPort) {
        return this.localAddress(new InetSocketAddress(inetHost, inetPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> B option(ChannelOption<T> option2, T value) {
        ObjectUtil.checkNotNull(option2, "option");
        Map<ChannelOption<?>, Object> map2 = this.options;
        synchronized (map2) {
            if (value == null) {
                this.options.remove(option2);
            } else {
                this.options.put(option2, value);
            }
        }
        return this.self();
    }

    public <T> B attr(AttributeKey<T> key2, T value) {
        ObjectUtil.checkNotNull(key2, "key");
        if (value == null) {
            this.attrs.remove(key2);
        } else {
            this.attrs.put(key2, value);
        }
        return this.self();
    }

    public B validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        if (this.channelFactory == null) {
            throw new IllegalStateException("channel or channelFactory not set");
        }
        return this.self();
    }

    public abstract B clone();

    public ChannelFuture register() {
        this.validate();
        return this.initAndRegister();
    }

    public ChannelFuture bind() {
        this.validate();
        SocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            throw new IllegalStateException("localAddress not set");
        }
        return this.doBind(localAddress);
    }

    public ChannelFuture bind(int inetPort) {
        return this.bind(new InetSocketAddress(inetPort));
    }

    public ChannelFuture bind(String inetHost, int inetPort) {
        return this.bind(SocketUtils.socketAddress(inetHost, inetPort));
    }

    public ChannelFuture bind(InetAddress inetHost, int inetPort) {
        return this.bind(new InetSocketAddress(inetHost, inetPort));
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        this.validate();
        return this.doBind(ObjectUtil.checkNotNull(localAddress, "localAddress"));
    }

    private ChannelFuture doBind(final SocketAddress localAddress) {
        final ChannelFuture regFuture = this.initAndRegister();
        final Channel channel2 = regFuture.channel();
        if (regFuture.cause() != null) {
            return regFuture;
        }
        if (regFuture.isDone()) {
            ChannelPromise promise = channel2.newPromise();
            AbstractBootstrap.doBind0(regFuture, channel2, localAddress, promise);
            return promise;
        }
        final PendingRegistrationPromise promise = new PendingRegistrationPromise(channel2);
        regFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    promise.setFailure(cause);
                } else {
                    promise.registered();
                    AbstractBootstrap.doBind0(regFuture, channel2, localAddress, promise);
                }
            }
        });
        return promise;
    }

    final ChannelFuture initAndRegister() {
        Channel channel2 = null;
        try {
            channel2 = (Channel)this.channelFactory.newChannel();
            this.init(channel2);
        }
        catch (Throwable t2) {
            if (channel2 != null) {
                channel2.unsafe().closeForcibly();
                return new DefaultChannelPromise(channel2, GlobalEventExecutor.INSTANCE).setFailure(t2);
            }
            return new DefaultChannelPromise(new FailedChannel(), GlobalEventExecutor.INSTANCE).setFailure(t2);
        }
        ChannelFuture regFuture = this.config().group().register(channel2);
        if (regFuture.cause() != null) {
            if (channel2.isRegistered()) {
                channel2.close();
            } else {
                channel2.unsafe().closeForcibly();
            }
        }
        return regFuture;
    }

    abstract void init(Channel var1) throws Exception;

    private static void doBind0(final ChannelFuture regFuture, final Channel channel2, final SocketAddress localAddress, final ChannelPromise promise) {
        channel2.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (regFuture.isSuccess()) {
                    channel2.bind(localAddress, promise).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                } else {
                    promise.setFailure(regFuture.cause());
                }
            }
        });
    }

    public B handler(ChannelHandler handler) {
        this.handler = ObjectUtil.checkNotNull(handler, "handler");
        return this.self();
    }

    @Deprecated
    public final EventLoopGroup group() {
        return this.group;
    }

    public abstract AbstractBootstrapConfig<B, C> config();

    final Map.Entry<ChannelOption<?>, Object>[] newOptionsArray() {
        return AbstractBootstrap.newOptionsArray(this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map.Entry<ChannelOption<?>, Object>[] newOptionsArray(Map<ChannelOption<?>, Object> options2) {
        Map<ChannelOption<?>, Object> map2 = options2;
        synchronized (map2) {
            return new LinkedHashMap(options2).entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
    }

    final Map.Entry<AttributeKey<?>, Object>[] newAttributesArray() {
        return AbstractBootstrap.newAttributesArray(this.attrs0());
    }

    static Map.Entry<AttributeKey<?>, Object>[] newAttributesArray(Map<AttributeKey<?>, Object> attributes) {
        return attributes.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY);
    }

    final Map<ChannelOption<?>, Object> options0() {
        return this.options;
    }

    final Map<AttributeKey<?>, Object> attrs0() {
        return this.attrs;
    }

    final SocketAddress localAddress() {
        return this.localAddress;
    }

    final ChannelFactory<? extends C> channelFactory() {
        return this.channelFactory;
    }

    final ChannelHandler handler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> options() {
        Map<ChannelOption<?>, Object> map2 = this.options;
        synchronized (map2) {
            return AbstractBootstrap.copiedMap(this.options);
        }
    }

    final Map<AttributeKey<?>, Object> attrs() {
        return AbstractBootstrap.copiedMap(this.attrs);
    }

    static <K, V> Map<K, V> copiedMap(Map<K, V> map2) {
        if (map2.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map2));
    }

    static void setAttributes(Channel channel2, Map.Entry<AttributeKey<?>, Object>[] attrs) {
        for (Map.Entry<AttributeKey<?>, Object> e : attrs) {
            AttributeKey<?> key2 = e.getKey();
            channel2.attr(key2).set(e.getValue());
        }
    }

    static void setChannelOptions(Channel channel2, Map.Entry<ChannelOption<?>, Object>[] options2, InternalLogger logger) {
        for (Map.Entry<ChannelOption<?>, Object> e : options2) {
            AbstractBootstrap.setChannelOption(channel2, e.getKey(), e.getValue(), logger);
        }
    }

    private static void setChannelOption(Channel channel2, ChannelOption<?> option2, Object value, InternalLogger logger) {
        try {
            if (!channel2.config().setOption(option2, value)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", (Object)option2, (Object)channel2);
            }
        }
        catch (Throwable t2) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", option2, value, channel2, t2);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName(this)).append('(').append(this.config()).append(')');
        return buf.toString();
    }

    static final class PendingRegistrationPromise
    extends DefaultChannelPromise {
        private volatile boolean registered;

        PendingRegistrationPromise(Channel channel2) {
            super(channel2);
        }

        void registered() {
            this.registered = true;
        }

        @Override
        protected EventExecutor executor() {
            if (this.registered) {
                return super.executor();
            }
            return GlobalEventExecutor.INSTANCE;
        }
    }
}

