/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.ssl;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.ssl.PemEncoded;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    PemValue(ByteBuf content2, boolean sensitive) {
        this.content = ObjectUtil.checkNotNull(content2, "content");
        this.sensitive = sensitive;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ByteBuf content() {
        int count = this.refCnt();
        if (count <= 0) {
            throw new IllegalReferenceCountException(count);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public PemValue duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public PemValue retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public PemValue replace(ByteBuf content2) {
        return new PemValue(content2, this.sensitive);
    }

    @Override
    public PemValue touch() {
        return (PemValue)super.touch();
    }

    @Override
    public PemValue touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    public PemValue retain(int increment) {
        return (PemValue)super.retain(increment);
    }

    @Override
    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

