/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> enumClass, SerializableString[] textual) {
        this._enumClass = enumClass;
        this._values = enumClass.getEnumConstants();
        this._textual = textual;
    }

    public static EnumValues construct(SerializationConfig config2, AnnotatedClass annotatedClass) {
        if (config2.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(config2, annotatedClass);
        }
        return EnumValues.constructFromName(config2, annotatedClass);
    }

    @Deprecated
    public static EnumValues constructFromName(MapperConfig<?> config2, Class<Enum<?>> enumClass) {
        Class<Enum<?>> enumCls = ClassUtil.findEnumType(enumClass);
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + enumClass.getName());
        }
        String[] names = config2.getAnnotationIntrospector().findEnumValues(enumCls, enumValues, new String[enumValues.length]);
        SerializableString[] textual = new SerializableString[enumValues.length];
        int len = enumValues.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Enum<?> en = enumValues[i2];
            String name = names[i2];
            if (name == null) {
                name = en.name();
            }
            if (config2.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
                name = name.toLowerCase();
            }
            textual[en.ordinal()] = config2.compileString(name);
        }
        return EnumValues.construct(enumClass, textual);
    }

    public static EnumValues constructFromName(MapperConfig<?> config2, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        boolean useLowerCase = config2.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = ai.findEnumValues(config2, annotatedClass, enumConstants, new String[enumConstants.length]);
        SerializableString[] textual = new SerializableString[enumConstants.length];
        int len = enumConstants.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Enum<?> enumValue = enumConstants[i2];
            String name = names[i2];
            if (name == null) {
                name = enumValue.name();
            }
            if (useLowerCase) {
                name = name.toLowerCase();
            }
            textual[enumValue.ordinal()] = config2.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    public static EnumValues constructFromToString(MapperConfig<?> config2, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        boolean useLowerCase = config2.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = new String[enumConstants.length];
        if (ai != null) {
            ai.findEnumValues(config2, annotatedClass, enumConstants, names);
        }
        SerializableString[] textual = new SerializableString[enumConstants.length];
        for (int i2 = 0; i2 < enumConstants.length; ++i2) {
            Enum<?> en;
            String name = names[i2];
            if (name == null && (name = (en = enumConstants[i2]).toString()) == null) {
                name = "";
            }
            if (useLowerCase) {
                name = name.toLowerCase();
            }
            textual[i2] = config2.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    @Deprecated
    public static EnumValues constructFromToString(MapperConfig<?> config2, Class<Enum<?>> enumClass) {
        Class<Enum<?>> cls = ClassUtil.findEnumType(enumClass);
        Enum<?>[] values = cls.getEnumConstants();
        if (values == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + enumClass.getName());
        }
        ArrayList<String> external = new ArrayList<String>(values.length);
        for (Enum<?> en : values) {
            external.add(en.toString());
        }
        return EnumValues.construct(config2, enumClass, external);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> config2, AnnotatedClass annotatedClass, EnumNamingStrategy namingStrategy) {
        AnnotationIntrospector ai = config2.getAnnotationIntrospector();
        boolean useLowerCase = config2.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumValues._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumValues._enumConstants(enumCls0);
        String[] names = new String[enumConstants.length];
        if (ai != null) {
            ai.findEnumValues(config2, annotatedClass, enumConstants, names);
        }
        SerializableString[] textual = new SerializableString[enumConstants.length];
        int len = enumConstants.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Enum<?> enumValue = enumConstants[i2];
            String name = names[i2];
            if (name == null) {
                name = namingStrategy.convertEnumToExternalName(enumValue.name());
            }
            if (useLowerCase) {
                name = name.toLowerCase();
            }
            textual[i2] = config2.compileString(name);
        }
        return EnumValues.construct(enumCls, textual);
    }

    @Deprecated
    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> config2, Class<Enum<?>> enumClass, EnumNamingStrategy namingStrategy) {
        Class<Enum<?>> cls = ClassUtil.findEnumType(enumClass);
        Enum<?>[] values = cls.getEnumConstants();
        if (values == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + enumClass.getName());
        }
        ArrayList<String> external = new ArrayList<String>(values.length);
        for (Enum<?> en : values) {
            external.add(namingStrategy.convertEnumToExternalName(en.name()));
        }
        return EnumValues.construct(config2, enumClass, external);
    }

    public static EnumValues construct(MapperConfig<?> config2, Class<Enum<?>> enumClass, List<String> externalValues) {
        int len = externalValues.size();
        SerializableString[] textual = new SerializableString[len];
        for (int i2 = 0; i2 < len; ++i2) {
            textual[i2] = config2.compileString(externalValues.get(i2));
        }
        return EnumValues.construct(enumClass, textual);
    }

    public static EnumValues construct(Class<Enum<?>> enumClass, SerializableString[] externalValues) {
        return new EnumValues(enumClass, externalValues);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> enumCls0) {
        return enumCls0;
    }

    protected static Enum<?>[] _enumConstants(Class<?> enumCls) {
        Enum<?>[] enumValues = ClassUtil.findEnumType(enumCls).getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        return enumValues;
    }

    public SerializableString serializedValueFor(Enum<?> key2) {
        return this._textual[key2.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public EnumMap<?, SerializableString> internalMap() {
        EnumMap<Object, SerializableString> result2 = this._asMap;
        if (result2 == null) {
            LinkedHashMap map2 = new LinkedHashMap();
            for (Enum<?> en : this._values) {
                map2.put(en, this._textual[en.ordinal()]);
            }
            this._asMap = result2 = new EnumMap(map2);
        }
        return result2;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

