/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.calculate;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.calculate.DoubleJch;
import com.github.ajalt.colormath.calculate.DoubleLab;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a!\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u00022\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001c\u0010\u0007\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a&\u0010\u000b\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u000f"}, d2={"euclideanDistance", "", "T", "Lcom/github/ajalt/colormath/Color;", "other", "(Lcom/github/ajalt/colormath/Color;Lcom/github/ajalt/colormath/Color;)F", "differenceCIE76", "differenceCIE94", "textiles", "", "differenceCIE2000", "differenceCMC", "l", "c", "differenceEz", "colormath"})
public final class DifferenceKt {
    public static final <T extends Color> float euclideanDistance(@NotNull T $this$euclideanDistance, @NotNull T other) {
        Intrinsics.checkNotNullParameter($this$euclideanDistance, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        float[] c1 = $this$euclideanDistance.toArray();
        float[] c2 = other.toArray();
        return InternalMathKt.sqrtSumSq(c1[0] - c2[0], c1[1] - c2[1], c1[2] - c2[2]);
    }

    public static final float differenceCIE76(@NotNull Color $this$differenceCIE76, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceCIE76, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LAB lAB = DoubleLab.constructor-impl($this$differenceCIE76.toLAB());
        double l1 = DoubleLab.component1-impl(lAB);
        double a1 = DoubleLab.component2-impl(lAB);
        double b1 = DoubleLab.component3-impl(lAB);
        LAB lAB2 = DoubleLab.constructor-impl(other.toLAB());
        double l2 = DoubleLab.component1-impl(lAB2);
        double a2 = DoubleLab.component2-impl(lAB2);
        double b2 = DoubleLab.component3-impl(lAB2);
        return (float)InternalMathKt.sqrtSumSq(l1 - l2, a1 - a2, b1 - b2);
    }

    public static final float differenceCIE94(@NotNull Color $this$differenceCIE94, @NotNull Color other, boolean textiles) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceCIE94, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LAB lAB = DoubleLab.constructor-impl($this$differenceCIE94.toLAB());
        double l1 = DoubleLab.component1-impl(lAB);
        double a1 = DoubleLab.component2-impl(lAB);
        double b1 = DoubleLab.component3-impl(lAB);
        LAB lAB2 = DoubleLab.constructor-impl(other.toLAB());
        double l2 = DoubleLab.component1-impl(lAB2);
        double a2 = DoubleLab.component2-impl(lAB2);
        double b2 = DoubleLab.component3-impl(lAB2);
        int kL = textiles ? 2 : 1;
        double k1 = textiles ? 0.048 : 0.045;
        double k2 = textiles ? 0.014 : 0.015;
        double c1 = InternalMathKt.sqrtSumSq(a1, b1);
        double c2 = InternalMathKt.sqrtSumSq(a2, b2);
        double da = a1 - a2;
        double db = b1 - b2;
        double dl = l1 - l2;
        double dc = c1 - c2;
        double dh = Math.sqrt(Math.pow(da, 2) + Math.pow(db, 2) - Math.pow(dc, 2));
        double sc = 1.0 + k1 * c1;
        double sh = 1.0 + k2 * c1;
        return (float)InternalMathKt.sqrtSumSq(dl / (double)kL, dc / sc, dh / sh);
    }

    public static /* synthetic */ float differenceCIE94$default(Color color, Color color2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DifferenceKt.differenceCIE94(color, color2, bl);
    }

    public static final float differenceCIE2000(@NotNull Color $this$differenceCIE2000, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceCIE2000, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LAB lAB = DoubleLab.constructor-impl($this$differenceCIE2000.toLAB());
        double l1 = DoubleLab.component1-impl(lAB);
        double a1 = DoubleLab.component2-impl(lAB);
        double b1 = DoubleLab.component3-impl(lAB);
        LAB lAB2 = DoubleLab.constructor-impl(other.toLAB());
        double l2 = DoubleLab.component1-impl(lAB2);
        double a2 = DoubleLab.component2-impl(lAB2);
        double b2 = DoubleLab.component3-impl(lAB2);
        double lbp = (l1 + l2) / (double)2;
        double c1 = InternalMathKt.sqrtSumSq(a1, b1);
        double c2 = InternalMathKt.sqrtSumSq(a2, b2);
        double cb = (c1 + c2) / (double)2;
        double cb7 = Math.pow(cb, 7);
        double g2 = 1.0 - Math.sqrt(cb7 / (cb7 + Math.pow(25.0, 7)));
        double ap1 = a1 * (1.0 + g2);
        double ap2 = a2 * (1.0 + g2);
        double cp1 = InternalMathKt.sqrtSumSq(ap1, b1);
        double cp2 = InternalMathKt.sqrtSumSq(ap2, b2);
        double cbp = (cp1 + cp2) / (double)2;
        double hp1 = InternalMathKt.normalizeDeg(InternalMathKt.radToDeg(Math.atan2(b1, ap1)));
        double hp2 = InternalMathKt.normalizeDeg(InternalMathKt.radToDeg(Math.atan2(b2, ap2)));
        double hpDiff = Math.abs(hp1 - hp2);
        double hbp = hpDiff > 180.0 ? (hp1 + hp2 + (double)360) / (double)2 : (hp1 + hp2) / (double)2;
        double t2 = 1.0 - 0.17 * InternalMathKt.cosDeg(hbp - (double)30) + 0.24 * InternalMathKt.cosDeg((double)2 * hbp) + 0.32 * InternalMathKt.cosDeg((double)3 * hbp + (double)6) - 0.2 * InternalMathKt.cosDeg((double)4 * hbp - (double)63);
        double dhp = hpDiff <= 180.0 ? hp2 - hp1 : (hp2 <= hp1 ? hp2 - hp1 + (double)360 : hp2 - hp1 - (double)360);
        double dlp = l2 - l1;
        double dcp = cp2 - cp1;
        double dHp = (double)2 * Math.sqrt(cp1 * cp2) * InternalMathKt.sinDeg(dhp / (double)2);
        double sl = 1.0 + 0.015 * Math.pow(lbp - (double)50, 2) / Math.sqrt((double)20 + Math.pow(lbp - (double)50, 2));
        double sc = 1.0 + 0.045 * cbp;
        double sh = 1.0 + 0.015 * cbp * t2;
        double dTheta = (double)30 * Math.exp(-Math.pow((hbp - (double)275) / (double)25, 2));
        double cbp7 = Math.pow(cbp, 7);
        double rc2 = Math.sqrt(cbp7 / (cbp7 + Math.pow(25.0, 7)));
        double rt = (double)-2 * rc2 * InternalMathKt.sinDeg((double)2 * dTheta);
        return (float)Math.sqrt(Math.pow(dlp / sl, 2) + Math.pow(dcp / sc, 2) + Math.pow(dHp / sh, 2) + rt * (dcp / sc) * (dHp / sh));
    }

    public static final float differenceCMC(@NotNull Color $this$differenceCMC, @NotNull Color other, float l, float c) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceCMC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        LAB lAB = DoubleLab.constructor-impl($this$differenceCMC.toLAB());
        double l1 = DoubleLab.component1-impl(lAB);
        double a1 = DoubleLab.component2-impl(lAB);
        double b1 = DoubleLab.component3-impl(lAB);
        LAB lAB2 = DoubleLab.constructor-impl(other.toLAB());
        double l2 = DoubleLab.component1-impl(lAB2);
        double a2 = DoubleLab.component2-impl(lAB2);
        double b2 = DoubleLab.component3-impl(lAB2);
        double c1 = InternalMathKt.sqrtSumSq(a1, b1);
        double c2 = InternalMathKt.sqrtSumSq(a2, b2);
        double dl = l1 - l2;
        double da = a1 - a2;
        double db = b1 - b2;
        double dc = c1 - c2;
        double h1 = InternalMathKt.normalizeDeg(InternalMathKt.radToDeg(Math.atan2(b1, a1)));
        double t2 = (164.0 <= h1 ? h1 <= 345.0 : false) ? 0.56 + Math.abs(0.2 * InternalMathKt.cosDeg(h1 + (double)168)) : 0.36 + Math.abs(0.4 * InternalMathKt.cosDeg(h1 + (double)35));
        double f = Math.sqrt(Math.pow(c1, 4) / (Math.pow(c1, 4) + (double)1900));
        double sl = l1 < 16.0 ? 0.511 : 0.040975 * l1 / (1.0 + 0.01765 * l1);
        double sc = 0.0638 * c1 / (1.0 + 0.0131 * c1) + 0.638;
        double sh = sc * (f * t2 + 1.0 - f);
        double dh2 = Math.pow(da, 2) + Math.pow(db, 2) - Math.pow(dc, 2);
        double v1 = dl / ((double)l * sl);
        double v2 = dc / ((double)c * sc);
        double sqrt = Math.sqrt(Math.pow(v1, 2) + Math.pow(v2, 2) + dh2 / Math.pow(sh, 2));
        return (float)sqrt;
    }

    public static /* synthetic */ float differenceCMC$default(Color color, Color color2, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 2.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        return DifferenceKt.differenceCMC(color, color2, f, f2);
    }

    public static final float differenceEz(@NotNull Color $this$differenceEz, @NotNull Color other) {
        Intrinsics.checkNotNullParameter((Object)$this$differenceEz, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        JzCzHz jzCzHz = DoubleJch.constructor-impl($this$differenceEz.toJzCzHz());
        double j1 = DoubleJch.component1-impl(jzCzHz);
        double c1 = DoubleJch.component2-impl(jzCzHz);
        double h1 = DoubleJch.component3-impl(jzCzHz);
        JzCzHz jzCzHz2 = DoubleJch.constructor-impl(other.toJzCzHz());
        double j2 = DoubleJch.component1-impl(jzCzHz2);
        double c2 = DoubleJch.component2-impl(jzCzHz2);
        double h2 = DoubleJch.component3-impl(jzCzHz2);
        double dH2 = (double)2 * c1 * c2 * (1.0 - InternalMathKt.cosDeg(h2 - h1));
        return (float)Math.sqrt(Math.pow(j2 - j1, 2) + Math.pow(c2 - c1, 2) + dH2);
    }
}

