/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u00a8\u0006\b"}, d2={"readBytesAsUtf8", "", "readByte", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Integer;", "codepointToString", "", "codePoint", "mordant"})
public final class Utf8Kt {
    @Nullable
    public static final Integer readBytesAsUtf8(@NotNull Function0<Integer> readByte2) {
        Intrinsics.checkNotNullParameter(readByte2, (String)"readByte");
        Integer n = (Integer)readByte2.invoke();
        if (n == null) {
            return null;
        }
        int n2 = n;
        int byteLength = 0;
        int codepoint = 0;
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        if ((n2 & 0xE0) == 192) {
            codepoint = n2 & 0x1F;
            byteLength = 2;
        } else if ((n2 & 0xF0) == 224) {
            codepoint = n2 & 0xF;
            byteLength = 3;
        } else if ((n2 & 0xF8) == 240) {
            codepoint = n2 & 7;
            byteLength = 4;
        } else {
            throw new IllegalStateException("Invalid UTF-8 byte".toString());
        }
        int n3 = byteLength - 1;
        int n4 = 0;
        while (n4 < n3) {
            int it = n4++;
            boolean bl = false;
            Integer n5 = (Integer)readByte2.invoke();
            if (n5 == null) {
                return null;
            }
            int next = n5;
            if ((next & 0xC0) != 128) {
                throw new IllegalStateException("Invalid UTF-8 byte".toString());
            }
            codepoint = codepoint << 6 | next & 0x3F;
        }
        return codepoint;
    }

    @NotNull
    public static final String codepointToString(int codePoint) {
        String string;
        int n = codePoint;
        boolean bl = 0 <= n ? n < 65536 : false;
        if (bl) {
            if (codePoint < 0 || codePoint > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + codePoint);
            }
            string = String.valueOf((char)codePoint);
        } else {
            boolean bl2 = 65536 <= n ? n < 0x110000 : false;
            if (bl2) {
                int n2 = codePoint - 65536 >> 10 | 0xD800;
                if (n2 < 0 || n2 > 65535) {
                    throw new IllegalArgumentException("Invalid Char code: " + n2);
                }
                char highSurrogate = (char)n2;
                int n3 = codePoint - 65536 & 0x3FF | 0xDC00;
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("Invalid Char code: " + n3);
                }
                char lowSurrogate = (char)n3;
                string = "" + highSurrogate + lowSurrogate;
            } else {
                throw new IllegalArgumentException("Invalid code point: " + codePoint);
            }
        }
        return string;
    }
}

