/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.input.InputEvent;
import com.github.ajalt.mordant.input.MouseTracking;
import com.github.ajalt.mordant.internal.MppInternal_jvmKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.TerminalDetection;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimeMark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/terminal/StandardTerminalInterface;", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "<init>", "()V", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "hyperlinks", "", "outputInteractive", "inputInteractive", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "completePrintRequest", "", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "readLineOrNull", "", "hideInput", "stdoutInteractive", "stdinInteractive", "mordant"})
public abstract class StandardTerminalInterface
implements TerminalInterface {
    @Override
    @NotNull
    public TerminalInfo info(@Nullable AnsiLevel ansiLevel, @Nullable Boolean hyperlinks, @Nullable Boolean outputInteractive, @Nullable Boolean inputInteractive) {
        return TerminalDetection.INSTANCE.detectTerminal(ansiLevel, hyperlinks, inputInteractive, outputInteractive, this.stdinInteractive(), this.stdoutInteractive());
    }

    @Override
    public void completePrintRequest(@NotNull PrintRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (request2.getStderr()) {
            MppInternal_jvmKt.printStderr(request2.getText(), request2.getTrailingLinebreak());
        } else if (request2.getTrailingLinebreak()) {
            if (((CharSequence)request2.getText()).length() == 0) {
                System.out.println();
            } else {
                System.out.println((Object)request2.getText());
            }
        } else {
            System.out.print((Object)request2.getText());
        }
    }

    @Override
    @Nullable
    public String readLineOrNull(boolean hideInput) {
        return MppInternal_jvmKt.readLineOrNullMpp(hideInput);
    }

    public boolean stdoutInteractive() {
        return true;
    }

    public boolean stdinInteractive() {
        return true;
    }

    @Override
    @Nullable
    public Size getTerminalSize() {
        return TerminalInterface.DefaultImpls.getTerminalSize(this);
    }

    @Override
    @Nullable
    public InputEvent readInputEvent(@NotNull TimeMark timeout2, @NotNull MouseTracking mouseTracking) {
        return TerminalInterface.DefaultImpls.readInputEvent(this, timeout2, mouseTracking);
    }

    @Override
    @NotNull
    public AutoCloseable enterRawMode(@NotNull MouseTracking mouseTracking) {
        return TerminalInterface.DefaultImpls.enterRawMode(this, mouseTracking);
    }

    @Override
    public boolean shouldAutoUpdateSize() {
        return TerminalInterface.DefaultImpls.shouldAutoUpdateSize(this);
    }
}

