/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.cio.internals.AsciiCharTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB5\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lio/ktor/http/cio/ConnectionOptions;", "", "", "close", "keepAlive", "upgrade", "", "", "extraOptions", "<init>", "(ZZZLjava/util/List;)V", "toString", "()Ljava/lang/String;", "buildToString", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Z", "getClose", "()Z", "getKeepAlive", "getUpgrade", "Ljava/util/List;", "getExtraOptions", "()Ljava/util/List;", "Companion", "ktor-http-cio"})
public final class ConnectionOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean close;
    private final boolean keepAlive;
    private final boolean upgrade;
    @NotNull
    private final List<String> extraOptions;
    @NotNull
    private static final ConnectionOptions Close = new ConnectionOptions(true, false, false, null, 14, null);
    @NotNull
    private static final ConnectionOptions KeepAlive = new ConnectionOptions(false, true, false, null, 13, null);
    @NotNull
    private static final ConnectionOptions Upgrade = new ConnectionOptions(false, false, true, null, 11, null);
    @NotNull
    private static final AsciiCharTree<Pair<String, ConnectionOptions>> knownTypes;

    public ConnectionOptions(boolean close2, boolean keepAlive, boolean upgrade, @NotNull List<String> extraOptions) {
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        this.close = close2;
        this.keepAlive = keepAlive;
        this.upgrade = upgrade;
        this.extraOptions = extraOptions;
    }

    public /* synthetic */ ConnectionOptions(boolean bl, boolean bl2, boolean bl3, List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(bl, bl2, bl3, list);
    }

    public final boolean getClose() {
        return this.close;
    }

    public final boolean getKeepAlive() {
        return this.keepAlive;
    }

    public final boolean getUpgrade() {
        return this.upgrade;
    }

    @NotNull
    public final List<String> getExtraOptions() {
        return this.extraOptions;
    }

    @NotNull
    public String toString() {
        return this.extraOptions.isEmpty() ? (this.close && !this.keepAlive && !this.upgrade ? "close" : (!this.close && this.keepAlive && !this.upgrade ? "keep-alive" : (!this.close && this.keepAlive && this.upgrade ? "keep-alive, Upgrade" : this.buildToString()))) : this.buildToString();
    }

    private final String buildToString() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildToString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ArrayList<String> items = new ArrayList<String>(this.extraOptions.size() + 3);
        if (this.close) {
            items.add("close");
        }
        if (this.keepAlive) {
            items.add("keep-alive");
        }
        if (this.upgrade) {
            items.add("Upgrade");
        }
        if (!((Collection)this.extraOptions).isEmpty()) {
            items.addAll((Collection)this.extraOptions);
        }
        CollectionsKt.joinTo$default((Iterable)items, (Appendable)$this$buildToString_u24lambda_u240, null, null, null, (int)0, null, null, (int)126, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConnectionOptions cfr_ignored_0 = (ConnectionOptions)other;
        if (this.close != ((ConnectionOptions)other).close) {
            return false;
        }
        if (this.keepAlive != ((ConnectionOptions)other).keepAlive) {
            return false;
        }
        if (this.upgrade != ((ConnectionOptions)other).upgrade) {
            return false;
        }
        return Intrinsics.areEqual(this.extraOptions, ((ConnectionOptions)other).extraOptions);
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.close);
        result2 = 31 * result2 + Boolean.hashCode(this.keepAlive);
        result2 = 31 * result2 + Boolean.hashCode(this.upgrade);
        result2 = 31 * result2 + ((Object)this.extraOptions).hashCode();
        return result2;
    }

    private static final int knownTypes$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((String)it.getFirst()).length();
    }

    private static final char knownTypes$lambda$2(Pair t2, int idx) {
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        return ((String)t2.getFirst()).charAt(idx);
    }

    public ConnectionOptions() {
        this(false, false, false, null, 15, null);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"close", (Object)Close), TuplesKt.to((Object)"keep-alive", (Object)KeepAlive), TuplesKt.to((Object)"upgrade", (Object)Upgrade)};
        knownTypes = AsciiCharTree.Companion.build(CollectionsKt.listOf((Object[])objectArray), ConnectionOptions::knownTypes$lambda$1, ConnectionOptions::knownTypes$lambda$2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bR\u0017\u0010\n\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u0011\u0010\rR&\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/ktor/http/cio/ConnectionOptions$Companion;", "", "<init>", "()V", "", "connection", "Lio/ktor/http/cio/ConnectionOptions;", "parse", "(Ljava/lang/CharSequence;)Lio/ktor/http/cio/ConnectionOptions;", "parseSlow", "Close", "Lio/ktor/http/cio/ConnectionOptions;", "getClose", "()Lio/ktor/http/cio/ConnectionOptions;", "KeepAlive", "getKeepAlive", "Upgrade", "getUpgrade", "Lio/ktor/http/cio/internals/AsciiCharTree;", "Lkotlin/Pair;", "", "knownTypes", "Lio/ktor/http/cio/internals/AsciiCharTree;", "ktor-http-cio"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConnectionOptions getClose() {
            return Close;
        }

        @NotNull
        public final ConnectionOptions getKeepAlive() {
            return KeepAlive;
        }

        @NotNull
        public final ConnectionOptions getUpgrade() {
            return Upgrade;
        }

        @Nullable
        public final ConnectionOptions parse(@Nullable CharSequence connection) {
            if (connection == null) {
                return null;
            }
            List known = AsciiCharTree.search$default(knownTypes, connection, 0, 0, true, Companion::parse$lambda$0, 6, null);
            if (known.size() == 1) {
                return (ConnectionOptions)((Pair)known.get(0)).getSecond();
            }
            return this.parseSlow(connection);
        }

        private final ConnectionOptions parseSlow(CharSequence connection) {
            int idx = 0;
            int start2 = 0;
            int length = connection.length();
            ConnectionOptions connectionOptions = null;
            ArrayList<String> hopHeadersList = null;
            while (idx < length) {
                char ch;
                do {
                    if ((ch = connection.charAt(idx)) == ' ' || ch == ',') continue;
                    start2 = idx;
                    break;
                } while (++idx < length);
                block5: while (idx < length) {
                    ch = connection.charAt(idx);
                    switch (ch) {
                        case ' ': 
                        case ',': {
                            break block5;
                        }
                        default: {
                            ++idx;
                            continue block5;
                        }
                    }
                }
                Pair detected = (Pair)CollectionsKt.singleOrNull(knownTypes.search(connection, start2, idx, true, (Function2<Character, Integer, Boolean>)((Function2)Companion::parseSlow$lambda$1)));
                if (detected == null) {
                    if (hopHeadersList == null) {
                        hopHeadersList = new ArrayList<String>();
                    }
                    hopHeadersList.add(((Object)connection.subSequence(start2, idx)).toString());
                    continue;
                }
                if (connectionOptions == null) {
                    connectionOptions = (ConnectionOptions)detected.getSecond();
                    continue;
                }
                connectionOptions = new ConnectionOptions(connectionOptions.getClose() || ((ConnectionOptions)detected.getSecond()).getClose(), connectionOptions.getKeepAlive() || ((ConnectionOptions)detected.getSecond()).getKeepAlive(), connectionOptions.getUpgrade() || ((ConnectionOptions)detected.getSecond()).getUpgrade(), CollectionsKt.emptyList());
            }
            if (connectionOptions == null) {
                connectionOptions = this.getKeepAlive();
            }
            return hopHeadersList == null ? connectionOptions : new ConnectionOptions(connectionOptions.getClose(), connectionOptions.getKeepAlive(), connectionOptions.getUpgrade(), (List<String>)hopHeadersList);
        }

        private static final boolean parse$lambda$0(char c, int n) {
            return false;
        }

        private static final boolean parseSlow$lambda$1(char c, int n) {
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

