/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.engine.ServerEngineUtilsKt;
import io.ktor.util.PlatformUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000b\u001a\u00020\b2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R1\u0010\u0015\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t0\u00148\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u00063"}, d2={"Lio/ktor/server/application/ServerConfigBuilder;", "", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;)V", "Lkotlin/Function1;", "Lio/ktor/server/application/Application;", "", "Lkotlin/ExtensionFunctionType;", "body", "module", "(Lkotlin/jvm/functions/Function1;)V", "Lio/ktor/server/application/ServerConfig;", "build$ktor_server_core", "()Lio/ktor/server/application/ServerConfig;", "build", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "", "modules", "Ljava/util/List;", "getModules$ktor_server_core", "()Ljava/util/List;", "", "", "watchPaths", "getWatchPaths", "setWatchPaths", "(Ljava/util/List;)V", "rootPath", "Ljava/lang/String;", "getRootPath", "()Ljava/lang/String;", "setRootPath", "(Ljava/lang/String;)V", "", "developmentMode", "Z", "getDevelopmentMode", "()Z", "setDevelopmentMode", "(Z)V", "Lkotlin/coroutines/CoroutineContext;", "parentCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getParentCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "setParentCoroutineContext", "(Lkotlin/coroutines/CoroutineContext;)V", "ktor-server-core"})
public final class ServerConfigBuilder {
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final List<Function1<Application, Unit>> modules;
    @NotNull
    private List<String> watchPaths;
    @NotNull
    private String rootPath;
    private boolean developmentMode;
    @NotNull
    private CoroutineContext parentCoroutineContext;

    public ServerConfigBuilder(@NotNull ApplicationEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.modules = new ArrayList();
        this.watchPaths = CollectionsKt.listOf((Object)ServerEngineUtilsKt.getWORKING_DIRECTORY_PATH());
        this.rootPath = "";
        this.developmentMode = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
        this.parentCoroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final List<Function1<Application, Unit>> getModules$ktor_server_core() {
        return this.modules;
    }

    @NotNull
    public final List<String> getWatchPaths() {
        return this.watchPaths;
    }

    public final void setWatchPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.watchPaths = list;
    }

    @NotNull
    public final String getRootPath() {
        return this.rootPath;
    }

    public final void setRootPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.rootPath = string;
    }

    public final boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    public final void setDevelopmentMode(boolean bl) {
        this.developmentMode = bl;
    }

    @NotNull
    public final CoroutineContext getParentCoroutineContext() {
        return this.parentCoroutineContext;
    }

    public final void setParentCoroutineContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.parentCoroutineContext = coroutineContext;
    }

    public final void module(@NotNull Function1<? super Application, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        this.modules.add(body2);
    }

    @NotNull
    public final ServerConfig build$ktor_server_core() {
        return new ServerConfig(this.environment, this.modules, this.watchPaths, this.rootPath, this.developmentMode, this.parentCoroutineContext);
    }
}

