/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.HttpMethod;
import io.ktor.http.RequestConnectionPoint;
import io.ktor.http.URLProtocol;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.InetSocketAddress;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0017\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u001a\u0010\u001c\u001a\u00020\t8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010!\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010#\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR\u0014\u0010'\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000bR\u0014\u0010)\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001fR\u0014\u0010+\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001fR\u0014\u0010-\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001fR\u0014\u0010/\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000bR\u0014\u00101\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001fR\u0014\u00103\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000b\u00a8\u00064"}, d2={"Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "Lio/ktor/http/RequestConnectionPoint;", "Lio/netty/handler/codec/http2/Http2Headers;", "nettyHeaders", "Ljava/net/InetSocketAddress;", "localNetworkAddress", "remoteNetworkAddress", "<init>", "(Lio/netty/handler/codec/http2/Http2Headers;Ljava/net/InetSocketAddress;Ljava/net/InetSocketAddress;)V", "", "toString", "()Ljava/lang/String;", "Lio/netty/handler/codec/http2/Http2Headers;", "Ljava/net/InetSocketAddress;", "Lio/ktor/http/HttpMethod;", "method", "Lio/ktor/http/HttpMethod;", "getMethod", "()Lio/ktor/http/HttpMethod;", "getScheme", "scheme", "getVersion", "version", "getUri", "uri", "getHost", "getHost$annotations", "()V", "host", "", "getPort", "()I", "getPort$annotations", "port", "getLocalHost", "localHost", "getServerHost", "serverHost", "getLocalAddress", "localAddress", "getDefaultPort", "defaultPort", "getLocalPort", "localPort", "getServerPort", "serverPort", "getRemoteHost", "remoteHost", "getRemotePort", "remotePort", "getRemoteAddress", "remoteAddress", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nHttp2LocalConnectionPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2LocalConnectionPoint.kt\nio/ktor/server/netty/http2/Http2LocalConnectionPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class Http2LocalConnectionPoint
implements RequestConnectionPoint {
    @NotNull
    private final Http2Headers nettyHeaders;
    @Nullable
    private final InetSocketAddress localNetworkAddress;
    @Nullable
    private final InetSocketAddress remoteNetworkAddress;
    @NotNull
    private final HttpMethod method;

    /*
     * WARNING - void declaration
     */
    public Http2LocalConnectionPoint(@NotNull Http2Headers nettyHeaders, @Nullable InetSocketAddress localNetworkAddress, @Nullable InetSocketAddress remoteNetworkAddress) {
        Object object;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)nettyHeaders, (String)"nettyHeaders");
                this.nettyHeaders = nettyHeaders;
                this.localNetworkAddress = localNetworkAddress;
                this.remoteNetworkAddress = remoteNetworkAddress;
                Http2LocalConnectionPoint http2LocalConnectionPoint = this;
                object = this.nettyHeaders.method();
                if (object == null) break block2;
                CharSequence charSequence = object;
                Http2LocalConnectionPoint http2LocalConnectionPoint2 = http2LocalConnectionPoint;
                boolean bl = false;
                HttpMethod httpMethod = HttpMethod.Companion.parse(it.toString());
                http2LocalConnectionPoint = http2LocalConnectionPoint2;
                object = httpMethod;
                if (httpMethod != null) break block3;
            }
            object = HttpMethod.Companion.getGet();
        }
        http2LocalConnectionPoint.method = object;
    }

    @Override
    @NotNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public String getScheme() {
        CharSequence charSequence = this.nettyHeaders.scheme();
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "http";
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String getVersion() {
        return "HTTP/2";
    }

    @Override
    @NotNull
    public String getUri() {
        CharSequence charSequence = this.nettyHeaders.path();
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "/";
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String getHost() {
        CharSequence charSequence = this.nettyHeaders.authority();
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null || (charSequence = StringsKt.substringBefore$default((String)charSequence, (String)":", null, (int)2, null)) == null) {
            charSequence = "localhost";
        }
        return charSequence;
    }

    @Deprecated(message="Use localHost or serverHost instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getHost$annotations() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getPort() {
        int n;
        String string;
        String string2;
        CharSequence charSequence = this.nettyHeaders.authority();
        if (charSequence != null && (string2 = ((Object)charSequence).toString()) != null && (string = StringsKt.substringAfter((String)string2, (String)":", (String)"")) != null) {
            String string3;
            String string4;
            String it = string4 = string;
            boolean bl = false;
            String string5 = string3 = ((CharSequence)it).length() > 0 ? string4 : null;
            if (string3 != null) {
                n = Integer.parseInt(string3);
                return n;
            }
        }
        InetSocketAddress inetSocketAddress = this.localNetworkAddress;
        if (inetSocketAddress == null) return 80;
        n = inetSocketAddress.getPort();
        return n;
    }

    @Deprecated(message="Use localPort or serverPort instead", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getPort$annotations() {
    }

    @Override
    @NotNull
    public String getLocalHost() {
        Object object;
        block5: {
            block4: {
                object = this.localNetworkAddress;
                if (object == null) break block4;
                InetSocketAddress it = object;
                boolean bl = false;
                String string = it.getHostName();
                if (string == null) {
                    string = it.getHostString();
                }
                object = string;
                if (string != null) break block5;
            }
            object = "localhost";
        }
        return object;
    }

    @Override
    @NotNull
    public String getServerHost() {
        String string;
        String string2;
        CharSequence charSequence = this.nettyHeaders.authority();
        return charSequence != null && (string2 = ((Object)charSequence).toString()) != null && (string = StringsKt.substringBefore$default((String)string2, (String)":", null, (int)2, null)) != null ? string : this.getLocalHost();
    }

    @Override
    @NotNull
    public String getLocalAddress() {
        Object object = this.localNetworkAddress;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "localhost";
        }
        return object;
    }

    private final int getDefaultPort() {
        return URLProtocol.Companion.createOrDefault(this.getScheme()).getDefaultPort();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.localNetworkAddress;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : this.getDefaultPort();
    }

    @Override
    public int getServerPort() {
        String string;
        String string2;
        CharSequence charSequence = this.nettyHeaders.authority();
        return charSequence != null && (string2 = ((Object)charSequence).toString()) != null && (string = StringsKt.substringAfter((String)string2, (String)":", (String)String.valueOf(this.getDefaultPort()))) != null ? Integer.parseInt(string) : this.getLocalPort();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getRemoteHost() {
        String string;
        InetSocketAddress inetSocketAddress = this.remoteNetworkAddress;
        if (inetSocketAddress == null) return "unknown";
        InetSocketAddress it = inetSocketAddress;
        boolean bl = false;
        String string2 = it.getHostName();
        if (string2 == null) {
            string2 = it.getAddress().getHostAddress();
        }
        if ((string = string2) == null) return "unknown";
        String string3 = string;
        return string3;
    }

    @Override
    public int getRemotePort() {
        InetSocketAddress inetSocketAddress = this.remoteNetworkAddress;
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 0;
    }

    @Override
    @NotNull
    public String getRemoteAddress() {
        Object object = this.remoteNetworkAddress;
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "unknown";
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "Http2LocalConnectionPoint(uri=" + this.getUri() + ", method=" + this.getMethod() + ", version=" + this.getVersion() + ", localAddress=" + this.getLocalAddress() + ", localPort=" + this.getLocalPort() + ", remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ')';
    }
}

