/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.io;

import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.annotations.J2ktIncompatible;
import app.simplecloud.relocate.google.common.base.Optional;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.base.Predicate;
import app.simplecloud.relocate.google.common.collect.ImmutableList;
import app.simplecloud.relocate.google.common.collect.Iterables;
import app.simplecloud.relocate.google.common.graph.Traverser;
import app.simplecloud.relocate.google.common.io.ByteSink;
import app.simplecloud.relocate.google.common.io.ByteSource;
import app.simplecloud.relocate.google.common.io.ByteStreams;
import app.simplecloud.relocate.google.common.io.CharSink;
import app.simplecloud.relocate.google.common.io.CharSource;
import app.simplecloud.relocate.google.common.io.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.io.InsecureRecursiveDeleteException;
import app.simplecloud.relocate.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class MoreFiles {
    private MoreFiles() {
    }

    public static ByteSource asByteSource(Path path2, OpenOption ... options2) {
        return new PathByteSource(path2, options2);
    }

    public static ByteSink asByteSink(Path path2, OpenOption ... options2) {
        return new PathByteSink(path2, options2);
    }

    public static CharSource asCharSource(Path path2, Charset charset, OpenOption ... options2) {
        return MoreFiles.asByteSource(path2, options2).asCharSource(charset);
    }

    public static CharSink asCharSink(Path path2, Charset charset, OpenOption ... options2) {
        return MoreFiles.asByteSink(path2, options2).asCharSink(charset);
    }

    public static ImmutableList<Path> listFiles(Path dir) throws IOException {
        ImmutableList<Path> immutableList;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
            try {
                immutableList = ImmutableList.copyOf(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException e) {
                    throw e.getCause();
                }
            }
            stream.close();
        }
        return immutableList;
    }

    public static Traverser<Path> fileTraverser() {
        return Traverser.forTree(MoreFiles::fileTreeChildren);
    }

    private static Iterable<Path> fileTreeChildren(Path dir) {
        if (Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
            try {
                return MoreFiles.listFiles(dir);
            }
            catch (IOException e) {
                throw new DirectoryIteratorException(e);
            }
        }
        return ImmutableList.of();
    }

    public static Predicate<Path> isDirectory(LinkOption ... options2) {
        final LinkOption[] optionsCopy = (LinkOption[])options2.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input2) {
                return Files.isDirectory(input2, optionsCopy);
            }

            public String toString() {
                return "MoreFiles.isDirectory(" + Arrays.toString(optionsCopy) + ")";
            }
        };
    }

    private static boolean isDirectory(SecureDirectoryStream<Path> dir, Path name, LinkOption ... options2) throws IOException {
        return dir.getFileAttributeView(name, BasicFileAttributeView.class, options2).readAttributes().isDirectory();
    }

    public static Predicate<Path> isRegularFile(LinkOption ... options2) {
        final LinkOption[] optionsCopy = (LinkOption[])options2.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input2) {
                return Files.isRegularFile(input2, optionsCopy);
            }

            public String toString() {
                return "MoreFiles.isRegularFile(" + Arrays.toString(optionsCopy) + ")";
            }
        };
    }

    public static boolean equal(Path path1, Path path2) throws IOException {
        Preconditions.checkNotNull(path1);
        Preconditions.checkNotNull(path2);
        if (Files.isSameFile(path1, path2)) {
            return true;
        }
        ByteSource source1 = MoreFiles.asByteSource(path1, new OpenOption[0]);
        ByteSource source2 = MoreFiles.asByteSource(path2, new OpenOption[0]);
        long len1 = source1.sizeIfKnown().or(0L);
        long len2 = source2.sizeIfKnown().or(0L);
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return source1.contentEquals(source2);
    }

    public static void touch(Path path2) throws IOException {
        Preconditions.checkNotNull(path2);
        try {
            Files.setLastModifiedTime(path2, FileTime.fromMillis(System.currentTimeMillis()));
        }
        catch (NoSuchFileException e) {
            try {
                Files.createFile(path2, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    public static void createParentDirectories(Path path2, FileAttribute<?> ... attrs) throws IOException {
        Path normalizedAbsolutePath = path2.toAbsolutePath().normalize();
        Path parent = normalizedAbsolutePath.getParent();
        if (parent == null) {
            return;
        }
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            Files.createDirectories(parent, attrs);
            if (!Files.isDirectory(parent, new LinkOption[0])) {
                throw new IOException("Unable to create parent directories of " + path2);
            }
        }
    }

    public static String getFileExtension(Path path2) {
        Path name = path2.getFileName();
        if (name == null) {
            return "";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getNameWithoutExtension(Path path2) {
        Path name = path2.getFileName();
        if (name == null) {
            return "";
        }
        String fileName = name.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static void deleteRecursively(Path path2, RecursiveDeleteOption ... options2) throws IOException {
        Path parentPath = MoreFiles.getParentPath(path2);
        if (parentPath == null) {
            throw new FileSystemException(path2.toString(), null, "can't delete recursively");
        }
        Collection<IOException> exceptions = null;
        try {
            boolean sdsSupported = false;
            try (DirectoryStream<Path> parent = Files.newDirectoryStream(parentPath);){
                if (parent instanceof SecureDirectoryStream) {
                    sdsSupported = true;
                    exceptions = MoreFiles.deleteRecursivelySecure((SecureDirectoryStream)parent, Objects.requireNonNull(path2.getFileName()));
                }
            }
            if (!sdsSupported) {
                MoreFiles.checkAllowsInsecure(path2, options2);
                exceptions = MoreFiles.deleteRecursivelyInsecure(path2);
            }
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add(e);
        }
        if (exceptions != null) {
            MoreFiles.throwDeleteFailed(path2, exceptions);
        }
    }

    public static void deleteDirectoryContents(Path path2, RecursiveDeleteOption ... options2) throws IOException {
        Collection<IOException> exceptions = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2);){
            if (stream instanceof SecureDirectoryStream) {
                SecureDirectoryStream sds = (SecureDirectoryStream)stream;
                exceptions = MoreFiles.deleteDirectoryContentsSecure(sds);
            } else {
                MoreFiles.checkAllowsInsecure(path2, options2);
                exceptions = MoreFiles.deleteDirectoryContentsInsecure(stream);
            }
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add(e);
        }
        if (exceptions != null) {
            MoreFiles.throwDeleteFailed(path2, exceptions);
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteRecursivelySecure(SecureDirectoryStream<Path> dir, Path path2) {
        Collection<IOException> exceptions = null;
        try {
            if (MoreFiles.isDirectory(dir, path2, LinkOption.NOFOLLOW_LINKS)) {
                try (SecureDirectoryStream<Path> childDir = dir.newDirectoryStream(path2, LinkOption.NOFOLLOW_LINKS);){
                    exceptions = MoreFiles.deleteDirectoryContentsSecure(childDir);
                }
                if (exceptions == null) {
                    dir.deleteDirectory(path2);
                }
            } else {
                dir.deleteFile(path2);
            }
            return exceptions;
        }
        catch (IOException e) {
            return MoreFiles.addException(exceptions, e);
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteDirectoryContentsSecure(SecureDirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            for (Path path2 : dir) {
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelySecure(dir, path2.getFileName()));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            return MoreFiles.addException(exceptions, e.getCause());
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteRecursivelyInsecure(Path path2) {
        Collection<IOException> exceptions = null;
        try {
            if (Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2);){
                    exceptions = MoreFiles.deleteDirectoryContentsInsecure(stream);
                }
            }
            if (exceptions == null) {
                Files.delete(path2);
            }
            return exceptions;
        }
        catch (IOException e) {
            return MoreFiles.addException(exceptions, e);
        }
    }

    @CheckForNull
    private static Collection<IOException> deleteDirectoryContentsInsecure(DirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            for (Path entry : dir) {
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelyInsecure(entry));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            return MoreFiles.addException(exceptions, e.getCause());
        }
    }

    @CheckForNull
    private static Path getParentPath(Path path2) {
        Path parent = path2.getParent();
        if (parent != null) {
            return parent;
        }
        if (path2.getNameCount() == 0) {
            return null;
        }
        return path2.getFileSystem().getPath(".", new String[0]);
    }

    private static void checkAllowsInsecure(Path path2, RecursiveDeleteOption[] options2) throws InsecureRecursiveDeleteException {
        if (!Arrays.asList(options2).contains((Object)RecursiveDeleteOption.ALLOW_INSECURE)) {
            throw new InsecureRecursiveDeleteException(path2.toString());
        }
    }

    private static Collection<IOException> addException(@CheckForNull Collection<IOException> exceptions, IOException e) {
        if (exceptions == null) {
            exceptions = new ArrayList<IOException>();
        }
        exceptions.add(e);
        return exceptions;
    }

    @CheckForNull
    private static Collection<IOException> concat(@CheckForNull Collection<IOException> exceptions, @CheckForNull Collection<IOException> other) {
        if (exceptions == null) {
            return other;
        }
        if (other != null) {
            exceptions.addAll(other);
        }
        return exceptions;
    }

    private static void throwDeleteFailed(Path path2, Collection<IOException> exceptions) throws FileSystemException {
        NoSuchFileException pathNotFound = MoreFiles.pathNotFound(path2, exceptions);
        if (pathNotFound != null) {
            throw pathNotFound;
        }
        FileSystemException deleteFailed = new FileSystemException(path2.toString(), null, "failed to delete one or more files; see suppressed exceptions for details");
        for (IOException e : exceptions) {
            deleteFailed.addSuppressed(e);
        }
        throw deleteFailed;
    }

    @CheckForNull
    private static NoSuchFileException pathNotFound(Path path2, Collection<IOException> exceptions) {
        if (exceptions.size() != 1) {
            return null;
        }
        IOException exception = Iterables.getOnlyElement(exceptions);
        if (!(exception instanceof NoSuchFileException)) {
            return null;
        }
        NoSuchFileException noSuchFileException = (NoSuchFileException)exception;
        String exceptionFile = noSuchFileException.getFile();
        if (exceptionFile == null) {
            return null;
        }
        Path parentPath = MoreFiles.getParentPath(path2);
        if (parentPath == null) {
            return null;
        }
        Path pathResolvedFromParent = parentPath.resolve(Objects.requireNonNull(path2.getFileName()));
        if (exceptionFile.equals(pathResolvedFromParent.toString())) {
            return noSuchFileException;
        }
        return null;
    }

    private static final class PathByteSource
    extends ByteSource {
        private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
        private final Path path;
        private final OpenOption[] options;
        private final boolean followLinks;

        private PathByteSource(Path path2, OpenOption ... options2) {
            this.path = Preconditions.checkNotNull(path2);
            this.options = (OpenOption[])options2.clone();
            this.followLinks = PathByteSource.followLinks(this.options);
        }

        private static boolean followLinks(OpenOption[] options2) {
            for (OpenOption option2 : options2) {
                if (option2 != LinkOption.NOFOLLOW_LINKS) continue;
                return false;
            }
            return true;
        }

        @Override
        public InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, this.options);
        }

        private BasicFileAttributes readAttributes() throws IOException {
            LinkOption[] linkOptionArray;
            if (this.followLinks) {
                linkOptionArray = FOLLOW_LINKS;
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[1];
                linkOptionArray = linkOptionArray2;
                linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
            }
            return Files.readAttributes(this.path, BasicFileAttributes.class, linkOptionArray);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            BasicFileAttributes attrs;
            try {
                attrs = this.readAttributes();
            }
            catch (IOException e) {
                return Optional.absent();
            }
            if (attrs.isDirectory() || attrs.isSymbolicLink()) {
                return Optional.absent();
            }
            return Optional.of(attrs.size());
        }

        @Override
        public long size() throws IOException {
            BasicFileAttributes attrs = this.readAttributes();
            if (attrs.isDirectory()) {
                throw new IOException("can't read: is a directory");
            }
            if (attrs.isSymbolicLink()) {
                throw new IOException("can't read: is a symbolic link");
            }
            return attrs.size();
        }

        @Override
        public byte[] read() throws IOException {
            try (SeekableByteChannel channel2 = Files.newByteChannel(this.path, this.options);){
                byte[] byArray = ByteStreams.toByteArray(Channels.newInputStream(channel2), channel2.size());
                return byArray;
            }
        }

        @Override
        public CharSource asCharSource(Charset charset) {
            if (this.options.length == 0) {
                return new ByteSource.AsCharSource(charset){

                    @Override
                    public Stream<String> lines() throws IOException {
                        return Files.lines(path, this.charset);
                    }
                };
            }
            return super.asCharSource(charset);
        }

        public String toString() {
            return "MoreFiles.asByteSource(" + this.path + ", " + Arrays.toString(this.options) + ")";
        }
    }

    private static final class PathByteSink
    extends ByteSink {
        private final Path path;
        private final OpenOption[] options;

        private PathByteSink(Path path2, OpenOption ... options2) {
            this.path = Preconditions.checkNotNull(path2);
            this.options = (OpenOption[])options2.clone();
        }

        @Override
        public OutputStream openStream() throws IOException {
            return Files.newOutputStream(this.path, this.options);
        }

        public String toString() {
            return "MoreFiles.asByteSink(" + this.path + ", " + Arrays.toString(this.options) + ")";
        }
    }
}

