/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.stub;

import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.CallCredentials;
import app.simplecloud.relocate.io.grpc.CallOptions;
import app.simplecloud.relocate.io.grpc.Channel;
import app.simplecloud.relocate.io.grpc.ClientInterceptor;
import app.simplecloud.relocate.io.grpc.ClientInterceptors;
import app.simplecloud.relocate.io.grpc.Deadline;
import app.simplecloud.relocate.io.grpc.ExperimentalApi;
import app.simplecloud.relocate.io.grpc.InternalTimeUtils;
import com.google.errorprone.annotations.CheckReturnValue;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@CheckReturnValue
@ThreadSafe
public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel2) {
        this(channel2, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel2, CallOptions callOptions) {
        this.channel = Preconditions.checkNotNull(channel2, "channel");
        this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public static <T extends AbstractStub<T>> T newStub(StubFactory<T> factory, Channel channel2) {
        return AbstractStub.newStub(factory, channel2, CallOptions.DEFAULT);
    }

    public static <T extends AbstractStub<T>> T newStub(StubFactory<T> factory, Channel channel2, CallOptions callOptions) {
        return factory.newStub(channel2, callOptions);
    }

    public final S withDeadline(@Nullable Deadline deadline) {
        return this.build(this.channel, this.callOptions.withDeadline(deadline));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    @IgnoreJRERequirement
    public final S withDeadlineAfter(Duration duration) {
        return this.withDeadlineAfter(InternalTimeUtils.convert(duration), TimeUnit.NANOSECONDS);
    }

    public final S withExecutor(Executor executor2) {
        return this.build(this.channel, this.callOptions.withExecutor(executor2));
    }

    public final S withCompression(String compressorName) {
        return this.build(this.channel, this.callOptions.withCompression(compressorName));
    }

    @Deprecated
    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1869")
    public final <T> S withOption(CallOptions.Key<T> key2, T value) {
        return this.build(this.channel, this.callOptions.withOption(key2, value));
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept(this.channel, interceptors), this.callOptions);
    }

    public final S withCallCredentials(CallCredentials credentials) {
        return this.build(this.channel, this.callOptions.withCallCredentials(credentials));
    }

    public final S withWaitForReady() {
        return this.build(this.channel, this.callOptions.withWaitForReady());
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxInboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxInboundMessageSize(maxSize));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxOutboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxOutboundMessageSize(maxSize));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11021")
    public final S withOnReadyThreshold(int numBytes) {
        return this.build(this.channel, this.callOptions.withOnReadyThreshold(numBytes));
    }

    public static interface StubFactory<T extends AbstractStub<T>> {
        public T newStub(Channel var1, CallOptions var2);
    }
}

