/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpPlainTextConfig;
import io.ktor.client.plugins.HttpPlainTextKt;
import io.ktor.client.plugins.RenderRequestHook;
import io.ktor.client.plugins.api.ClientPlugin;
import io.ktor.client.plugins.api.ClientPluginBuilder;
import io.ktor.client.plugins.api.CreatePluginUtilsKt;
import io.ktor.client.plugins.api.TransformResponseBodyContext;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.TextContent;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelOperationsKt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Charsets;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a.\u0010\u0006\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00002\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\"\u0018\u0010\n\u001a\u00060\bj\u0002`\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\"\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lio/ktor/client/HttpClientConfig;", "Lkotlin/Function1;", "Lio/ktor/client/plugins/HttpPlainTextConfig;", "", "Lkotlin/ExtensionFunctionType;", "block", "Charsets", "(Lio/ktor/client/HttpClientConfig;Lkotlin/jvm/functions/Function1;)V", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/client/plugins/api/ClientPlugin;", "HttpPlainText", "Lio/ktor/client/plugins/api/ClientPlugin;", "getHttpPlainText", "()Lio/ktor/client/plugins/api/ClientPlugin;", "ktor-client-core"})
@SourceDebugExtension(value={"SMAP\nHttpPlainText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpPlainText.kt\nio/ktor/client/plugins/HttpPlainTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1062#2:168\n774#2:169\n865#2,2:170\n1053#2:172\n1863#2,2:173\n1863#2,2:175\n*S KotlinDebug\n*F\n+ 1 HttpPlainText.kt\nio/ktor/client/plugins/HttpPlainTextKt\n*L\n68#1:168\n71#1:169\n71#1:170,2\n72#1:172\n75#1:173,2\n80#1:175,2\n*E\n"})
public final class HttpPlainTextKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.client.plugins.HttpPlainText");
    @NotNull
    private static final ClientPlugin<HttpPlainTextConfig> HttpPlainText = CreatePluginUtilsKt.createClientPlugin("HttpPlainText", HttpPlainText.1.INSTANCE, HttpPlainTextKt::HttpPlainText$lambda$6);

    @NotNull
    public static final ClientPlugin<HttpPlainTextConfig> getHttpPlainText() {
        return HttpPlainText;
    }

    public static final void Charsets(@NotNull HttpClientConfig<?> $this$Charsets, @NotNull Function1<? super HttpPlainTextConfig, Unit> block) {
        Intrinsics.checkNotNullParameter($this$Charsets, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        $this$Charsets.install((HttpClientPlugin)HttpPlainText, block);
    }

    private static final OutgoingContent HttpPlainText$lambda$6$wrapContent(Charset requestCharset, HttpRequestBuilder request2, String content2, ContentType requestContentType) {
        Object object;
        ContentType contentType;
        ContentType contentType2 = requestContentType;
        if (contentType2 == null) {
            contentType2 = contentType = ContentType.Text.INSTANCE.getPlain();
        }
        if ((object = requestContentType) == null || (object = ContentTypesKt.charset((HeaderValueWithParameters)object)) == null) {
            object = requestCharset;
        }
        Object charset = object;
        LOGGER.trace("Sending request body to " + request2.getUrl() + " as text/plain with charset " + charset);
        return new TextContent(content2, ContentTypesKt.withCharset(contentType, (Charset)charset), null, 4, null);
    }

    private static final String HttpPlainText$lambda$6$read(Charset responseCharsetFallback, HttpClientCall call, Source body2) {
        Charset charset = HttpMessagePropertiesKt.charset(call.getResponse());
        if (charset == null) {
            charset = responseCharsetFallback;
        }
        Charset actualCharset = charset;
        LOGGER.trace("Reading response body for " + call.getRequest().getUrl() + " as String with charset " + actualCharset);
        return StringsKt.readText$default(body2, actualCharset, 0, 2, null);
    }

    private static final void HttpPlainText$lambda$6$addCharsetHeaders(String acceptCharsetHeader, HttpRequestBuilder context) {
        if (context.getHeaders().get(HttpHeaders.INSTANCE.getAcceptCharset()) != null) {
            return;
        }
        LOGGER.trace("Adding Accept-Charset=" + acceptCharsetHeader + " to " + context.getUrl());
        context.getHeaders().set(HttpHeaders.INSTANCE.getAcceptCharset(), acceptCharsetHeader);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit HttpPlainText$lambda$6(ClientPluginBuilder $this$createClientPlugin) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter($this$createClientPlugin, "$this$createClientPlugin");
        Iterable $this$sortedByDescending$iv = MapsKt.toList(((HttpPlainTextConfig)$this$createClientPlugin.getPluginConfig()).getCharsetQuality$ktor_client_core());
        boolean $i$f$sortedByDescending = false;
        List withQuality = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getSecond()));
            }
        });
        Charset responseCharsetFallback = ((HttpPlainTextConfig)$this$createClientPlugin.getPluginConfig()).getResponseCharsetFallback();
        Iterable iterable = ((HttpPlainTextConfig)$this$createClientPlugin.getPluginConfig()).getCharsets$ktor_client_core();
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Charset it = (Charset)element$iv$iv;
            boolean bl = false;
            if (!(!((HttpPlainTextConfig)$this$createClientPlugin.getPluginConfig()).getCharsetQuality$ktor_client_core().containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List withoutQuality = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Charset it = (Charset)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)CharsetJVMKt.getName(it));
                it = (Charset)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)CharsetJVMKt.getName(it)));
            }
        });
        StringBuilder $this$HttpPlainText_u24lambda_u246_u24lambda_u245 = $i$f$sortedBy = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = withoutQuality;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Charset it = (Charset)element$iv;
            boolean bl2 = false;
            if (((CharSequence)$this$HttpPlainText_u24lambda_u246_u24lambda_u245).length() > 0) {
                $this$HttpPlainText_u24lambda_u246_u24lambda_u245.append(",");
            }
            $this$HttpPlainText_u24lambda_u246_u24lambda_u245.append(CharsetJVMKt.getName(it));
        }
        $this$forEach$iv = withQuality;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double d;
            Pair pair = (Pair)element$iv;
            boolean bl3 = false;
            Charset charset = (Charset)pair.component1();
            float quality = ((Number)pair.component2()).floatValue();
            if (((CharSequence)$this$HttpPlainText_u24lambda_u246_u24lambda_u245).length() > 0) {
                $this$HttpPlainText_u24lambda_u246_u24lambda_u245.append(",");
            }
            if (!(0.0 <= (d = (double)quality) ? d <= 1.0 : false)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            double truncatedQuality = (double)MathKt.roundToInt((float)100 * quality) / 100.0;
            $this$HttpPlainText_u24lambda_u246_u24lambda_u245.append(CharsetJVMKt.getName(charset) + ";q=" + truncatedQuality);
        }
        if (((CharSequence)$this$HttpPlainText_u24lambda_u246_u24lambda_u245).length() == 0) {
            $this$HttpPlainText_u24lambda_u246_u24lambda_u245.append(CharsetJVMKt.getName(responseCharsetFallback));
        }
        String string = $i$f$sortedBy.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String acceptCharsetHeader = string;
        Charset charset = ((HttpPlainTextConfig)$this$createClientPlugin.getPluginConfig()).getSendCharset();
        if (charset == null && (charset = (Charset)CollectionsKt.firstOrNull(withoutQuality)) == null) {
            Pair pair = (Pair)CollectionsKt.firstOrNull(withQuality);
            charset = pair != null ? (Charset)pair.getFirst() : null;
            if (charset == null) {
                charset = Charsets.UTF_8;
            }
        }
        Charset requestCharset = charset;
        $this$createClientPlugin.on(RenderRequestHook.INSTANCE, new Function3<HttpRequestBuilder, Object, Continuation<? super OutgoingContent>, Object>(acceptCharsetHeader, requestCharset, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ String $acceptCharsetHeader;
            final /* synthetic */ Charset $requestCharset;
            {
                this.$acceptCharsetHeader = $acceptCharsetHeader;
                this.$requestCharset = $requestCharset;
                super(3, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        HttpRequestBuilder request2 = (HttpRequestBuilder)this.L$0;
                        Object content2 = this.L$1;
                        HttpPlainTextKt.access$HttpPlainText$lambda$6$addCharsetHeaders(this.$acceptCharsetHeader, request2);
                        if (!(content2 instanceof String)) {
                            return null;
                        }
                        ContentType contentType = HttpMessagePropertiesKt.contentType(request2);
                        if (contentType != null && !Intrinsics.areEqual(contentType.getContentType(), ContentType.Text.INSTANCE.getPlain().getContentType())) {
                            return null;
                        }
                        return HttpPlainTextKt.access$HttpPlainText$lambda$6$wrapContent(this.$requestCharset, request2, (String)content2, contentType);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(HttpRequestBuilder p1, Object p2, Continuation<? super OutgoingContent> p3) {
                Function3<HttpRequestBuilder, Object, Continuation<? super OutgoingContent>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                function3.L$1 = p2;
                return function3.invokeSuspend(Unit.INSTANCE);
            }
        });
        $this$createClientPlugin.transformResponseBody((Function5<TransformResponseBodyContext, HttpResponse, ByteReadChannel, TypeInfo, Continuation<Object>, Object>)new Function5<TransformResponseBodyContext, HttpResponse, ByteReadChannel, TypeInfo, Continuation<? super Object>, Object>(responseCharsetFallback, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;
            final /* synthetic */ Charset $responseCharsetFallback;
            {
                this.$responseCharsetFallback = $responseCharsetFallback;
                super(5, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        response = (HttpResponse)this.L$0;
                        content = (ByteReadChannel)this.L$1;
                        requestedType = (TypeInfo)this.L$2;
                        if (!Intrinsics.areEqual(requestedType.getType(), Reflection.getOrCreateKotlinClass(String.class))) {
                            return null;
                        }
                        this.L$0 = response;
                        this.L$1 = null;
                        this.label = 1;
                        v0 = ByteReadChannelOperationsKt.readRemaining(content, this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        response = (HttpResponse)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        bodyBytes = (Source)v0;
                        return HttpPlainTextKt.access$HttpPlainText$lambda$6$read(this.$responseCharsetFallback, response.getCall(), bodyBytes);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(TransformResponseBodyContext p1, HttpResponse p2, ByteReadChannel p3, TypeInfo p4, Continuation<Object> p5) {
                Function5<TransformResponseBodyContext, HttpResponse, ByteReadChannel, TypeInfo, Continuation<? super Object>, Object> function5 = new /* invalid duplicate definition of identical inner class */;
                function5.L$0 = p2;
                function5.L$1 = p3;
                function5.L$2 = p4;
                return function5.invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$HttpPlainText$lambda$6$addCharsetHeaders(String acceptCharsetHeader, HttpRequestBuilder context) {
        HttpPlainTextKt.HttpPlainText$lambda$6$addCharsetHeaders(acceptCharsetHeader, context);
    }

    public static final /* synthetic */ OutgoingContent access$HttpPlainText$lambda$6$wrapContent(Charset requestCharset, HttpRequestBuilder request2, String content2, ContentType requestContentType) {
        return HttpPlainTextKt.HttpPlainText$lambda$6$wrapContent(requestCharset, request2, content2, requestContentType);
    }

    public static final /* synthetic */ String access$HttpPlainText$lambda$6$read(Charset responseCharsetFallback, HttpClientCall call, Source body2) {
        return HttpPlainTextKt.HttpPlainText$lambda$6$read(responseCharsetFallback, call, body2);
    }
}

