/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class UnmodifiableCollections {
    private UnmodifiableCollections() {
    }

    public static <E> List<E> copyOf(List<E> original) {
        switch (original.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(original.get(0));
            }
        }
        return Collections.unmodifiableList(new ArrayList<E>(original));
    }

    public static <E> Set<E> copyOf(Set<E> original) {
        switch (original.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(original.iterator().next());
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(original));
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> original) {
        switch (original.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = original.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        if (original instanceof LinkedHashMap) {
            return Collections.unmodifiableMap(new LinkedHashMap<K, V>(original));
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    @SafeVarargs
    public static <E> List<E> toList(E ... original) {
        switch (original.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(original[0]);
            }
        }
        return Collections.unmodifiableList(new ArrayList<E>(Arrays.asList(original)));
    }

    @SafeVarargs
    public static <E> Set<E> toSet(E ... original) {
        switch (original.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(original[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(original)));
    }

    public static <K, V> Map<K, V> buildMap(Consumer<Map<K, V>> handler) {
        LinkedHashMap builder2 = new LinkedHashMap();
        Objects.requireNonNull(handler, "handler").accept(builder2);
        return Collections.unmodifiableMap(builder2);
    }

    public static <K, V> Map.Entry<K, V> immutableMapEntry(K key2, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key2, value);
    }
}

